/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.restful;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.linkis.bml.common.BmlAuthorityException;
import org.apache.linkis.bml.service.ResourceService;
import org.apache.linkis.server.utils.ModuleUserUtils;

public class RestfulUtils {
    private static final Long SECOND = 1000L;
    private static final Long MINUTE = 60L * SECOND;
    private static final Long HOUR = 60L * MINUTE;
    public static final Long DAY = 24L * HOUR;
    private static final Long MONTH = 30L * DAY;
    private static final Long YEAR = 365L * DAY;

    public static String getUserName(HttpServletRequest request) throws BmlAuthorityException {
        String user;
        try {
            user = ModuleUserUtils.getOperationUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            throw new BmlAuthorityException();
        }
        return user;
    }

    public static boolean canAccessResource(String user, String resourceId, ResourceService resourceService) {
        return true;
    }

    public static String getExpireTime(Date createTime, String expireType, String expireTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String retTime = null;
        if ("date".equals(expireType)) {
            return expireTime;
        }
        int num = Integer.parseInt(expireTime.substring(0, expireTime.length() - 1));
        switch (expireTime.charAt(expireTime.length() - 1)) {
            case 'y': {
                retTime = simpleDateFormat.format(new Date(createTime.getTime() + (long)num * YEAR));
                break;
            }
            case 'M': {
                retTime = simpleDateFormat.format(new Date(createTime.getTime() + (long)num * MONTH));
                break;
            }
            case 'd': {
                retTime = simpleDateFormat.format(new Date(createTime.getTime() + (long)num * DAY));
                break;
            }
            case 'H': {
                retTime = simpleDateFormat.format(new Date(createTime.getTime() + (long)num * HOUR));
                break;
            }
            case 'm': {
                retTime = simpleDateFormat.format(new Date(createTime.getTime() + (long)num * MINUTE));
                break;
            }
            default: {
                retTime = simpleDateFormat.format(new Date(createTime.getTime() + 10L * DAY));
            }
        }
        return retTime;
    }
}

