/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.cs;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.cs.client.service.CSTableService;
import org.apache.linkis.cs.client.utils.ContextServiceUtils;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.metadata.CSColumn;
import org.apache.linkis.cs.common.entity.metadata.CSTable;
import org.apache.linkis.cs.common.entity.source.CommonContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.utils.CSCommonUtils;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.storage.domain.Column;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class CSTableRegister$
implements Logging {
    public static CSTableRegister$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new CSTableRegister$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        CSTableRegister$ cSTableRegister$ = this;
        synchronized (cSTableRegister$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void registerTempTable(EngineExecutionContext engineExecutionContext, ResultSetWriter<? extends MetaData, ? extends Record> writer, String alias, Column[] columns) {
        String contextIDValueStr = ContextServiceUtils.getContextIDStrByMap(engineExecutionContext.getProperties());
        String nodeNameStr = ContextServiceUtils.getNodeNameStrByMap(engineExecutionContext.getProperties());
        if (StringUtils.isNotBlank((CharSequence)contextIDValueStr) && StringUtils.isNotBlank((CharSequence)nodeNameStr)) {
            String string;
            this.logger().info(new StringBuilder(37).append("Start to register TempTable nodeName:").append(nodeNameStr).toString());
            writer.flush();
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                string = new StringBuilder(8).append("cs_tmp_").append(nodeNameStr).append("_").append(alias).toString();
            } else {
                int i = 1;
                String rsName = null;
                while (StringUtils.isEmpty(rsName)) {
                    String tmpTable = new StringBuilder(10).append("cs_tmp_").append(nodeNameStr).append("_rs").append(i).toString();
                    ++i;
                    CommonContextKey contextKey = new CommonContextKey();
                    contextKey.setContextScope(ContextScope.FRIENDLY);
                    contextKey.setContextType(ContextType.METADATA);
                    contextKey.setKey(CSCommonUtils.getTableKey((String)nodeNameStr, (String)tmpTable));
                    CSTable table = CSTableService.getInstance().getCSTable(contextIDValueStr, SerializeHelper.serializeContextKey((ContextKey)contextKey));
                    if (table != null) continue;
                    rsName = tmpTable;
                }
                string = rsName;
            }
            String tableName = string;
            CSTable csTable = new CSTable();
            csTable.setName(tableName);
            csTable.setAlias(alias);
            csTable.setAvailable(Predef$.MODULE$.boolean2Boolean(true));
            csTable.setComment("cs temp table");
            csTable.setCreateTime(new Date());
            csTable.setCreator(StorageUtils$.MODULE$.getJvmUser());
            csTable.setExternalUse(Predef$.MODULE$.boolean2Boolean(true));
            csTable.setImport(Predef$.MODULE$.boolean2Boolean(false));
            csTable.setLocation(writer.toString());
            csTable.setPartitionTable(Predef$.MODULE$.boolean2Boolean(false));
            csTable.setView(Predef$.MODULE$.boolean2Boolean(true));
            CSColumn[] csColumns = (CSColumn[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).map((Function1 & Serializable & scala.Serializable)column -> {
                CSColumn csColumn = new CSColumn();
                csColumn.setName(column.columnName());
                csColumn.setType(column.dataType().typeName());
                csColumn.setComment(column.comment());
                return csColumn;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CSColumn.class)));
            csTable.setColumns(csColumns);
            CommonContextKey contextKey = new CommonContextKey();
            contextKey.setContextScope(ContextScope.PUBLIC);
            contextKey.setContextType(ContextType.METADATA);
            contextKey.setKey(CSCommonUtils.getTableKey((String)nodeNameStr, (String)tableName));
            CSTableService.getInstance().putCSTable(contextIDValueStr, SerializeHelper.serializeContextKey((ContextKey)contextKey), csTable);
            this.logger().info(new StringBuilder(40).append("Finished to register TempTable nodeName:").append(nodeNameStr).toString());
            return;
        }
    }

    private CSTableRegister$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

