/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.core.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class PortUtils$
implements Logging {
    public static PortUtils$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PortUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        PortUtils$ portUtils$ = this;
        synchronized (portUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public int findAvailPortByRange(String portRange) {
        String separator = "-";
        if (StringUtils.isEmpty((CharSequence)portRange) || portRange.equals(separator)) {
            return this.findAvailPort();
        }
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(1024, 65535);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int start = sp2._1$mcI$sp();
        int end = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(start, end);
        int start2 = sp3._1$mcI$sp();
        int end2 = sp3._2$mcI$sp();
        String[] ports = portRange.split(separator, -1);
        if (!ports[0].isEmpty()) {
            start2 = new StringOps(Predef$.MODULE$.augmentString(ports[0])).toInt();
        }
        if (!ports[1].isEmpty()) {
            end2 = new StringOps(Predef$.MODULE$.augmentString(ports[1])).toInt();
        }
        Option availablePort = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end2).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)port -> {
            boolean bl;
            try {
                new ServerSocket(port).close();
                bl = true;
            }
            catch (IOException ioe) {
                bl = false;
            }
            return bl;
        });
        return BoxesRunTime.unboxToInt((Object)availablePort.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IOException(new StringBuilder(36).append("No available port in the portRange: ").append(portRange).toString());
        }));
    }

    public int findAvailPort() {
        ServerSocket socket = new ServerSocket(0);
        return BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> socket.getLocalPort(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((ServerSocket)socket)));
    }

    public Properties readFromProperties(String propertiesFile) {
        Properties properties = new Properties();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(propertiesFile));
                properties.load(reader);
            }
            catch (Exception e) {
                this.logger().warn(new StringBuilder(41).append("loading vsersion faild with path ").append(propertiesFile).append("  error:").append(e).toString());
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                this.logger().warn(new StringBuilder(40).append("try to close buffered reader with error:").append(e.getMessage()).toString());
            }
        }
        return properties;
    }

    private PortUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

