/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.ecm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.manager.common.protocol.engine.EngineAskRequest;
import org.apache.linkis.manager.label.entity.engine.ReuseExclusionLabel;
import org.apache.linkis.manager.label.entity.entrance.BindEngineLabel;
import org.apache.linkis.manager.label.entity.entrance.LoadBalanceLabel;
import org.apache.linkis.orchestrator.computation.physical.CodeLogicalUnitExecTask;
import org.apache.linkis.orchestrator.ecm.ComputationEngineConnManager;
import org.apache.linkis.orchestrator.ecm.conf.ECMPluginConf$;
import org.apache.linkis.orchestrator.ecm.entity.DefaultMark;
import org.apache.linkis.orchestrator.ecm.entity.LoadBalanceMark;
import org.apache.linkis.orchestrator.ecm.entity.Mark;
import org.apache.linkis.orchestrator.ecm.entity.MarkReq;
import org.apache.linkis.orchestrator.ecm.entity.MarkReq$;
import org.apache.linkis.orchestrator.ecm.entity.Policy;
import org.apache.linkis.orchestrator.ecm.exception.ECMPluginErrorException;
import org.apache.linkis.orchestrator.ecm.service.EngineConnExecutor;
import org.apache.linkis.server.BDPJettyServerHelper$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.BufferLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\n\u0015\u0001}AQ\u0001\f\u0001\u0005\u00025Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004F\u0001\u0001\u0006I!\r\u0005\b\r\u0002\u0011\r\u0011\"\u0003H\u0011\u00191\u0006\u0001)A\u0005\u0011\")q\u000b\u0001C\u00051\")A\f\u0001C\u0005;\"9q\f\u0001b\u0001\n\u0013\u0001\u0007BB4\u0001A\u0003%\u0011\rC\u0003i\u0001\u0011%\u0011\u000eC\u0003q\u0001\u0011\u0005\u0013\u000fC\u0003t\u0001\u0011\u0005C\u000fC\u0003w\u0001\u0011%q\u000fC\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u0011Q\u0007\u0001\u0005\n\u0005]\u0002bBA$\u0001\u0011E\u0011\u0011\n\u0005\b\u0003#\u0002A\u0011IA*\u0005\u0005bu.\u00193CC2\fgnY3MC\n,G.\u00128hS:,7i\u001c8o\u001b\u0006t\u0017mZ3s\u0015\t)b#A\u0002fG6T!a\u0006\r\u0002\u0019=\u00148\r[3tiJ\fGo\u001c:\u000b\u0005eQ\u0012A\u00027j].L7O\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0001\"\u0003CA\u0011#\u001b\u0005!\u0012BA\u0012\u0015\u0005q\u0019u.\u001c9vi\u0006$\u0018n\u001c8F]\u001eLg.Z\"p]:l\u0015M\\1hKJ\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000bU$\u0018\u000e\\:\u000b\u0005%B\u0012AB2p[6|g.\u0003\u0002,M\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001/!\t\t\u0003!A\nnCJ\\'+Z9B]\u0012l\u0015M]6DC\u000eDW-F\u00012!\u0011\u0011t'O \u000e\u0003MR!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002m\u0005!!.\u0019<b\u0013\tA4GA\u0004ICNDW*\u00199\u0011\u0005ijT\"A\u001e\u000b\u0005q\"\u0012AB3oi&$\u00180\u0003\u0002?w\t9Q*\u0019:l%\u0016\f\bc\u0001\u001aA\u0005&\u0011\u0011i\r\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002;\u0007&\u0011Ai\u000f\u0002\u0005\u001b\u0006\u00148.\u0001\u000bnCJ\\'+Z9B]\u0012l\u0015M]6DC\u000eDW\rI\u0001\u000eS\u0012$v.T1sW\u000e\u000b7\r[3\u0016\u0003!\u0003BAM\u001cJ\u0005B\u0011!j\u0015\b\u0003\u0017F\u0003\"\u0001T(\u000e\u00035S!A\u0014\u0010\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I{\u0015AD5e)>l\u0015M]6DC\u000eDW\rI\u0001\u0017O\u0016$X*\u0019:l%\u0016\f\u0018I\u001c3NCJ\\7)Y2iKR\t\u0011\f\u0005\u000335fz\u0014BA.4\u0005\ri\u0015\r]\u0001\u0011O\u0016$\u0018\n\u001a+p\u001b\u0006\u00148nQ1dQ\u0016$\u0012A\u0018\t\u0005eiK%)A\u000bN\u0003J[uLU#R?\u000e\u000b5\tS#`\u0019>\u001b5*\u0012*\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001Z\u001b\u0002\t1\fgnZ\u0005\u0003M\u000e\u0014aa\u00142kK\u000e$\u0018AF'B%.{&+R)`\u0007\u0006\u001b\u0005*R0M\u001f\u000e[UI\u0015\u0011\u0002%\u001d,G/T1sW:+XNQ=NCJ\u0014V-\u001d\u000b\u0003U:\u0004\"a\u001b7\u000e\u0003=K!!\\(\u0003\u0007%sG\u000fC\u0003p\u0015\u0001\u0007\u0011(A\u0004nCJ\\'+Z9\u0002\u0013\u0005\u0004\b\u000f\\=NCJ\\GC\u0001\"s\u0011\u0015y7\u00021\u0001:\u0003)\u0019'/Z1uK6\u000b'o\u001b\u000b\u0003\u0005VDQa\u001c\u0007A\u0002e\n\u0011#\u00193e\u001b\u0006\u00148NU3r\u0003:$W*\u0019:l)\rA80 \t\u0003WfL!A_(\u0003\tUs\u0017\u000e\u001e\u0005\u0006y6\u0001\r!O\u0001\u0004e\u0016\f\b\"\u0002@\u000e\u0001\u0004y\u0018\u0001B7be.\u00042AOA\u0001\u0013\r\t\u0019a\u000f\u0002\f\t\u00164\u0017-\u001e7u\u001b\u0006\u00148.\u0001\u0010hKR\fe/Y5mC\ndW-\u00128hS:,7i\u001c8o\u000bb,7-\u001e;peR1\u0011\u0011BA\u000b\u0003/\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f!\u0012aB:feZL7-Z\u0005\u0005\u0003'\tiA\u0001\nF]\u001eLg.Z\"p]:,\u00050Z2vi>\u0014\b\"\u0002@\u000f\u0001\u0004\u0011\u0005bBA\r\u001d\u0001\u0007\u00111D\u0001\tKb,7\rV1tWB!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001\u00039isNL7-\u00197\u000b\u0007\u0005\u0015b#A\u0006d_6\u0004X\u000f^1uS>t\u0017\u0002BA\u0015\u0003?\u0011qcQ8eK2{w-[2bYVs\u0017\u000e^#yK\u000e$\u0016m]6\u00023I,G.Z1tK\u0016sw-\u001b8f\u0007>tg.\u0012=fGV$xN\u001d\u000b\u0006q\u0006=\u00121\u0007\u0005\b\u0003cy\u0001\u0019AA\u0005\u0003I)gnZ5oK\u000e{gN\\#yK\u000e,Ho\u001c:\t\u000by|\u0001\u0019\u0001\"\u0002;I,G.Z1tK6\u000b'o[!oIN+'O^5dK&s7\u000f^1oG\u0016$R\u0001_A\u001d\u0003wAQA \tA\u0002\tCq!!\u0010\u0011\u0001\u0004\ty$A\btKJ4\u0018nY3J]N$\u0018M\\2f!\u0011\t\t%a\u0011\u000e\u0003!J1!!\u0012)\u0005=\u0019VM\u001d<jG\u0016Len\u001d;b]\u000e,\u0017aD4fi\u0006cG.\u00138ti\u0006t7-Z:\u0015\u0005\u0005-\u0003\u0003B6\u0002N%K1!a\u0014P\u0005\u0015\t%O]1z\u0003%9W\r\u001e)pY&\u001c\u0017\u0010\u0006\u0002\u0002VA\u0019!(a\u0016\n\u0007\u0005e3H\u0001\u0004Q_2L7-\u001f")
public class LoadBalanceLabelEngineConnManager
extends ComputationEngineConnManager {
    private final HashMap<MarkReq, List<Mark>> markReqAndMarkCache = new HashMap();
    private final HashMap<String, Mark> idToMarkCache = new HashMap();
    private final Object MARK_REQ_CACHE_LOCKER = new Object();

    private HashMap<MarkReq, List<Mark>> markReqAndMarkCache() {
        return this.markReqAndMarkCache;
    }

    private HashMap<String, Mark> idToMarkCache() {
        return this.idToMarkCache;
    }

    private Map<MarkReq, List<Mark>> getMarkReqAndMarkCache() {
        return this.markReqAndMarkCache();
    }

    private Map<String, Mark> getIdToMarkCache() {
        return this.idToMarkCache();
    }

    private Object MARK_REQ_CACHE_LOCKER() {
        return this.MARK_REQ_CACHE_LOCKER;
    }

    private int getMarkNumByMarReq(MarkReq markReq) {
        if (markReq.getLabels().containsKey("loadBalance")) {
            LoadBalanceLabel loadBalanceLabel = (LoadBalanceLabel)MarkReq$.MODULE$.getLabelBuilderFactory().createLabel("loadBalance", markReq.getLabels().get("loadBalance"));
            if (Predef$.MODULE$.Integer2int(loadBalanceLabel.getCapacity()) > 0) {
                return Predef$.MODULE$.Integer2int(loadBalanceLabel.getCapacity());
            }
            return BoxesRunTime.unboxToInt((Object)ECMPluginConf$.MODULE$.DEFAULT_LOADBALANCE_CAPACITY().getValue());
        }
        this.logger().error(new StringBuilder(44).append("There must be LoadBalanceLabel in markReq : ").append(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)markReq)).toString());
        return BoxesRunTime.unboxToInt((Object)ECMPluginConf$.MODULE$.DEFAULT_LOADBALANCE_CAPACITY().getValue());
    }

    @Override
    public Mark applyMark(MarkReq markReq) {
        Object object;
        if (markReq == null) {
            return null;
        }
        int markNum = this.getMarkNumByMarReq(markReq);
        int count = 0;
        if (this.getMarkReqAndMarkCache().containsKey(markReq)) {
            count = this.getMarkReqAndMarkCache().get(markReq).size();
        }
        while (count < markNum) {
            this.createMark(markReq);
            count = this.getMarkReqAndMarkCache().get(markReq).size();
        }
        List<Mark> markList = this.getMarkReqAndMarkCache().get(markReq);
        Mark chooseMark = null;
        if (markReq.getLabels().containsKey("bindEngine")) {
            Mark mark;
            BindEngineLabel bindEngineLabel = (BindEngineLabel)MarkReq$.MODULE$.getLabelBuilderFactory().createLabel("bindEngine", markReq.getLabels().get("bindEngine"));
            if (bindEngineLabel.getIsJobGroupHead()) {
                chooseMark = markList.get(new Random().nextInt(((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(markList).asScala()).length()));
                mark = this.getIdToMarkCache().put(bindEngineLabel.getJobGroupId(), chooseMark);
            } else {
                if (this.getIdToMarkCache().containsKey(bindEngineLabel.getJobGroupId())) {
                    chooseMark = this.getIdToMarkCache().get(bindEngineLabel.getJobGroupId());
                    List<ServiceInstance> insList = this.getMarkCache().get(chooseMark);
                    if (insList == null || insList.size() != 1) {
                        String msg = new StringBuilder(80).append("Engine instance releated to chooseMark : ").append(BDPJettyServerHelper$.MODULE$.gson().toJson((Object)chooseMark)).append(" with bindEngineLabel : ").append(bindEngineLabel.getStringValue()).append(" cannot be null").toString();
                        this.logger().error(msg);
                        throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_MARK_CACHE_ERROR_CODE(), msg);
                    }
                } else {
                    String msg = new StringBuilder(46).append("Cannot find mark").append(chooseMark.getMarkId()).append(" related to bindEngineLabel : ").append(bindEngineLabel.getStringValue()).toString();
                    this.logger().error(msg);
                    throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_MARK_CACHE_ERROR_CODE(), msg);
                }
                mark = BoxedUnit.UNIT;
            }
            if (bindEngineLabel.getIsJobGroupEnd()) {
                if (this.getIdToMarkCache().containsKey(bindEngineLabel.getJobGroupId())) {
                    this.logger().info(new StringBuilder(27).append("Start to remove mark").append(chooseMark.getMarkId()).append(" Cache ").append(bindEngineLabel.getStringValue()).toString());
                    object = this.getIdToMarkCache().remove(bindEngineLabel.getJobGroupId());
                } else {
                    this.logger().error(new StringBuilder(65).append("Cannot find mark").append(chooseMark.getMarkId()).append(" related to bindEngineLabel : ").append(bindEngineLabel.getStringValue()).append(", cannot remove it.").toString());
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            chooseMark = markList.get(new Random().nextInt(count));
            object = BoxedUnit.UNIT;
        }
        return chooseMark;
    }

    @Override
    public Mark createMark(MarkReq markReq) {
        LoadBalanceMark mark = new LoadBalanceMark(this.nextMarkId(), markReq);
        this.addMark(mark, new ArrayList<ServiceInstance>());
        this.addMarkReqAndMark(markReq, mark);
        return mark;
    }

    private void addMarkReqAndMark(MarkReq req, DefaultMark mark) {
        if (req != null) {
            Object object = this.MARK_REQ_CACHE_LOCKER();
            synchronized (object) {
                Object object2;
                List<Mark> markList = this.getMarkReqAndMarkCache().get(req);
                if (markList != null) {
                    Mark mayBeMark = (Mark)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(markList).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LoadBalanceLabelEngineConnManager.$anonfun$addMarkReqAndMark$1(mark, x$1))).orNull(Predef$.MODULE$.$conforms());
                    object2 = mayBeMark == null ? BoxesRunTime.boxToBoolean((boolean)markList.add(mark)) : BoxedUnit.UNIT;
                } else {
                    ArrayList<DefaultMark> markList2 = new ArrayList<DefaultMark>();
                    markList2.add(mark);
                    object2 = this.getMarkReqAndMarkCache().put(req, markList2);
                }
            }
            return;
        }
    }

    @Override
    public EngineConnExecutor getAvailableEngineConnExecutor(Mark mark, CodeLogicalUnitExecTask execTask) {
        if (mark != null && this.getMarkCache().containsKey(mark)) {
            Object object;
            Option<EngineConnExecutor> option = this.tryReuseEngineConnExecutor(mark);
            if (option instanceof Some) {
                Some some = (Some)option;
                EngineConnExecutor engineConnExecutor = (EngineConnExecutor)some.value();
                this.logger().info(new StringBuilder(30).append("mark ").append(mark.getMarkId()).append(" ReuseEngineConnExecutor ").append(engineConnExecutor).toString());
                return engineConnExecutor;
            }
            if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
            this.logger().info(new StringBuilder(36).append("mark ").append(mark.getMarkId()).append(" start to askEngineConnExecutor").toString());
            EngineAskRequest engineConnAskReq = mark.getMarkReq().createEngineConnAskReq();
            String[] existInstances = this.getAllInstances();
            if (existInstances != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existInstances)).nonEmpty()) {
                ReuseExclusionLabel reuseExclusionLabel = (ReuseExclusionLabel)MarkReq$.MODULE$.getLabelBuilderFactory().createLabel(ReuseExclusionLabel.class);
                reuseExclusionLabel.setInstances(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existInstances)).mkString(";"));
                object = engineConnAskReq.getLabels().put("reuseExclusion", reuseExclusionLabel.getValue());
            } else {
                object = BoxedUnit.UNIT;
            }
            EngineConnExecutor engineConnExecutor = this.askEngineConnExecutor(engineConnAskReq, mark, execTask);
            this.saveToMarkCache(mark, engineConnExecutor);
            this.logger().debug(new StringBuilder(59).append("mark ").append(mark.getMarkId()).append(" Finished to  getAvailableEngineConnExecutor by create").toString());
            return engineConnExecutor;
        }
        throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_ERROR_CODE(), "mark cannot be null");
    }

    @Override
    public void releaseEngineConnExecutor(EngineConnExecutor engineConnExecutor, Mark mark) {
        if (engineConnExecutor != null && mark != null && this.getMarkCache().containsKey(mark)) {
            this.logger().info(new StringBuilder(64).append("Start to release EngineConnExecutor mark id ").append(mark.getMarkId()).append(" engineConnExecutor ").append(engineConnExecutor.getServiceInstance()).toString());
            this.getEngineConnExecutorCache().remove(engineConnExecutor.getServiceInstance());
            engineConnExecutor.close();
            this.logger().info(new StringBuilder(55).append(" Start to release all mark relation to serviceInstance ").append(engineConnExecutor.getServiceInstance()).toString());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getMarksByInstance(engineConnExecutor.getServiceInstance()))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                this.releaseMarkAndServiceInstance(x$2, engineConnExecutor.getServiceInstance());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void releaseMarkAndServiceInstance(Mark mark, ServiceInstance serviceInstance) {
        this.logger().info(new StringBuilder(51).append(" Start to release mark").append(mark.getMarkId()).append(" relation to serviceInstance ").append(serviceInstance).toString());
        List<ServiceInstance> instances = this.getInstances(mark);
        if (instances != null) {
            instances.remove(serviceInstance);
            if (instances.isEmpty()) {
                this.releaseMark(mark);
            }
        }
        if (!this.getMarkCache().containsKey(mark)) {
            Object object = this.MARK_REQ_CACHE_LOCKER();
            synchronized (object) {
                Buffer newMarks;
                List<Mark> marks = this.getMarkReqAndMarkCache().get(mark.getMarkReq());
                List<Mark> list = marks == null || marks.isEmpty() ? this.getMarkReqAndMarkCache().remove(mark.getMarkReq()) : ((newMarks = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(marks).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LoadBalanceLabelEngineConnManager.$anonfun$releaseMarkAndServiceInstance$1(mark, x$3)))) == null || newMarks.isEmpty() ? this.getMarkReqAndMarkCache().remove(mark.getMarkReq()) : this.getMarkReqAndMarkCache().put(mark.getMarkReq(), (List<Mark>)JavaConverters$.MODULE$.bufferAsJavaListConverter(newMarks).asJava()));
            }
            return;
        }
    }

    public String[] getAllInstances() {
        ArrayBuffer instances = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.getMarkCache().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            LoadBalanceLabelEngineConnManager.$anonfun$getAllInstances$1(instances, x$4);
            return BoxedUnit.UNIT;
        });
        return (String[])instances.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    @Override
    public Policy getPolicy() {
        return Policy.Label;
    }

    public static final /* synthetic */ boolean $anonfun$addMarkReqAndMark$1(DefaultMark mark$1, Mark x$1) {
        return x$1.getMarkId().equals(mark$1.getMarkId());
    }

    public static final /* synthetic */ boolean $anonfun$releaseMarkAndServiceInstance$1(Mark mark$2, Mark x$3) {
        return !x$3.getMarkId().equals(mark$2.getMarkId());
    }

    public static final /* synthetic */ void $anonfun$getAllInstances$1(ArrayBuffer instances$1, List x$4) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            instances$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{s.getInstance()}));
            return BoxedUnit.UNIT;
        });
    }
}

