/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.acessible.executor.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.acessible.executor.conf.AccessibleExecutorConfiguration$;
import org.apache.linkis.engineconn.acessible.executor.entity.AccessibleExecutor;
import org.apache.linkis.engineconn.acessible.executor.service.ExecutorHeartbeatServiceHolder$;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.common.engineconn.EngineConn;
import org.apache.linkis.engineconn.common.execution.EngineConnExecution;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineconn.core.hook.ShutdownHook$;
import org.apache.linkis.engineconn.executor.entity.ConcurrentExecutor;
import org.apache.linkis.engineconn.executor.entity.Executor;
import org.apache.linkis.engineconn.executor.entity.LabelExecutor;
import org.apache.linkis.engineconn.executor.entity.ResourceExecutor;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext$;
import org.apache.linkis.engineconn.executor.service.ManagerService$;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.protocol.engine.ECCanKillRequest;
import org.apache.linkis.manager.common.protocol.engine.ECCanKillResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineConnReleaseRequest;
import org.apache.linkis.manager.common.protocol.resource.ResourceUsedProtocol;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.rpc.Sender$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\t\u0012\u0001\u0001BQ!\u000e\u0001\u0005\u0002YBQ!\u000f\u0001\u0005\u0012iBQ!\u0015\u0001\u0005\u0012ICQ!\u0017\u0001\u0005\u0012iCQA\u0018\u0001\u0005B}CQA\u0019\u0001\u0005\u0012\rDQ!\u001a\u0001\u0005\n\u0019DQa\u001a\u0001\u0005\n\u0019DQ\u0001\u001b\u0001\u0005\u0002%Dq!a\u0002\u0001\t\u0013\tI\u0001C\u0004\u0002\u0012\u0001!I!a\u0005\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\n!9\u0011\u0011\u0004\u0001\u0005\u0012\u0005m\u0001bBA\u0011\u0001\u0011E\u00111\u0005\u0005\b\u0003O\u0001A\u0011IA\u0015\u0005u\t5mY3tg&\u0014G.Z#oO&tWmQ8o]\u0016CXmY;uS>t'B\u0001\n\u0014\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0015+\u0005AQ\r_3dkR|'O\u0003\u0002\u0017/\u0005I\u0011mY3tg&\u0014G.\u001a\u0006\u00031e\t!\"\u001a8hS:,7m\u001c8o\u0015\tQ2$\u0001\u0004mS:\\\u0017n\u001d\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\tsE\f\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!bS\"A\u0015\u000b\u0005IQ#BA\u0016\u0018\u0003\u0019\u0019w.\\7p]&\u0011Q&\u000b\u0002\u0014\u000b:<\u0017N\\3D_:tW\t_3dkRLwN\u001c\t\u0003_Mj\u0011\u0001\r\u0006\u0003cI\nQ!\u001e;jYNT!aK\r\n\u0005Q\u0002$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0002\"\u0001\u000f\u0001\u000e\u0003E\t!CZ5oIJ+\u0007o\u001c:u\u000bb,7-\u001e;peR\u00191H\u0011&\u0011\u0005q\u0002U\"A\u001f\u000b\u0005yz\u0014AB3oi&$\u0018P\u0003\u0002\u0015/%\u0011\u0011)\u0010\u0002\t\u000bb,7-\u001e;pe\")1I\u0001a\u0001\t\u0006)RM\\4j]\u0016\u001c%/Z1uS>t7i\u001c8uKb$\bCA#I\u001b\u00051%BA$+\u0003!\u0019'/Z1uS>t\u0017BA%G\u0005U)enZ5oK\u000e\u0013X-\u0019;j_:\u001cuN\u001c;fqRDQa\u0013\u0002A\u00021\u000b!\"\u001a8hS:,7i\u001c8o!\tiu*D\u0001O\u0015\tA\"&\u0003\u0002Q\u001d\nQQI\\4j]\u0016\u001cuN\u001c8\u00027\t,gm\u001c:f%\u0016\u0004xN\u001d;U_2Kgn[5t\u001b\u0006t\u0017mZ3s)\u0011\u0019fk\u0016-\u0011\u0005\t\"\u0016BA+$\u0005\u0011)f.\u001b;\t\u000bQ\u0019\u0001\u0019A\u001e\t\u000b\r\u001b\u0001\u0019\u0001#\t\u000b-\u001b\u0001\u0019\u0001'\u00025\u00054G/\u001a:SKB|'\u000f\u001e+p\u0019&t7.[:NC:\fw-\u001a:\u0015\tM[F,\u0018\u0005\u0006)\u0011\u0001\ra\u000f\u0005\u0006\u0007\u0012\u0001\r\u0001\u0012\u0005\u0006\u0017\u0012\u0001\r\u0001T\u0001\bKb,7-\u001e;f)\r\u0019\u0006-\u0019\u0005\u0006\u0007\u0016\u0001\r\u0001\u0012\u0005\u0006\u0017\u0016\u0001\r\u0001T\u0001\u0005S:LG\u000f\u0006\u0002TI\")1I\u0002a\u0001\t\u0006)R\r_3dkR|'o\u0015;biV\u001c8\t[3dW\u0016\u0014H#A*\u0002\u0015\u0015\u001c\u0017)\u001e;p\u000bbLG/A\u000fsKF,Xm\u001d;NC:\fw-\u001a:SK2,\u0017m]3Fq\u0016\u001cW\u000f^8s)\r\u0019&n\u001e\u0005\u0006W&\u0001\r\u0001\\\u0001\u0004[N<\u0007CA7u\u001d\tq'\u000f\u0005\u0002pG5\t\u0001O\u0003\u0002r?\u00051AH]8pizJ!a]\u0012\u0002\rA\u0013X\rZ3g\u0013\t)hO\u0001\u0004TiJLgn\u001a\u0006\u0003g\u000eBQ\u0001_\u0005A\u0002e\f!B\\8eKN#\u0018\r^;t!\rQ\u00181A\u0007\u0002w*\u0011A0`\u0001\fK:,X.\u001a:bi&|gN\u0003\u0002?}*\u00111f \u0006\u0004\u0003\u0003I\u0012aB7b]\u0006<WM]\u0005\u0004\u0003\u000bY(A\u0003(pI\u0016\u001cF/\u0019;vg\u0006\u0019\u0012n]'bS:$\u0018-\u001b8TkB\u0004xN\u001d;fIR\u0011\u00111\u0002\t\u0004E\u00055\u0011bAA\bG\t9!i\\8mK\u0006t\u0017AI5t\u0007>t7-\u001e:sK:$X\t_3dkR|'\u000fS1t)\u0006\u001c8NU;o]&tw\r\u0006\u0003\u0002\f\u0005U\u0001\"\u0002\u000b\f\u0001\u0004Y\u0014aD5t\u000b\u000e\u001b\u0015M\\'bS:$\u0018-\u001b8\u0002%I,\u0007o\u001c:u+N,GMU3t_V\u00148-\u001a\u000b\u0006'\u0006u\u0011q\u0004\u0005\u0006)5\u0001\ra\u000f\u0005\u0006\u00076\u0001\r\u0001R\u0001\fe\u0016\u0004xN\u001d;MC\n,G\u000eF\u0002T\u0003KAQ\u0001\u0006\bA\u0002m\n\u0001bZ3u\u001fJ$WM]\u000b\u0003\u0003W\u00012AIA\u0017\u0013\r\tyc\t\u0002\u0004\u0013:$\b")
public class AccessibleEngineConnExecution
implements EngineConnExecution,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AccessibleEngineConnExecution accessibleEngineConnExecution = this;
        synchronized (accessibleEngineConnExecution) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Executor findReportExecutor(EngineCreationContext engineCreationContext, EngineConn engineConn) {
        return ExecutorManager$.MODULE$.getInstance().getReportExecutor();
    }

    public void beforeReportToLinkisManager(Executor executor, EngineCreationContext engineCreationContext, EngineConn engineConn) {
    }

    public void afterReportToLinkisManager(Executor executor, EngineCreationContext engineCreationContext, EngineConn engineConn) {
    }

    public void execute(EngineCreationContext engineCreationContext, EngineConn engineConn) {
        this.init(engineCreationContext);
        Executor executor = this.findReportExecutor(engineCreationContext, engineConn);
        this.logger().info(new StringBuilder(29).append("Created a report executor ").append(executor.getClass().getSimpleName()).append("(").append(executor.getId()).append(").").toString());
        this.beforeReportToLinkisManager(executor, engineCreationContext, engineConn);
        this.reportUsedResource(executor, engineCreationContext);
        this.reportLabel(executor);
        this.executorStatusChecker();
        if (AccessibleExecutorConfiguration$.MODULE$.ENGINECONN_AUTO_EXIT()) {
            this.ecAutoExit();
        }
        this.afterReportToLinkisManager(executor, engineCreationContext, engineConn);
    }

    public void init(EngineCreationContext engineCreationContext) {
        ExecutorListenerBusContext listenerBusContext = ExecutorListenerBusContext$.MODULE$.getExecutorListenerBusContext();
        listenerBusContext.getEngineConnAsyncListenerBus().start();
    }

    private void executorStatusChecker() {
        EngineCreationContext context = EngineConnObject$.MODULE$.getEngineCreationContext();
        TimeType maxFreeTimeVar = (TimeType)AccessibleExecutorConfiguration$.MODULE$.ENGINECONN_MAX_FREE_TIME().getValue(context.getOptions());
        String maxFreeTimeStr = maxFreeTimeVar.toString();
        long maxFreeTime = maxFreeTimeVar.toLong();
        this.logger().info(new StringBuilder(51).append("executorStatusChecker created, maxFreeTimeMills is ").append(maxFreeTime).toString());
        Utils$.MODULE$.defaultScheduler().scheduleAtFixedRate(new Runnable(this, maxFreeTime, maxFreeTimeStr){
            private final /* synthetic */ AccessibleEngineConnExecution $outer;
            private final long maxFreeTime$1;
            private final String maxFreeTimeStr$1;

            public void run() {
                Object object = new Object();
                try {
                    Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        Executor executor = ExecutorManager$.MODULE$.getInstance().getReportExecutor();
                        if (!(executor instanceof AccessibleExecutor)) {
                            if (executor != null) {
                                Executor executor2 = executor;
                                $this.$outer.logger().warn(new StringBuilder(78).append("Executor(").append(executor2.getId()).append(") is not a AccessibleExecutor, do noting when reached max free time .").toString());
                                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                            }
                            throw new MatchError((Object)executor);
                        }
                        AccessibleExecutor accessibleExecutor = (AccessibleExecutor)executor;
                        AccessibleExecutor accessibleExecutor2 = accessibleExecutor;
                        NodeStatus nodeStatus = accessibleExecutor2.getStatus();
                        if (Predef$.MODULE$.Boolean2boolean(NodeStatus.isCompleted((NodeStatus)accessibleExecutor2.getStatus()))) {
                            $this.$outer.logger().error(new StringBuilder(41).append(accessibleExecutor2.getId()).append(" has completed with status ").append(accessibleExecutor2.getStatus()).append(", now stop it.").toString());
                            $this.$outer.requestManagerReleaseExecutor("Completed release", nodeStatus);
                            ShutdownHook$.MODULE$.getShutdownHook().notifyStop();
                            return;
                        }
                        NodeStatus nodeStatus2 = accessibleExecutor2.getStatus();
                        NodeStatus nodeStatus3 = NodeStatus.ShuttingDown;
                        if (!(nodeStatus2 != null ? !nodeStatus2.equals(nodeStatus3) : nodeStatus3 != null)) {
                            $this.$outer.logger().warn(new StringBuilder(19).append(accessibleExecutor2.getId()).append(" is ShuttingDown...").toString());
                            $this.$outer.requestManagerReleaseExecutor(" ShuttingDown release", nodeStatus);
                            ShutdownHook$.MODULE$.getShutdownHook().notifyStop();
                            return;
                        }
                        if ($this.maxFreeTime$1 > 0L && (NodeStatus.Unlock.equals((Object)accessibleExecutor2.getStatus()) || NodeStatus.Idle.equals((Object)accessibleExecutor2.getStatus())) && System.currentTimeMillis() - accessibleExecutor2.getLastActivityTime() > $this.maxFreeTime$1) {
                            if ($this.$outer.org$apache$linkis$engineconn$acessible$executor$execution$AccessibleEngineConnExecution$$isConcurrentExecutorHasTaskRunning((Executor)accessibleExecutor2)) {
                                $this.$outer.logger().info("ConcurrentExecutor has task running ec will not be killed at this time");
                                accessibleExecutor2.updateLastActivityTime();
                                return;
                            }
                            if ($this.$outer.org$apache$linkis$engineconn$acessible$executor$execution$AccessibleEngineConnExecution$$isECCanMaintain()) {
                                $this.$outer.logger().info("ec will not be killed at this time");
                                accessibleExecutor2.updateLastActivityTime();
                                return;
                            }
                            $this.$outer.logger().warn(new StringBuilder(48).append(accessibleExecutor2.getId()).append(" has not been used for ").append($this.maxFreeTimeStr$1).append(", now try to shutdown it.").toString());
                            accessibleExecutor2.trySucceed();
                            $this.$outer.requestManagerReleaseExecutor(" idle release", NodeStatus.Success);
                            ShutdownHook$.MODULE$.getShutdownHook().notifyStop();
                            return;
                        }
                    }, this.$outer.logger());
                }
                catch (NonLocalReturnControl ex) {
                    if (ex.key() == object) {
                        ex.value$mcV$sp();
                    }
                    throw ex;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maxFreeTime$1 = maxFreeTime$1;
                this.maxFreeTimeStr$1 = maxFreeTimeStr$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.linkis.engineconn.acessible.executor.execution.AccessibleEngineConnExecution$$anon$1 java.lang.Object )}, serializedLambda);
            }
        }, 180000L, ((TimeType)AccessibleExecutorConfiguration$.MODULE$.ENGINECONN_STATUS_SCAN_TIME().getValue()).toLong(), TimeUnit.MILLISECONDS);
    }

    private void ecAutoExit() {
        this.logger().info(new StringBuilder(19).append("ec auto exit start ").append(System.currentTimeMillis()).toString());
        Utils$.MODULE$.defaultScheduler().schedule(new Runnable(this){
            private final /* synthetic */ AccessibleEngineConnExecution $outer;

            public void run() {
                Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> {
                    Executor executor = ExecutorManager$.MODULE$.getInstance().getReportExecutor();
                    if (executor instanceof ConcurrentExecutor) {
                        ConcurrentExecutor concurrentExecutor = (ConcurrentExecutor)executor;
                        Random rand = new Random();
                        int minute = rand.nextInt(5) + 1;
                        Thread.sleep((long)minute * 60000L);
                        if (concurrentExecutor.hasTaskRunning()) {
                            ExecutorHeartbeatServiceHolder$.MODULE$.getDefaultHeartbeatService().setSelfUnhealthy("EC running time exceed max time");
                            return BoxedUnit.UNIT;
                        }
                        $this.$outer.logger().warn(new StringBuilder(53).append("Executor has no task running ").append(concurrentExecutor.getId()).append(", will be to shutdown ec").toString());
                        return BoxesRunTime.boxToBoolean((boolean)concurrentExecutor.tryShutdown());
                    }
                    $this.$outer.logger().warn("Executor is not a ConcurrentExecutor, do noting");
                    return BoxedUnit.UNIT;
                }, this.$outer.logger());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$2(org.apache.linkis.engineconn.acessible.executor.execution.AccessibleEngineConnExecution$$anon$2 )}, serializedLambda);
            }
        }, (long)AccessibleExecutorConfiguration$.MODULE$.ENGINECONN_AUTO_EXIT_DAYS(), TimeUnit.DAYS);
    }

    public void requestManagerReleaseExecutor(String msg, NodeStatus nodeStatus) {
        EngineConnReleaseRequest engineReleaseRequest = new EngineConnReleaseRequest(Sender$.MODULE$.getThisServiceInstance(), Utils$.MODULE$.getJvmUser(), msg, EngineConnObject$.MODULE$.getEngineCreationContext().getTicketId());
        engineReleaseRequest.setNodeStatus(nodeStatus);
        this.logger().info("To send release request to linkis manager");
        ManagerService$.MODULE$.getManagerService().requestReleaseEngineConn(engineReleaseRequest);
    }

    private boolean isMaintainSupported() {
        if (!BoxesRunTime.unboxToBoolean((Object)AccessibleExecutorConfiguration$.MODULE$.ENABLE_MAINTAIN().getValue())) {
            return false;
        }
        UserCreatorLabel userCreator = LabelUtil$.MODULE$.getUserCreatorLabel(EngineConnObject$.MODULE$.getEngineCreationContext().getLabels());
        if (userCreator != null && ((String)AccessibleExecutorConfiguration$.MODULE$.ENABLE_MAINTAIN_CREATORS().getValue()).contains(userCreator.getCreator())) {
            this.logger().info(new StringBuilder(17).append(userCreator.getStringValue()).append(" maintain enabled").toString());
            return true;
        }
        return false;
    }

    public boolean org$apache$linkis$engineconn$acessible$executor$execution$AccessibleEngineConnExecution$$isConcurrentExecutorHasTaskRunning(Executor executor) {
        Executor executor2 = executor;
        if (executor2 instanceof ConcurrentExecutor) {
            ConcurrentExecutor concurrentExecutor = (ConcurrentExecutor)executor2;
            return concurrentExecutor.hasTaskRunning();
        }
        return false;
    }

    public boolean org$apache$linkis$engineconn$acessible$executor$execution$AccessibleEngineConnExecution$$isECCanMaintain() {
        if (!this.isMaintainSupported()) {
            return false;
        }
        EngineTypeLabel engineTypeLabel = LabelUtil$.MODULE$.getEngineTypeLabel(EngineConnObject$.MODULE$.getEngineCreationContext().getLabels());
        UserCreatorLabel userCreator = LabelUtil$.MODULE$.getUserCreatorLabel(EngineConnObject$.MODULE$.getEngineCreationContext().getLabels());
        if (engineTypeLabel == null) {
            return false;
        }
        ECCanKillRequest ecCanKillRequest = new ECCanKillRequest();
        ecCanKillRequest.setEngineConnInstance(Sender$.MODULE$.getThisServiceInstance());
        ecCanKillRequest.setUser(userCreator.getUser());
        ecCanKillRequest.setUserCreatorLabel(userCreator);
        ecCanKillRequest.setEngineTypeLabel(engineTypeLabel);
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ECCanKillResponse response = ManagerService$.MODULE$.getManagerService().ecCanKillRequest(ecCanKillRequest);
            this.logger().info(new StringBuilder(17).append("From manager get ").append(response).toString());
            return !Predef$.MODULE$.Boolean2boolean(response.getFlag());
        }, (Function1 & Serializable & scala.Serializable)throwable -> BoxesRunTime.boxToBoolean((boolean)AccessibleEngineConnExecution.$anonfun$isECCanMaintain$2(this, throwable))));
    }

    public void reportUsedResource(Executor executor, EngineCreationContext engineCreationContext) {
        Executor executor2 = executor;
        if (executor2 instanceof ResourceExecutor) {
            ResourceExecutor resourceExecutor = (ResourceExecutor)executor2;
            ManagerService$.MODULE$.getManagerService().reportUsedResource(new ResourceUsedProtocol(Sender$.MODULE$.getThisServiceInstance(), resourceExecutor.getCurrentNodeResource(), engineCreationContext.getTicketId()));
            this.logger().info("In the first time, report usedResources to LinkisManager succeed.");
            return;
        }
        this.logger().info("Do not need to report usedResources.");
    }

    public void reportLabel(Executor executor) {
        Executor executor2 = executor;
        if (executor2 instanceof LabelExecutor) {
            LabelExecutor labelExecutor = (LabelExecutor)executor2;
            ManagerService$.MODULE$.getManagerService().labelReport(labelExecutor.getExecutorLabels());
            this.logger().info("In the first time, report all labels to LinkisManager succeed.");
            return;
        }
        this.logger().info("Do not need to report labels.");
    }

    public int getOrder() {
        return 10;
    }

    public static final /* synthetic */ boolean $anonfun$isECCanMaintain$2(AccessibleEngineConnExecution $this, Throwable throwable) {
        $this.logger().warn("Failed to ecCanKillRequestManager, will be default exit", throwable);
        return false;
    }

    public AccessibleEngineConnExecution() {
        Logging.$init$((Logging)this);
    }
}

