/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.source;

import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcPlugin;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSource;
import org.apache.linkis.engineplugin.spark.datacalc.model.SourceConfig;
import org.apache.linkis.engineplugin.spark.datacalc.source.StarrocksSourceConfig;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}2Aa\u0001\u0003\u0001'!)A\u0006\u0001C\u0001[!)q\u0006\u0001C!a\ty1\u000b^1se>\u001c7n]*pkJ\u001cWM\u0003\u0002\u0006\r\u000511o\\;sG\u0016T!a\u0002\u0005\u0002\u0011\u0011\fG/Y2bY\u000eT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011\u0001D3oO&tW\r\u001d7vO&t'BA\u0007\u000f\u0003\u0019a\u0017N\\6jg*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u000b\u001bIA\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u00042a\u0007\u0010!\u001b\u0005a\"BA\u000f\u0007\u0003\r\t\u0007/[\u0005\u0003?q\u0011a\u0002R1uC\u000e\u000bGnY*pkJ\u001cW\r\u0005\u0002\"E5\tA!\u0003\u0002$\t\t)2\u000b^1se>\u001c7n]*pkJ\u001cWmQ8oM&<\u0007CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0015)H/\u001b7t\u0015\tIC\"\u0001\u0004d_6lwN\\\u0005\u0003W\u0019\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011\u0011\u0005A\u0001\bO\u0016$H)\u0019;b)\t\t4\bE\u00023maj\u0011a\r\u0006\u0003iU\n1a]9m\u0015\tIa\"\u0003\u00028g\t9A)\u0019;bg\u0016$\bC\u0001\u001a:\u0013\tQ4GA\u0002S_^DQ!\u0003\u0002A\u0002q\u0002\"AM\u001f\n\u0005y\u001a$\u0001D*qCJ\\7+Z:tS>t\u0007")
public class StarrocksSource
implements DataCalcSource<StarrocksSourceConfig>,
Logging {
    private Logger logger;
    private StarrocksSourceConfig config;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    @Override
    public Object getConfig() {
        return DataCalcPlugin.getConfig$(this);
    }

    @Override
    public void setConfig(Object config) {
        DataCalcPlugin.setConfig$(this, config);
    }

    @Override
    public void prepare(SparkSession spark) {
        DataCalcPlugin.prepare$(this, spark);
    }

    private Logger logger$lzycompute() {
        StarrocksSource starrocksSource = this;
        synchronized (starrocksSource) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public StarrocksSourceConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(StarrocksSourceConfig x$1) {
        this.config = x$1;
    }

    @Override
    public Dataset<Row> getData(SparkSession spark) {
        DataFrameReader reader = spark.read().format("starrocks");
        Object object = ((SourceConfig)this.config()).getOptions() != null && !((SourceConfig)this.config()).getOptions().isEmpty() ? reader.options(((SourceConfig)this.config()).getOptions()) : BoxedUnit.UNIT;
        this.logger().info(new StringBuilder(63).append("Load data from starrocks url: ").append(((StarrocksSourceConfig)this.config()).getUrl()).append(", sourceDatabase: ").append(((StarrocksSourceConfig)this.config()).getSourceDatabase()).append(", sourceTable: ").append(((StarrocksSourceConfig)this.config()).getSourceTable()).toString());
        return reader.option("starrocks.table.identifier", String.format("%s.%s", ((StarrocksSourceConfig)this.config()).getSourceDatabase(), ((StarrocksSourceConfig)this.config()).getSourceTable())).option("starrocks.fenodes", ((StarrocksSourceConfig)this.config()).getUrl()).option("user", ((StarrocksSourceConfig)this.config()).getUser()).option("password", ((StarrocksSourceConfig)this.config()).getPassword()).load();
    }

    public StarrocksSource() {
        DataCalcPlugin.$init$(this);
        Logging.$init$((Logging)this);
    }
}

