/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.datacalc.util;

import com.google.gson.JsonElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcPlugin;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSource;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcTransform;
import org.apache.linkis.engineplugin.spark.datacalc.model.SinkConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.SourceConfig;
import org.apache.linkis.engineplugin.spark.datacalc.model.TransformConfig;
import org.apache.linkis.engineplugin.spark.datacalc.sink.DataLakeSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.DorisSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.ElasticsearchSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.FileSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.HiveSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.JdbcSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.KafkaSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.ManagedJdbcSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.MongoSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.RedisSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.RocketmqSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.SolrSink;
import org.apache.linkis.engineplugin.spark.datacalc.sink.StarrocksSink;
import org.apache.linkis.engineplugin.spark.datacalc.source.DataLakeSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.DorisSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.ElasticsearchSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.FileSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.JdbcSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.KafkaSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.ManagedJdbcSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.MongoSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.RedisSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.RocketmqSource;
import org.apache.linkis.engineplugin.spark.datacalc.source.StarrocksSource;
import org.apache.linkis.engineplugin.spark.datacalc.transform.SqlTransform;
import org.apache.linkis.server.BDPJettyServerHelper;

public class PluginUtil {
    private static final Map<String, Class<?>> SOURCE_PLUGINS = PluginUtil.getSourcePlugins();
    private static final Map<String, Class<?>> TRANSFORM_PLUGINS = PluginUtil.getTransformPlugins();
    private static final Map<String, Class<?>> SINK_PLUGINS = PluginUtil.getSinkPlugins();

    private static Map<String, Class<?>> getSourcePlugins() {
        HashMap classMap = new HashMap();
        classMap.put("managed_jdbc", ManagedJdbcSource.class);
        classMap.put("jdbc", JdbcSource.class);
        classMap.put("file", FileSource.class);
        classMap.put("redis", RedisSource.class);
        classMap.put("datalake", DataLakeSource.class);
        classMap.put("rocketmq", RocketmqSource.class);
        classMap.put("mongo", MongoSource.class);
        classMap.put("elasticsearch", ElasticsearchSource.class);
        classMap.put("kafka", KafkaSource.class);
        classMap.put("starrocks", StarrocksSource.class);
        classMap.put("doris", DorisSource.class);
        return classMap;
    }

    private static Map<String, Class<?>> getTransformPlugins() {
        HashMap classMap = new HashMap();
        classMap.put("sql", SqlTransform.class);
        return classMap;
    }

    private static Map<String, Class<?>> getSinkPlugins() {
        HashMap classMap = new HashMap();
        classMap.put("managed_jdbc", ManagedJdbcSink.class);
        classMap.put("jdbc", JdbcSink.class);
        classMap.put("hive", HiveSink.class);
        classMap.put("file", FileSink.class);
        classMap.put("redis", RedisSink.class);
        classMap.put("datalake", DataLakeSink.class);
        classMap.put("rocketmq", RocketmqSink.class);
        classMap.put("mongo", MongoSink.class);
        classMap.put("elasticsearch", ElasticsearchSink.class);
        classMap.put("solr", SolrSink.class);
        classMap.put("kafka", KafkaSink.class);
        classMap.put("starrocks", StarrocksSink.class);
        classMap.put("doris", DorisSink.class);
        return classMap;
    }

    public static <T extends SourceConfig> DataCalcSource<T> createSource(String name, JsonElement config) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (DataCalcSource)PluginUtil.createPlugin(SOURCE_PLUGINS, name, config);
    }

    public static <T extends TransformConfig> DataCalcTransform<T> createTransform(String name, JsonElement config) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (DataCalcTransform)PluginUtil.createPlugin(TRANSFORM_PLUGINS, name, config);
    }

    public static <T extends SinkConfig> DataCalcSink<T> createSink(String name, JsonElement config) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (DataCalcSink)PluginUtil.createPlugin(SINK_PLUGINS, name, config);
    }

    static <T extends DataCalcPlugin> T createPlugin(Map<String, Class<?>> pluginMap, String name, JsonElement config) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> type = pluginMap.get(name);
        ParameterizedType genericSuperclass = (ParameterizedType)type.getGenericInterfaces()[0];
        Class configType = (Class)genericSuperclass.getActualTypeArguments()[0];
        DataCalcPlugin plugin = (DataCalcPlugin)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        plugin.setConfig(BDPJettyServerHelper.gson().fromJson(config, configType));
        return (T)plugin;
    }
}

