/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.hive.config;

import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.hadoop.common.conf.HadoopConf;
import org.apache.linkis.metadata.condition.DataSourceCondition;
import org.apache.linkis.metadata.hive.config.DynamicDataSource;
import org.apache.linkis.metadata.util.DWSConfig;
import org.apache.linkis.metadata.util.HiveUtils;
import org.apache.linkis.mybatis.DataSourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement(order=2)
public class LinkisMybatisConfig {
    private static final Logger logger = LoggerFactory.getLogger(LinkisMybatisConfig.class);

    private DataSource hiveDataSource() {
        String url = (String)DWSConfig.HIVE_META_URL.getValue();
        String username = (String)DWSConfig.HIVE_META_USER.getValue();
        String password = (String)DWSConfig.HIVE_META_PASSWORD.getValue();
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
            org.apache.hadoop.conf.Configuration hiveConf = HiveUtils.getDefaultConf((String)HadoopConf.HADOOP_ROOT_USER().getValue());
            logger.info("from hive conf to pares meta store JDBC url");
            url = hiveConf.get("javax.jdo.option.ConnectionURL");
            username = hiveConf.get("javax.jdo.option.ConnectionUserName");
            password = hiveConf.get("javax.jdo.option.ConnectionPassword");
            if (((Boolean)DWSConfig.HIVE_PASS_ENCODE_ENABLED.getValue()).booleanValue()) {
                logger.info("hive meta password is encode ");
                password = HiveUtils.decode(password);
            }
        }
        return DataSourceUtils.buildDataSource((String)url, (String)username, (String)password);
    }

    private DataSource mysqlDataSource() {
        return DataSourceUtils.buildDataSource(null, null, null);
    }

    @Bean(name={"dataSource"})
    @Conditional(value={DataSourceCondition.class})
    public DynamicDataSource mutiDataSource() {
        DataSource hiveDataSource = this.hiveDataSource();
        DataSource mysqlDataSource = this.mysqlDataSource();
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        HashMap<String, DataSource> hashMap = new HashMap<String, DataSource>();
        hashMap.put("firstDataSource", hiveDataSource);
        hashMap.put("secondDataSource", mysqlDataSource);
        dynamicDataSource.setTargetDataSources(hashMap);
        dynamicDataSource.setDefaultTargetDataSource(mysqlDataSource);
        return dynamicDataSource;
    }
}

