/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.highavailable.ha.instancealias.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.ServiceInstance$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.highavailable.conf.ContextHighAvailableConf;
import org.apache.linkis.cs.highavailable.exception.CSErrorCode;
import org.apache.linkis.cs.highavailable.ha.instancealias.InstanceAliasConverter;
import org.apache.linkis.instance.label.client.InstanceLabelClient;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.route.RouteLabel;
import org.apache.linkis.rpc.Sender$;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\t\u0013\u0001\rBQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013%1\b\u0003\u0004@\u0001\u0001\u0006I\u0001\u0010\u0005\n\u0001\u0002\u0001\r\u00111A\u0005\n\u0005C\u0011\u0002\u0014\u0001A\u0002\u0003\u0007I\u0011B'\t\u0013M\u0003\u0001\u0019!A!B\u0013\u0011\u0005b\u0002+\u0001\u0005\u0004%I!\u0016\u0005\u00075\u0002\u0001\u000b\u0011\u0002,\t\u000fm\u0003!\u0019!C\u00059\"11\u000f\u0001Q\u0001\nuCq\u0001\u001e\u0001C\u0002\u0013%A\f\u0003\u0004v\u0001\u0001\u0006I!\u0018\u0005\u0006m\u0002!Ia\u001e\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!!\u0005\u0001\t\u0003\n\u0019B\u0001\u0011S_V$X\rT1cK2Len\u001d;b]\u000e,\u0017\t\\5bg\u000e{gN^3si\u0016\u0014(BA\n\u0015\u0003\u0011IW\u000e\u001d7\u000b\u0005U1\u0012!D5ogR\fgnY3bY&\f7O\u0003\u0002\u00181\u0005\u0011\u0001.\u0019\u0006\u00033i\tQ\u0002[5hQ\u00064\u0018-\u001b7bE2,'BA\u000e\u001d\u0003\t\u00197O\u0003\u0002\u001e=\u00051A.\u001b8lSNT!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u00011\u0003\u0002\u0001%U9\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016-\u001b\u0005!\u0012BA\u0017\u0015\u0005YIen\u001d;b]\u000e,\u0017\t\\5bg\u000e{gN^3si\u0016\u0014\bCA\u00185\u001b\u0005\u0001$BA\u00193\u0003\u0015)H/\u001b7t\u0015\t\u0019D$\u0001\u0004d_6lwN\\\u0005\u0003kA\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002qA\u0011\u0011\bA\u0007\u0002%\u0005IR*\u0011-`\u0013\u0012{\u0016JT*U\u0003:\u001bUiX\"B\u0007\"+ulU+N+\u0005a\u0004CA\u0013>\u0013\tqdEA\u0002J]R\f!$T!Y?&#u,\u0013(T)\u0006s5)R0D\u0003\u000eCUiX*V\u001b\u0002\n1#\u001b8ti\u0006t7-\u001a'bE\u0016d7\t\\5f]R,\u0012A\u0011\t\u0003\u0007*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000baa\u00197jK:$(BA$I\u0003\u0015a\u0017MY3m\u0015\tIE$\u0001\u0005j]N$\u0018M\\2f\u0013\tYEIA\nJ]N$\u0018M\\2f\u0019\u0006\u0014W\r\\\"mS\u0016tG/A\fj]N$\u0018M\\2f\u0019\u0006\u0014W\r\\\"mS\u0016tGo\u0018\u0013fcR\u0011a*\u0015\t\u0003K=K!\u0001\u0015\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b%\u0016\t\t\u00111\u0001C\u0003\rAH%M\u0001\u0015S:\u001cH/\u00198dK2\u000b'-\u001a7DY&,g\u000e\u001e\u0011\u0002\u0019QD\u0017n]%ogR\fgnY3\u0016\u0003Y\u0003\"a\u0016-\u000e\u0003IJ!!\u0017\u001a\u0003\u001fM+'O^5dK&s7\u000f^1oG\u0016\fQ\u0002\u001e5jg&s7\u000f^1oG\u0016\u0004\u0013!D5og\u0006c\u0017.Y:DC\u000eDW-F\u0001^!\u0011qf\r\u001b5\u000e\u0003}S!\u0001Y1\u0002\u000b\r\f7\r[3\u000b\u0005M\u0012'BA2e\u0003\u00199wn\\4mK*\tQ-A\u0002d_6L!aZ0\u0003\u000b\r\u000b7\r[3\u0011\u0005%\u0004hB\u00016o!\tYg%D\u0001m\u0015\ti'%\u0001\u0004=e>|GOP\u0005\u0003_\u001a\na\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011qNJ\u0001\u000fS:\u001c\u0018\t\\5bg\u000e\u000b7\r[3!\u00035\tG.[1t\u0013:\u001c8)Y2iK\u0006q\u0011\r\\5bg&s7oQ1dQ\u0016\u0004\u0013\u0001B5oSR$\u0012A\u0014\u0015\u0003\u001be\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0015\u0005tgn\u001c;bi&|gNC\u0001\u007f\u0003\u0015Q\u0017M^1y\u0013\r\t\ta\u001f\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\u0002\u001f%t7\u000f^1oG\u0016$v.\u00117jCN$2\u0001[A\u0004\u0011\u0015Ie\u00021\u0001i\u0003=\tG.[1t)>Len\u001d;b]\u000e,Gc\u00015\u0002\u000e!1\u0011qB\bA\u0002!\fQ!\u00197jCN\fQc\u00195fG.\fE.[1t\r>\u0014X.\u0019;WC2LG\r\u0006\u0003\u0002\u0016\u0005m\u0001cA\u0013\u0002\u0018%\u0019\u0011\u0011\u0004\u0014\u0003\u000f\t{w\u000e\\3b]\"1\u0011q\u0002\tA\u0002!D3\u0001AA\u0010!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t!b\u001d;fe\u0016|G/\u001f9f\u0015\r\tI\u0003I\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!\u0011QFA\u0012\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class RouteLabelInstanceAliasConverter
implements InstanceAliasConverter,
Logging {
    private final int MAX_ID_INSTANCE_CACHE_SUM;
    private InstanceLabelClient instanceLabelClient;
    private final ServiceInstance thisInstance;
    private final Cache<String, String> insAliasCache;
    private final Cache<String, String> aliasInsCache;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        RouteLabelInstanceAliasConverter routeLabelInstanceAliasConverter = this;
        synchronized (routeLabelInstanceAliasConverter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private int MAX_ID_INSTANCE_CACHE_SUM() {
        return this.MAX_ID_INSTANCE_CACHE_SUM;
    }

    private InstanceLabelClient instanceLabelClient() {
        return this.instanceLabelClient;
    }

    private void instanceLabelClient_$eq(InstanceLabelClient x$1) {
        this.instanceLabelClient = x$1;
    }

    private ServiceInstance thisInstance() {
        return this.thisInstance;
    }

    private Cache<String, String> insAliasCache() {
        return this.insAliasCache;
    }

    private Cache<String, String> aliasInsCache() {
        return this.aliasInsCache;
    }

    @PostConstruct
    private void init() {
        this.instanceLabelClient_$eq(new InstanceLabelClient());
    }

    @Override
    public String instanceToAlias(String instance) {
        if (StringUtils.isNotBlank((CharSequence)instance)) {
            String alias = (String)this.insAliasCache().getIfPresent((Object)instance);
            if (alias != null) {
                return alias;
            }
            ObjectRef labels = ObjectRef.create(null);
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                labels$1.elem = this.instanceLabelClient().getLabelFromInstance(ServiceInstance$.MODULE$.apply(this.thisInstance().getApplicationName(), instance));
            }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                RouteLabelInstanceAliasConverter.$anonfun$instanceToAlias$2(this, instance, x0$1);
                return BoxedUnit.UNIT;
            });
            if ((List)labels.elem != null && ((List)labels.elem).size() > 0) {
                Buffer routeLabels = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)labels.elem).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RouteLabelInstanceAliasConverter.$anonfun$instanceToAlias$3(x$1)))).filter((Function1 & Serializable & scala.Serializable)l -> BoxesRunTime.boxToBoolean((boolean)RouteLabelInstanceAliasConverter.$anonfun$instanceToAlias$4(l)));
                if (routeLabels.size() != 1) {
                    this.logger().warn(new StringBuilder(48).append("Instance ").append(instance).append(" has no or more than one route label : ").append(routeLabels.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getStringValue(), Buffer$.MODULE$.canBuildFrom())).toString());
                }
                if (routeLabels.size() >= 1) {
                    String alias2 = ((Label)routeLabels.head()).getStringValue();
                    this.logger().info(new StringBuilder(25).append("alias for instance : ").append(instance).append(" is ").append(alias2).toString());
                    this.insAliasCache().put((Object)instance, (Object)alias2);
                    return alias2;
                }
                String msg = new StringBuilder(33).append("No routeLabel got for instance : ").append(instance).toString();
                this.logger().error(msg);
                throw new CSErrorException(CSErrorCode.INVALID_INSTANCE_ALIAS, msg);
            }
            String msg = new StringBuilder(35).append("Null routeLabel got for instance : ").append(instance).toString();
            this.logger().error(msg);
            throw new CSErrorException(CSErrorCode.INVALID_INSTANCE_ALIAS, msg);
        }
        throw new CSErrorException(CSErrorCode.INVALID_INSTANCE, "Invalid null instance.");
    }

    @Override
    public String aliasToInstance(String alias) {
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            String instance = (String)this.aliasInsCache().getIfPresent((Object)alias);
            if (StringUtils.isNotBlank((CharSequence)instance)) {
                return instance;
            }
            RouteLabel routeLabel = (RouteLabel)LabelBuilderFactoryContext.getLabelBuilderFactory().createLabel("route", (Object)alias);
            ArrayList<RouteLabel> labels = new ArrayList<RouteLabel>();
            labels.add(routeLabel);
            ObjectRef insList = ObjectRef.create(null);
            Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                insList$1.elem = this.instanceLabelClient().getInstanceFromLabel((List)labels);
            }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                RouteLabelInstanceAliasConverter.$anonfun$aliasToInstance$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
            if ((List)insList.elem != null) {
                if (((List)insList.elem).size() >= 1) {
                    if (((List)insList.elem).size() > 1) {
                        this.logger().warn(new StringBuilder(39).append("Got ").append(((List)insList.elem).size()).append(" instances more than 1 from alias ").append(alias).append(".").toString());
                    }
                    String ins = ((ServiceInstance)((List)insList.elem).get(0)).getInstance();
                    this.aliasInsCache().put((Object)alias, (Object)ins);
                    return ins;
                }
                String msg = new StringBuilder(29).append("Got no instances form alias ").append(alias).append(".").toString();
                this.logger().error(msg);
                throw new CSErrorException(CSErrorCode.INVALID_INSTANCE, msg);
            }
            String msg = new StringBuilder(29).append("Got no instances form alias ").append(alias).append(".").toString();
            this.logger().error(msg);
            throw new CSErrorException(CSErrorCode.INVALID_INSTANCE, msg);
        }
        throw new CSErrorException(CSErrorCode.INVALID_INSTANCE_ALIAS, "Invalid null alias.");
    }

    @Override
    public boolean checkAliasFormatValid(String alias) {
        return StringUtils.isNotBlank((CharSequence)alias);
    }

    public static final /* synthetic */ void $anonfun$instanceToAlias$2(RouteLabelInstanceAliasConverter $this, String instance$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            String msg = new StringBuilder(45).append("GetLabelFromInstance for instance : ").append(instance$1).append(" failed, ").append(exception.getMessage()).toString();
            $this.logger().error(msg, (Throwable)exception);
            throw new CSErrorException(CSErrorCode.CS_RPC_ERROR, msg, (Throwable)exception);
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ boolean $anonfun$instanceToAlias$3(Label x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$instanceToAlias$4(Label l) {
        return "route".equals(l.getLabelKey()) && l.getStringValue().startsWith((String)ContextHighAvailableConf.CONTEXTSERVICE_PREFIX.getValue());
    }

    public static final /* synthetic */ void $anonfun$aliasToInstance$2(RouteLabelInstanceAliasConverter $this, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            String msg = new StringBuilder(29).append("GetInsFromLabel rpc failed : ").append(exception.getMessage()).toString();
            $this.logger().error(msg, (Throwable)exception);
            throw new CSErrorException(CSErrorCode.CS_RPC_ERROR, msg, (Throwable)exception);
        }
        throw new MatchError((Object)throwable);
    }

    public RouteLabelInstanceAliasConverter() {
        Logging.$init$((Logging)this);
        this.MAX_ID_INSTANCE_CACHE_SUM = 100000;
        this.thisInstance = Sender$.MODULE$.getThisServiceInstance();
        this.insAliasCache = CacheBuilder.newBuilder().maximumSize((long)this.MAX_ID_INSTANCE_CACHE_SUM()).expireAfterWrite(Predef$.MODULE$.Long2long((Long)ContextHighAvailableConf.CS_ALIAS_CACHE_EXPIRE_TIMEMILLS.getValue()), TimeUnit.MILLISECONDS).build();
        this.aliasInsCache = CacheBuilder.newBuilder().maximumSize((long)this.MAX_ID_INSTANCE_CACHE_SUM()).expireAfterWrite(Predef$.MODULE$.Long2long((Long)ContextHighAvailableConf.CS_ALIAS_CACHE_EXPIRE_TIMEMILLS.getValue()), TimeUnit.MILLISECONDS).build();
    }
}

