/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.common.serialize.impl.history.metadata;

import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.apache.linkis.cs.common.entity.history.metadata.CSTableLineageHistory;
import org.apache.linkis.cs.common.entity.metadata.CSTable;
import org.apache.linkis.cs.common.entity.metadata.Table;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.serialize.AbstractSerializer;
import org.apache.linkis.cs.common.serialize.impl.history.CommonHistorySerializer;
import org.apache.linkis.cs.common.utils.CSCommonUtils;

public class CSTableLineageSerializer
extends AbstractSerializer<CSTableLineageHistory>
implements CommonHistorySerializer {
    @Override
    public CSTableLineageHistory fromJson(String json) throws CSErrorException {
        Map<String, String> map = this.getMapValue(json);
        CSTableLineageHistory history = this.get(map, new CSTableLineageHistory());
        history.setSourceTables((List)CSCommonUtils.gson.fromJson(map.get("sourceTables"), new TypeToken<List<CSTable>>(){}.getType()));
        history.setTable((Table)CSCommonUtils.gson.fromJson(map.get("targetTable"), CSTable.class));
        return history;
    }

    @Override
    public String getJsonValue(CSTableLineageHistory tableLineageMetadataContextHistory) throws CSErrorException {
        Table targetTable = tableLineageMetadataContextHistory.getTable();
        List<Table> sourceTables = tableLineageMetadataContextHistory.getSourceTables();
        String targetTableStr = CSCommonUtils.gson.toJson((Object)targetTable);
        String sourceTablesStr = CSCommonUtils.gson.toJson(sourceTables);
        Map<String, String> mapValue = this.getMapValue(tableLineageMetadataContextHistory);
        mapValue.put("targetTable", targetTableStr);
        mapValue.put("sourceTables", sourceTablesStr);
        return CSCommonUtils.gson.toJson(mapValue);
    }

    @Override
    public String getType() {
        return "CSTableLineageMetadataContextHistory";
    }

    @Override
    public boolean accepts(Object obj) {
        return null != obj && obj.getClass().getName().equals(CSTableLineageHistory.class.getName());
    }
}

