/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.entity.cluster;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.linkis.manager.label.entity.Feature;
import org.apache.linkis.manager.label.entity.GenericLabel;
import org.apache.linkis.manager.label.errorcode.LabelCommonErrorCodeSummary;
import org.apache.linkis.manager.label.exception.LabelRuntimeException;

public class EnvLabel
extends GenericLabel {
    public static final String DEV = "dev";
    public static final String TEST = "test";
    public static final String PROD = "prod";

    public EnvLabel() {
        this.setLabelKey("envType");
    }

    @Override
    public Feature getFeature() {
        return Feature.CORE;
    }

    public void setEnvType(String envType) {
        if (!(envType.equals(DEV) || envType.equals(TEST) || envType.equals(PROD))) {
            throw new LabelRuntimeException(LabelCommonErrorCodeSummary.NOT_SUPPORT_ENVTYPE.getErrorCode(), MessageFormat.format(LabelCommonErrorCodeSummary.NOT_SUPPORT_ENVTYPE.getErrorDesc(), envType));
        }
        if (null == this.getValue()) {
            this.setValue((Map<String, String>)new HashMap<String, String>());
        }
        ((Map)this.getValue()).put("envType", envType);
    }

    public String getEnvType() {
        if (this.getValue() != null && null != ((Map)this.getValue()).get("envType")) {
            return (String)((Map)this.getValue()).get("envType");
        }
        return null;
    }
}

