/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.monitor.MonitorQuerySerializer;
import org.apache.lucene.monitor.QueryDecomposer;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.IOSupplier;

public class MonitorConfiguration {
    private int queryUpdateBufferSize = 5000;
    private long purgeFrequency = 5L;
    private TimeUnit purgeFrequencyUnits = TimeUnit.MINUTES;
    private QueryDecomposer queryDecomposer = new QueryDecomposer();
    private MonitorQuerySerializer serializer;
    private boolean readOnly = false;
    private IOSupplier<Directory> directoryProvider = () -> new ByteBuffersDirectory();

    private static IndexWriterConfig defaultIndexWriterConfig() {
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new KeywordAnalyzer());
        TieredMergePolicy mergePolicy = new TieredMergePolicy();
        mergePolicy.setSegmentsPerTier(4.0);
        iwc.setMergePolicy((MergePolicy)mergePolicy);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        return iwc;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public IOSupplier<Directory> getDirectoryProvider() {
        return this.directoryProvider;
    }

    public MonitorConfiguration setDirectoryProvider(IOSupplier<Directory> directoryProvider, MonitorQuerySerializer serializer, Boolean readOnly) {
        this.directoryProvider = directoryProvider;
        this.serializer = serializer;
        this.readOnly = readOnly;
        return this;
    }

    public MonitorConfiguration setDirectoryProvider(IOSupplier<Directory> directoryProvider, MonitorQuerySerializer serializer) {
        this.directoryProvider = directoryProvider;
        this.serializer = serializer;
        return this;
    }

    public MonitorConfiguration setIndexPath(Path indexPath, MonitorQuerySerializer serializer) {
        this.serializer = serializer;
        this.directoryProvider = () -> FSDirectory.open((Path)indexPath);
        return this;
    }

    public IndexWriter buildIndexWriter() throws IOException {
        return new IndexWriter((Directory)this.directoryProvider.get(), this.getIndexWriterConfig());
    }

    protected IndexWriterConfig getIndexWriterConfig() {
        return MonitorConfiguration.defaultIndexWriterConfig();
    }

    public MonitorQuerySerializer getQuerySerializer() {
        return this.serializer;
    }

    public MonitorConfiguration setQueryDecomposer(QueryDecomposer queryDecomposer) {
        this.queryDecomposer = queryDecomposer;
        return this;
    }

    public QueryDecomposer getQueryDecomposer() {
        return this.queryDecomposer;
    }

    public MonitorConfiguration setPurgeFrequency(long frequency, TimeUnit units) {
        this.purgeFrequency = frequency;
        this.purgeFrequencyUnits = units;
        return this;
    }

    public long getPurgeFrequency() {
        return this.purgeFrequency;
    }

    public TimeUnit getPurgeFrequencyUnits() {
        return this.purgeFrequencyUnits;
    }

    public MonitorConfiguration setQueryUpdateBufferSize(int size) {
        this.queryUpdateBufferSize = size;
        return this;
    }

    public int getQueryUpdateBufferSize() {
        return this.queryUpdateBufferSize;
    }
}

