/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class BlockHeader
implements Accountable {
    private static final long RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(BlockHeader.class);
    protected int linesCount;
    protected long baseDocsFP;
    protected long basePositionsFP;
    protected long basePayloadsFP;
    protected int termStatesBaseOffset;
    protected int middleLineIndex;
    protected int middleLineOffset;

    protected BlockHeader(int linesCount, long baseDocsFP, long basePositionsFP, long basePayloadsFP, int termStatesBaseOffset, int middleLineOffset) {
        this.reset(linesCount, baseDocsFP, basePositionsFP, basePayloadsFP, termStatesBaseOffset, middleLineOffset);
    }

    protected BlockHeader() {
    }

    protected BlockHeader reset(int linesCount, long baseDocsFP, long basePositionsFP, long basePayloadsFP, int termStatesBaseOffset, int middleTermOffset) {
        this.baseDocsFP = baseDocsFP;
        this.basePositionsFP = basePositionsFP;
        this.basePayloadsFP = basePayloadsFP;
        this.linesCount = linesCount;
        this.middleLineIndex = linesCount >> 1;
        this.termStatesBaseOffset = termStatesBaseOffset;
        this.middleLineOffset = middleTermOffset;
        return this;
    }

    public int getLinesCount() {
        return this.linesCount;
    }

    public int getMiddleLineIndex() {
        return this.middleLineIndex;
    }

    public int getMiddleLineOffset() {
        return this.middleLineOffset;
    }

    public int getTermStatesBaseOffset() {
        return this.termStatesBaseOffset;
    }

    public long getBaseDocsFP() {
        return this.baseDocsFP;
    }

    public long getBasePositionsFP() {
        return this.basePositionsFP;
    }

    public long getBasePayloadsFP() {
        return this.basePayloadsFP;
    }

    public long ramBytesUsed() {
        return RAM_USAGE;
    }

    public static class Serializer {
        public void write(DataOutput output, BlockHeader blockHeader) throws IOException {
            assert (blockHeader.linesCount > 0) : "Block header is not initialized";
            output.writeVInt(blockHeader.linesCount);
            output.writeVLong(blockHeader.baseDocsFP);
            output.writeVLong(blockHeader.basePositionsFP);
            output.writeVLong(blockHeader.basePayloadsFP);
            output.writeVInt(blockHeader.termStatesBaseOffset);
            output.writeVInt(blockHeader.middleLineOffset);
        }

        public BlockHeader read(DataInput input, BlockHeader reuse) throws IOException {
            int linesCount = input.readVInt();
            if (linesCount <= 0 || linesCount > 1000) {
                throw new CorruptIndexException("Illegal number of lines in block: " + linesCount, input);
            }
            long baseDocsFP = input.readVLong();
            long basePositionsFP = input.readVLong();
            long basePayloadsFP = input.readVLong();
            int termStatesBaseOffset = input.readVInt();
            if (termStatesBaseOffset < 0) {
                throw new CorruptIndexException("Illegal termStatesBaseOffset= " + termStatesBaseOffset, input);
            }
            int middleTermOffset = input.readVInt();
            if (middleTermOffset < 0) {
                throw new CorruptIndexException("Illegal middleTermOffset= " + middleTermOffset, input);
            }
            BlockHeader blockHeader = reuse == null ? new BlockHeader() : reuse;
            return blockHeader.reset(linesCount, baseDocsFP, basePositionsFP, basePayloadsFP, termStatesBaseOffset, middleTermOffset);
        }
    }
}

