/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.quality.trec;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import org.apache.lucene.benchmark.quality.QualityBenchmark;
import org.apache.lucene.benchmark.quality.QualityQuery;
import org.apache.lucene.benchmark.quality.QualityStats;
import org.apache.lucene.benchmark.quality.trec.TrecJudge;
import org.apache.lucene.benchmark.quality.trec.TrecTopicsReader;
import org.apache.lucene.benchmark.quality.utils.SimpleQQParser;
import org.apache.lucene.benchmark.quality.utils.SubmissionReport;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class QueryDriver {
    public static void main(String[] args) throws Exception {
        if (args.length < 4 || args.length > 5) {
            System.err.println("Usage: QueryDriver <topicsFile> <qrelsFile> <submissionFile> <indexDir> [querySpec]");
            System.err.println("topicsFile: input file containing queries");
            System.err.println("qrelsFile: input file containing relevance judgements");
            System.err.println("submissionFile: output submission file for trec_eval");
            System.err.println("indexDir: index directory");
            System.err.println("querySpec: string composed of fields to use in query consisting of T=title,D=description,N=narrative:");
            System.err.println("\texample: TD (query on Title + Description). The default is T (title only)");
            System.exit(1);
        }
        Path topicsFile = Paths.get(args[0], new String[0]);
        Path qrelsFile = Paths.get(args[1], new String[0]);
        Path submissionFile = Paths.get(args[2], new String[0]);
        SubmissionReport submitLog = new SubmissionReport(new PrintWriter(Files.newBufferedWriter(submissionFile, StandardCharsets.UTF_8, new OpenOption[0])), "lucene");
        FSDirectory dir = FSDirectory.open((Path)Paths.get(args[3], new String[0]));
        String fieldSpec = args.length == 5 ? args[4] : "T";
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        int maxResults = 1000;
        String docNameField = "docname";
        PrintWriter logger = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()), true);
        TrecTopicsReader qReader = new TrecTopicsReader();
        QualityQuery[] qqs = qReader.readQueries(Files.newBufferedReader(topicsFile, StandardCharsets.UTF_8));
        TrecJudge judge = new TrecJudge(Files.newBufferedReader(qrelsFile, StandardCharsets.UTF_8));
        judge.validateData(qqs, logger);
        HashSet<String> fieldSet = new HashSet<String>();
        if (fieldSpec.indexOf(84) >= 0) {
            fieldSet.add("title");
        }
        if (fieldSpec.indexOf(68) >= 0) {
            fieldSet.add("description");
        }
        if (fieldSpec.indexOf(78) >= 0) {
            fieldSet.add("narrative");
        }
        SimpleQQParser qqParser = new SimpleQQParser(fieldSet.toArray(new String[0]), "body");
        QualityBenchmark qrun = new QualityBenchmark(qqs, qqParser, searcher, docNameField);
        qrun.setMaxResults(maxResults);
        QualityStats[] stats = qrun.execute(judge, submitLog, logger);
        QualityStats avg = QualityStats.average(stats);
        avg.log("SUMMARY", 2, logger, "  ");
        reader.close();
        dir.close();
    }
}

