/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.util.LineFileDocs;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.IOUtils;

public class BaseTestCheckIndex
extends LuceneTestCase {
    public void testDeletedDocs(Directory dir) throws IOException {
        IndexWriter writer = new IndexWriter(dir, BaseTestCheckIndex.newIndexWriterConfig(new MockAnalyzer(BaseTestCheckIndex.random())).setMaxBufferedDocs(2));
        for (int i = 0; i < 19; ++i) {
            Document doc = new Document();
            FieldType customType = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
            customType.setStoreTermVectors(true);
            customType.setStoreTermVectorPositions(true);
            customType.setStoreTermVectorOffsets(true);
            doc.add((IndexableField)BaseTestCheckIndex.newField("field", "aaa" + i, customType));
            writer.addDocument((Iterable)doc);
        }
        writer.forceMerge(1);
        writer.commit();
        writer.deleteDocuments(new Term[]{new Term("field", "aaa5")});
        writer.close();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        CheckIndex checker = new CheckIndex(dir);
        checker.setInfoStream(new PrintStream((OutputStream)bos, false, IOUtils.UTF_8));
        if (VERBOSE) {
            checker.setInfoStream(System.out);
        }
        CheckIndex.Status indexStatus = checker.checkIndex();
        if (!indexStatus.clean) {
            System.out.println("CheckIndex failed");
            System.out.println(bos.toString(IOUtils.UTF_8));
            BaseTestCheckIndex.fail();
        }
        CheckIndex.Status.SegmentInfoStatus seg = (CheckIndex.Status.SegmentInfoStatus)indexStatus.segmentInfos.get(0);
        BaseTestCheckIndex.assertTrue((boolean)seg.openReaderPassed);
        BaseTestCheckIndex.assertNotNull((Object)seg.diagnostics);
        BaseTestCheckIndex.assertNotNull((Object)seg.fieldNormStatus);
        BaseTestCheckIndex.assertNull((Object)seg.fieldNormStatus.error);
        BaseTestCheckIndex.assertEquals((long)1L, (long)seg.fieldNormStatus.totFields);
        BaseTestCheckIndex.assertNotNull((Object)seg.termIndexStatus);
        BaseTestCheckIndex.assertNull((Object)seg.termIndexStatus.error);
        BaseTestCheckIndex.assertEquals((long)18L, (long)seg.termIndexStatus.termCount);
        BaseTestCheckIndex.assertEquals((long)18L, (long)seg.termIndexStatus.totFreq);
        BaseTestCheckIndex.assertEquals((long)18L, (long)seg.termIndexStatus.totPos);
        BaseTestCheckIndex.assertNotNull((Object)seg.storedFieldStatus);
        BaseTestCheckIndex.assertNull((Object)seg.storedFieldStatus.error);
        BaseTestCheckIndex.assertEquals((long)18L, (long)seg.storedFieldStatus.docCount);
        BaseTestCheckIndex.assertEquals((long)18L, (long)seg.storedFieldStatus.totFields);
        BaseTestCheckIndex.assertNotNull((Object)seg.termVectorStatus);
        BaseTestCheckIndex.assertNull((Object)seg.termVectorStatus.error);
        BaseTestCheckIndex.assertEquals((long)18L, (long)seg.termVectorStatus.docCount);
        BaseTestCheckIndex.assertEquals((long)18L, (long)seg.termVectorStatus.totVectors);
        BaseTestCheckIndex.assertNotNull(seg.diagnostics.get("java.runtime.version"));
        BaseTestCheckIndex.assertTrue((seg.diagnostics.size() > 0 ? 1 : 0) != 0);
        ArrayList<String> onlySegments = new ArrayList<String>();
        onlySegments.add("_0");
        BaseTestCheckIndex.assertTrue((checker.checkIndex(onlySegments).clean ? 1 : 0) != 0);
        checker.close();
    }

    public void testChecksumsOnly(Directory dir) throws IOException {
        LineFileDocs lf = new LineFileDocs(BaseTestCheckIndex.random());
        MockAnalyzer analyzer = new MockAnalyzer(BaseTestCheckIndex.random());
        analyzer.setMaxTokenLength(TestUtil.nextInt(BaseTestCheckIndex.random(), 1, 32766));
        IndexWriter iw = new IndexWriter(dir, BaseTestCheckIndex.newIndexWriterConfig(analyzer));
        for (int i = 0; i < 100; ++i) {
            iw.addDocument((Iterable)lf.nextDoc());
        }
        iw.addDocument((Iterable)new Document());
        iw.commit();
        iw.close();
        lf.close();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        CheckIndex checker = new CheckIndex(dir);
        checker.setInfoStream(new PrintStream((OutputStream)bos, false, IOUtils.UTF_8));
        if (VERBOSE) {
            checker.setInfoStream(System.out);
        }
        CheckIndex.Status indexStatus = checker.checkIndex();
        BaseTestCheckIndex.assertTrue((boolean)indexStatus.clean);
        checker.close();
        analyzer.close();
    }

    public void testChecksumsOnlyVerbose(Directory dir) throws IOException {
        LineFileDocs lf = new LineFileDocs(BaseTestCheckIndex.random());
        MockAnalyzer analyzer = new MockAnalyzer(BaseTestCheckIndex.random());
        analyzer.setMaxTokenLength(TestUtil.nextInt(BaseTestCheckIndex.random(), 1, 32766));
        IndexWriter iw = new IndexWriter(dir, BaseTestCheckIndex.newIndexWriterConfig(analyzer));
        for (int i = 0; i < 100; ++i) {
            iw.addDocument((Iterable)lf.nextDoc());
        }
        iw.addDocument((Iterable)new Document());
        iw.commit();
        iw.close();
        lf.close();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        CheckIndex checker = new CheckIndex(dir);
        checker.setInfoStream(new PrintStream((OutputStream)bos, true, IOUtils.UTF_8));
        if (VERBOSE) {
            checker.setInfoStream(System.out);
        }
        CheckIndex.Status indexStatus = checker.checkIndex();
        BaseTestCheckIndex.assertTrue((boolean)indexStatus.clean);
        checker.close();
        analyzer.close();
    }

    public void testObtainsLock(Directory dir) throws IOException {
        IndexWriter iw = new IndexWriter(dir, BaseTestCheckIndex.newIndexWriterConfig(null));
        iw.addDocument((Iterable)new Document());
        iw.commit();
        BaseTestCheckIndex.expectThrows(LockObtainFailedException.class, () -> new CheckIndex(dir));
        iw.close();
    }
}

