/*
 * Decompiled with CFR 0.152.
 */
package com.github.maoo.indexer.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collection;
import java.util.Map;

public class AlfrescoFilters {
    private Collection<String> siteFilters = Sets.newHashSet();
    private Collection<String> typeFilters = Sets.newHashSet();
    private Collection<String> mimetypeFilters = Sets.newHashSet();
    private Collection<String> aspectFilters = Sets.newHashSet();
    private Map<String, String> metadataFilters = Maps.newHashMap();

    public Collection<String> getSiteFilters() {
        return this.siteFilters;
    }

    public Collection<String> getTypeFilters() {
        return this.typeFilters;
    }

    public Collection<String> getMimetypeFilters() {
        return this.mimetypeFilters;
    }

    public Collection<String> getAspectFilters() {
        return this.aspectFilters;
    }

    public Map<String, String> getMetadataFilters() {
        return this.metadataFilters;
    }

    public void addSiteFilter(String site) {
        this.siteFilters.add(site);
    }

    public void addTypeFilter(String type) {
        this.typeFilters.add(type);
    }

    public void addMimetypeFilter(String mimetype) {
        this.mimetypeFilters.add(mimetype);
    }

    public void addAspectFilter(String aspect) {
        this.aspectFilters.add(aspect);
    }

    public void addMetadataFilter(String metadata, String value) {
        this.metadataFilters.put(metadata, value);
    }

    public boolean isEmpty() {
        return this.siteFilters.isEmpty() && this.typeFilters.isEmpty() && this.mimetypeFilters.isEmpty() && this.aspectFilters.isEmpty() && this.metadataFilters.isEmpty();
    }

    public String toJSONString() {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)this);
    }
}

