/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.OutMessage;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import com.mongodb.ServerError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.bson.BSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryResultIterator
implements Cursor {
    private final DBDecoder _decoder;
    private final ServerAddress _host;
    private final int _limit;
    private DBApiLayer _db;
    private DBCollection _collection;
    private long _cursorId;
    private Iterator<DBObject> _cur;
    private int _curSize;
    private int _batchSize;
    private boolean closed;
    private final List<Integer> _sizes = new ArrayList<Integer>();
    private int _numGetMores = 0;
    private int _numFetched = 0;
    private OptionalFinalizer _optionalFinalizer;
    private boolean batchSizeTrackingDisabled;

    QueryResultIterator(String namespace, Mongo mongo, Response res, int batchSize, int limit, DBDecoder decoder) {
        this._db = (DBApiLayer)mongo.getDB(this.getDatatabaseNameFromNamespace(namespace));
        this._collection = this._db.getCollection(this.getCollectionNameFromNamespace(namespace));
        this._batchSize = batchSize;
        this._limit = limit;
        this._host = res._host;
        this._decoder = decoder;
        this.initFromQueryResponse(res, mongo);
    }

    QueryResultIterator(DBObject cursorDocument, Mongo mongo, int batchSize, DBDecoder decoder, ServerAddress serverAddress) {
        this._batchSize = batchSize;
        this._host = serverAddress;
        this._limit = 0;
        this._decoder = decoder;
        this.initFromCursorDocument(cursorDocument, mongo);
    }

    static int chooseBatchSize(int batchSize, int limit, int fetched) {
        int remaining;
        int bs = Math.abs(batchSize);
        int n = remaining = limit > 0 ? limit - fetched : 0;
        int res = bs == 0 && remaining > 0 ? remaining : (bs > 0 && remaining == 0 ? bs : Math.min(bs, remaining));
        if (batchSize < 0) {
            res = -res;
        }
        if (res == 1) {
            res = -1;
        }
        return res;
    }

    @Override
    public DBObject next() {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._cur.next();
    }

    public boolean tryHasNext() {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed");
        }
        if (this._cur.hasNext()) {
            return true;
        }
        if (this._cursorId != 0L) {
            this.getMore();
        }
        return this._curSize > 0;
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed");
        }
        if (this._cur.hasNext()) {
            return true;
        }
        while (this._cursorId != 0L) {
            this.getMore();
            if (this._curSize <= 0) continue;
            return true;
        }
        return false;
    }

    private void getMore() {
        Response res = this._db._connector.call((DB)this._db, this._collection, OutMessage.getMore(this._collection, this._cursorId, this.getGetMoreBatchSize()), this._host, this._decoder);
        ++this._numGetMores;
        this.initFromQueryResponse(res, this._db.getMongo());
    }

    private int getGetMoreBatchSize() {
        return Math.abs(QueryResultIterator.chooseBatchSize(this._batchSize, this._limit, this._numFetched));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("can't remove a document via a query result iterator");
    }

    public void setBatchSize(int size) {
        this._batchSize = size;
    }

    @Override
    public long getCursorId() {
        return this._cursorId;
    }

    int numGetMores() {
        return this._numGetMores;
    }

    List<Integer> getSizes() {
        return Collections.unmodifiableList(this._sizes);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.killCursor();
        }
    }

    private void initFromQueryResponse(Response response, Mongo mongo) {
        this.init(response._flags, response.cursor(), response.size(), response.iterator(), mongo);
    }

    private void initFromCursorDocument(DBObject cursorDocument, Mongo mongo) {
        Map cursor = (Map)cursorDocument.get("cursor");
        if (cursor != null) {
            long cursorId = (Long)cursor.get("id");
            List firstBatch = (List)cursor.get("firstBatch");
            String namespace = (String)cursor.get("ns");
            this._db = (DBApiLayer)mongo.getDB(this.getDatatabaseNameFromNamespace(namespace));
            this._collection = this._db.getCollection(this.getCollectionNameFromNamespace(namespace));
            this.init(0, cursorId, firstBatch.size(), firstBatch.iterator(), mongo);
        } else {
            List result = (List)cursorDocument.get("result");
            this.init(0, 0L, result.size(), result.iterator(), mongo);
        }
    }

    private String getCollectionNameFromNamespace(String namespace) {
        return namespace.substring(namespace.indexOf(46) + 1);
    }

    private String getDatatabaseNameFromNamespace(String namespace) {
        return namespace.substring(0, namespace.indexOf(46));
    }

    private void init(int flags, long cursorId, int size, Iterator<DBObject> iterator, Mongo mongo) {
        this._curSize = size;
        this._cur = iterator;
        if (!this.batchSizeTrackingDisabled) {
            this._sizes.add(size);
        }
        this._numFetched += size;
        if (this._optionalFinalizer == null) {
            this._optionalFinalizer = this.createFinalizerIfNeeded(cursorId, mongo);
        }
        this.setCursorIdOnFinalizer(cursorId);
        this.throwOnQueryFailure(this._cursorId, flags);
        this._cursorId = cursorId;
        if (cursorId != 0L && this._limit > 0 && this._limit - this._numFetched <= 0) {
            this.killCursor();
        }
    }

    private void setCursorIdOnFinalizer(long cursorId) {
        if (this._optionalFinalizer != null) {
            this._optionalFinalizer.setCursorId(cursorId);
        }
    }

    private void throwOnQueryFailure(long cursorId, int flags) {
        if ((flags & 2) > 0) {
            BSONObject errorDocument = this._cur.next();
            if (ServerError.getCode(errorDocument) == 50) {
                throw new MongoExecutionTimeoutException(ServerError.getCode(errorDocument), ServerError.getMsg(errorDocument, null));
            }
            throw new MongoException(ServerError.getCode(errorDocument), ServerError.getMsg(errorDocument, null));
        }
        if ((flags & 1) > 0) {
            throw new MongoException.CursorNotFound(cursorId, this._host);
        }
    }

    void killCursor() {
        this.setCursorIdOnFinalizer(0L);
        if (this._cursorId == 0L) {
            return;
        }
        try {
            this._db.killCursors(this._host, Arrays.asList(this._cursorId));
            this._cursorId = 0L;
        }
        catch (MongoException e) {
            this._db.addDeadCursor(new DBApiLayer.DeadCursor(this._cursorId, this._host));
        }
    }

    @Override
    public ServerAddress getServerAddress() {
        return this._host;
    }

    void disableBatchSizeTracking() {
        this.batchSizeTrackingDisabled = true;
        this._sizes.clear();
    }

    boolean hasFinalizer() {
        return this._optionalFinalizer != null;
    }

    private OptionalFinalizer createFinalizerIfNeeded(long cursorId, Mongo mongo) {
        return mongo.getMongoOptions().isCursorFinalizerEnabled() && cursorId != 0L ? new OptionalFinalizer(this._db, this._host) : null;
    }

    private static class OptionalFinalizer {
        private final DBApiLayer db;
        private final ServerAddress host;
        private volatile long cursorId;

        private OptionalFinalizer(DBApiLayer db, ServerAddress host) {
            this.db = db;
            this.host = host;
        }

        public void setCursorId(long cursorId) {
            this.cursorId = cursorId;
        }

        protected void finalize() throws Throwable {
            if (this.cursorId != 0L) {
                this.db.addDeadCursor(new DBApiLayer.DeadCursor(this.cursorId, this.host));
            }
        }
    }
}

