/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.netcdf.Convention;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.GridAdjustment;
import org.apache.sis.internal.netcdf.GridMapping;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakHashSet;
import org.opengis.referencing.operation.Matrix;

public abstract class Variable
extends Node {
    private static final WeakHashSet<Vector> SHARED_VECTORS = new WeakHashSet(Vector.class);
    public static final Pattern TIME_UNIT_PATTERN = Pattern.compile("(.+)\\Wsince\\W(.+)", 2);
    protected static final int STRING_DIMENSION = 2;
    private VariableRole role;
    private Unit<?> unit;
    protected Instant epoch;
    private boolean unitParsed;
    private Map<Number, Object> nodataValues;
    private Map<Integer, String> enumeration;
    private GridGeometry gridGeometry;
    private boolean gridDetermined;
    int bandDimension;
    private transient Vector values;
    private transient List<?> valuesAnyType;

    protected Variable(Decoder decoder) {
        super(decoder);
    }

    protected final void setEnumeration(Map<Integer, String> map) {
        if (map == null) {
            String string3 = "flag_names";
            CharSequence[] charSequenceArray = this.getAttributeAsStrings("flag_names", ' ');
            if (charSequenceArray == null) {
                string3 = "flag_meanings";
                charSequenceArray = this.getAttributeAsStrings("flag_meanings", ' ');
                if (charSequenceArray == null) {
                    return;
                }
            }
            String string4 = "flag_values";
            Vector vector = this.getAttributeAsVector("flag_values");
            if (vector == null) {
                string4 = "flag_masks";
                vector = this.getAttributeAsVector("flag_masks");
            }
            int n = charSequenceArray.length;
            if (vector != null) {
                int n2 = vector.size();
                if (n2 != n) {
                    this.warning(Variable.class, "setEnumeration", (short)24, this.getName(), string4, string3, n2, n);
                    if (n2 < n) {
                        n = n2;
                    }
                }
            } else {
                vector = Vector.createSequence((Number)0, (Number)1, (int)n);
                this.warning(Variable.class, "setEnumeration", (short)23, this.getFilename(), this.getName(), "flag_values");
            }
            RuntimeException runtimeException = null;
            StringBuilder stringBuilder = null;
            map = new HashMap<Integer, String>(Containers.hashMapCapacity((int)n));
            for (int i = 0; i < n; ++i) {
                try {
                    CharSequence charSequence = charSequenceArray[i];
                    if (charSequence == null) continue;
                    map.merge(vector.intValue(i), charSequence.toString(), (string, string2) -> string.equals(string2) ? string : string + " | " + string2);
                    continue;
                }
                catch (ArithmeticException | NumberFormatException runtimeException2) {
                    if (runtimeException == null) {
                        runtimeException = runtimeException2;
                        stringBuilder = new StringBuilder();
                    } else {
                        boolean bl;
                        int n3 = stringBuilder.length();
                        boolean bl2 = bl = n3 > 100;
                        if (bl && stringBuilder.charAt(n3 - 1) == '\u2026') continue;
                        runtimeException.addSuppressed(runtimeException2);
                        stringBuilder.append(", ");
                        if (bl) {
                            stringBuilder.append('\u2026');
                            continue;
                        }
                    }
                    stringBuilder.append(vector.stringValue(i));
                }
            }
            if (stringBuilder != null) {
                this.error(Variable.class, "setEnumeration", runtimeException, (short)8, stringBuilder, vector.getElementType());
            }
        }
        if (!map.isEmpty()) {
            this.enumeration = map;
        }
    }

    public String getFilename() {
        return this.decoder.getFilename();
    }

    @Override
    public abstract String getName();

    public final String getStandardName() {
        String string = this.getAttributeAsString("standard_name");
        return string != null ? string : this.getName();
    }

    public abstract String getDescription();

    protected abstract String getUnitsString();

    protected abstract Unit<?> parseUnit(String var1) throws Exception;

    final Instant setUnit(Variable variable, Unit<?> unit) {
        if (variable != null) {
            this.unit = variable.getUnit();
            this.epoch = variable.epoch;
        }
        if (unit != null) {
            this.unit = unit;
        }
        this.unitParsed = true;
        return this.epoch;
    }

    public final Unit<?> getUnit() {
        if (!this.unitParsed) {
            this.unitParsed = true;
            String string = this.getUnitsString();
            Throwable throwable = null;
            if (string != null) {
                try {
                    this.unit = this.parseUnit(string);
                }
                catch (Exception exception) {
                    throwable = exception;
                }
            }
            if (this.unit == null) {
                try {
                    this.unit = this.decoder.convention().getUnitFallback(this);
                }
                catch (ParserException parserException) {
                    if (throwable == null) {
                        throwable = parserException;
                    }
                    throwable.addSuppressed(parserException);
                }
            }
            if (throwable != null) {
                this.error(Variable.class, "getUnit", (Exception)throwable, (short)183, this.getName(), string);
            }
        }
        return this.unit;
    }

    final boolean hasRealValues() {
        byte by = this.getDataType().number;
        if (by == 8 | by == 9) {
            Convention convention = this.decoder.convention();
            if (convention != Convention.DEFAULT) {
                return convention.transferFunction(this).isIdentity();
            }
            double d = this.getAttributeAsNumber("scale_factor");
            if (Double.isNaN(d) || d == 1.0) {
                d = this.getAttributeAsNumber("add_offset");
                return Double.isNaN(d) || d == 0.0;
            }
        }
        return false;
    }

    public abstract DataType getDataType();

    public final VariableRole getRole() {
        if (this.role == null) {
            String string = this.getName();
            for (Variable variable : this.decoder.getVariables()) {
                if (!string.equalsIgnoreCase(variable.getAttributeAsString("bounds"))) continue;
                this.role = VariableRole.BOUNDS;
                return this.role;
            }
            this.role = this.decoder.convention().roleOf(this);
        }
        return this.role;
    }

    final boolean isString() {
        return this.getDataType() == DataType.CHAR && this.getNumDimensions() >= 2;
    }

    protected abstract boolean isUnlimited();

    protected abstract boolean isCoordinateSystemAxis();

    protected abstract String getAxisType();

    protected Grid getGrid(GridAdjustment gridAdjustment) throws IOException, DataStoreException {
        int n;
        Convention convention = this.decoder.convention();
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        HashMap<Object, Dimension> hashMap = new HashMap<Object, Dimension>();
        for (Variable variable : this.decoder.getVariables()) {
            if (variable.getRole() != VariableRole.AXIS) continue;
            arrayList.add(variable);
            for (Dimension stringArray2 : variable.getGridDimensions()) {
                hashMap.put(stringArray2, stringArray2);
            }
        }
        boolean bl = false;
        List<Dimension> list = this.getGridDimensions();
        Dimension[] dimensionArray = list.toArray(new Dimension[list.size()]);
        for (n = 0; n < dimensionArray.length; ++n) {
            dimensionArray[n] = (Dimension)hashMap.remove(dimensionArray[n]);
            bl |= dimensionArray[n] == null;
        }
        if (bl) {
            for (n = 0; n < dimensionArray.length; ++n) {
                Dimension dimension;
                if (dimensionArray[n] != null) continue;
                String string = convention.nameOfDimension(this, n);
                if (string == null) {
                    return null;
                }
                if (bl) {
                    bl = false;
                    if (gridAdjustment.mapLabelToGridDimensions(this, arrayList, hashMap, convention)) {
                        return null;
                    }
                }
                Dimension dimension2 = list.get(n);
                dimensionArray[n] = dimension = (Dimension)hashMap.remove(string);
                if (dimension == null) {
                    this.warning(Variable.class, "getGridGeometry", (short)15, this.getFilename(), this.getName(), string);
                    return null;
                }
                if (gridAdjustment.gridToVariable.put(dimension, dimension2) == null) continue;
                throw new InternalDataStoreException(this.errors().getString((short)27, (Object)dimension));
            }
        }
        Grid grid = null;
        boolean bl2 = false;
        String[] stringArray = convention.namesOfAxisVariables(this);
        for (Grid grid2 : this.decoder.getGrids()) {
            Grid grid3 = grid2.forDimensions(dimensionArray);
            if (grid3 == null) continue;
            int n2 = grid3.getSourceDimensions();
            boolean bl3 = grid3.containsAllNamedAxes(stringArray);
            if (bl3 && n2 == dimensionArray.length) {
                return grid3;
            }
            if (!(bl3 | !bl2) || bl3 == bl2 && grid != null && n2 <= grid.getSourceDimensions()) continue;
            bl2 = bl3;
            grid = grid3;
        }
        return grid;
    }

    public final GridGeometry getGridGeometry() throws IOException, DataStoreException {
        if (!this.gridDetermined) {
            this.gridDetermined = true;
            GridMapping gridMapping = GridMapping.forVariable(this);
            GridAdjustment gridAdjustment = new GridAdjustment();
            Grid grid = this.getGrid(gridAdjustment);
            if (grid != null) {
                GridGeometry gridGeometry;
                int n;
                Object object;
                List<Dimension> list = this.getGridDimensions();
                int n2 = list.size();
                if (n2 > grid.getSourceDimensions()) {
                    boolean bl = false;
                    object = grid.getDimensions();
                    int n3 = object.size();
                    for (n = 0; n < n3; ++n) {
                        Dimension dimension = object.get(n);
                        dimension = gridAdjustment.gridToVariable.getOrDefault(dimension, dimension);
                        while (!dimension.equals(list.get(n))) {
                            if (!bl) {
                                bl = true;
                                list = new ArrayList<Dimension>(list);
                            }
                            this.bandDimension = n2 - 1 - n;
                            list.remove(n);
                            if (list.size() >= n3) continue;
                            throw new InternalDataStoreException();
                        }
                    }
                }
                if ((gridGeometry = grid.getGridGeometry(this.decoder)) != null) {
                    if (gridGeometry.isDefined(4)) {
                        object = gridGeometry.getExtent();
                        long[] lArray = new long[((GridExtent)object).getDimension()];
                        n = 0;
                        int n4 = lArray.length;
                        while (--n4 >= 0) {
                            int n5 = lArray.length - 1 - n4;
                            lArray[n4] = list.get(n5).length();
                            if (n != 0) continue;
                            n = lArray[n4] != ((GridExtent)object).getSize(n4) ? 1 : 0;
                        }
                        if (n != 0) {
                            double[] dArray = gridAdjustment.dataToGridIndices();
                            if (dArray == null || dArray.length < lArray.length) {
                                this.warning(Variable.class, "getGridGeometry", (short)17, this.getFilename(), this.getName());
                                return null;
                            }
                            object = ((GridExtent)object).resize(lArray);
                            gridGeometry = GridAdjustment.scale(gridGeometry, (GridExtent)object, grid.getAnchor(), dArray);
                        }
                    }
                    if (gridMapping != null) {
                        gridGeometry = gridMapping.adaptGridCRS(this, gridGeometry, grid.getAnchor());
                    }
                }
                this.gridGeometry = gridGeometry;
            } else if (gridMapping != null) {
                this.gridGeometry = gridMapping.createGridCRS(this);
            }
        }
        return this.gridGeometry;
    }

    final long getBandStride() throws IOException, DataStoreException {
        long l = 1L;
        GridExtent gridExtent = this.getGridGeometry().getExtent();
        int n = this.bandDimension;
        while (--n >= 0) {
            l = Math.multiplyExact(l, gridExtent.getSize(n));
        }
        return l;
    }

    public abstract int getNumDimensions();

    public abstract List<Dimension> getGridDimensions();

    final NumberRange<?> getValidRange() {
        NumberRange<?> numberRange = this.decoder.convention().validRange(this);
        if (numberRange == null) {
            numberRange = this.getRangeFallback();
        }
        return numberRange;
    }

    protected NumberRange<?> getRangeFallback() {
        int n;
        DataType dataType = this.getDataType();
        if (dataType.isInteger && (n = dataType.size() * 8) > 0 && n <= 64) {
            long l = 0L;
            long l2 = Numerics.bitmask((int)n) - 1L;
            if (!dataType.isUnsigned) {
                l = (l2 >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            for (Number number : this.getNodataValues().keySet()) {
                long l3 = number.longValue();
                long l4 = l3 - l;
                long l5 = l2 - l3;
                if (l4 < 0L || l5 < 0L) continue;
                if (l4 < l5) {
                    l = l3 + 1L;
                    continue;
                }
                l2 = l3 - 1L;
            }
            if (l2 > l) {
                if (l >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE) {
                    return NumberRange.create((int)((int)l), (boolean)true, (int)((int)l2), (boolean)true);
                }
                return NumberRange.create((long)l, (boolean)true, (long)l2, (boolean)true);
            }
        }
        return null;
    }

    final Map<Integer, String> getEnumeration() {
        return this.enumeration;
    }

    final Map<Number, Object> getNodataValues() {
        if (this.nodataValues == null) {
            this.nodataValues = CollectionsExt.unmodifiableOrCopy(this.decoder.convention().nodataValues(this));
        }
        return this.nodataValues;
    }

    final TransferFunction getTransferFunction() {
        return this.decoder.convention().transferFunction(this);
    }

    protected boolean isExternallyCached() {
        return false;
    }

    public final Vector read() throws IOException, DataStoreException {
        if (this.values == null) {
            this.setValues(this.readFully());
        }
        return this.values;
    }

    public final List<?> readAnyType() throws IOException, DataStoreException {
        if (this.valuesAnyType == null) {
            this.setValues(this.readFully());
        }
        return this.valuesAnyType;
    }

    public abstract Vector read(GridExtent var1, int[] var2) throws IOException, DataStoreException;

    public abstract List<?> readAnyType(GridExtent var1, int[] var2) throws IOException, DataStoreException;

    protected abstract Object readFully() throws IOException, DataStoreException;

    final void setValues(Object object) {
        int n;
        DataType dataType = this.getDataType();
        if (dataType == DataType.CHAR && (n = this.getNumDimensions()) >= 2) {
            List<Dimension> list = this.getGridDimensions();
            int n2 = Math.toIntExact(list.get(--n).length());
            long l = list.get(--n).length();
            while (n > 0) {
                l = Math.multiplyExact(l, list.get(--n).length());
            }
            Object[] objectArray = this.createStringArray(object, Math.toIntExact(l), n2);
            this.values = Vector.create((Object)objectArray, (boolean)false);
            this.valuesAnyType = UnmodifiableArrayList.wrap((Object[])objectArray);
            return;
        }
        Vector vector = Variable.createDecimalVector(object, dataType.isUnsigned);
        if (!this.isExternallyCached()) {
            int n3;
            double d = 0.0;
            if (Numbers.isFloat((Class)vector.getElementType()) && (n3 = vector.size() - 1) >= 0) {
                double d2 = vector.doubleValue(0);
                double d3 = vector.doubleValue(n3);
                double d4 = Math.abs((d3 - d2) / (double)n3);
                if (!Double.isNaN(d4)) {
                    double d5 = Math.ulp(Math.max(Math.abs(d2), Math.abs(d3)));
                    d = Math.min(d4, d5);
                }
            }
            vector = vector.compress(d);
        }
        this.valuesAnyType = this.values = (Vector)SHARED_VECTORS.unique((Object)vector);
    }

    protected abstract String[] createStringArray(Object var1, int var2, int var3);

    protected final List<String> createStringList(Object object, GridExtent gridExtent) {
        int n = Math.toIntExact(gridExtent.getSize(0));
        long l = gridExtent.getSize(1);
        int n2 = gridExtent.getDimension();
        while (--n2 >= 2) {
            l = Math.multiplyExact(l, gridExtent.getSize(n2));
        }
        return UnmodifiableArrayList.wrap((Object[])this.createStringArray(object, Math.toIntExact(l), n));
    }

    protected static Vector createDecimalVector(Object object, boolean bl) {
        if (object instanceof float[]) {
            return Vector.createForDecimal((float[])((float[])object));
        }
        return Vector.create((Object)object, (boolean)bl);
    }

    protected final void replaceNaN(Object object) {
        if (this.hasRealValues()) {
            int n = 0;
            for (Number number : this.getNodataValues().keySet()) {
                float f = MathFunctions.toNanFloat((int)n++);
                if (object instanceof float[]) {
                    ArraysExt.replace((float[])((float[])object), (float)number.floatValue(), (float)f);
                    continue;
                }
                if (!(object instanceof double[])) continue;
                ArraysExt.replace((double[])((double[])object), (double)number.doubleValue(), (double)f);
            }
        }
    }

    protected abstract double coordinateForAxis(int var1, int var2) throws IOException, DataStoreException;

    protected boolean trySetTransform(Matrix matrix, int n, int n2, Vector vector) throws IOException, DataStoreException {
        int n3 = vector.size() - 1;
        if (n3 >= 0) {
            Number number;
            double d = vector.doubleValue(0);
            if (n3 >= 1) {
                double d2 = vector.doubleValue(n3);
                double d3 = this.getDataType() == DataType.FLOAT ? (double)Math.max(Math.ulp((float)d), Math.ulp((float)d2)) : Math.max(Math.ulp(d), Math.ulp(d2));
                d3 = Math.max(Math.ulp(d2 - d), d3) / (double)n3;
                number = vector.increment(d3);
            } else {
                number = Double.NaN;
            }
            if (number != null) {
                matrix.setElement(n2, n, ((Number)number).doubleValue());
                matrix.setElement(n2, matrix.getNumCol() - 1, d);
                return true;
            }
        }
        return false;
    }

    protected final DataStoreContentException canNotComputePosition(ArithmeticException arithmeticException) {
        return new DataStoreContentException(this.resources().getString((short)6, this.getFilename(), this.getName()), arithmeticException);
    }

    public final void writeDataTypeName(StringBuilder stringBuilder) {
        stringBuilder.append(this.getDataType().name().toLowerCase(Locale.US));
        List<Dimension> list = this.getGridDimensions();
        int n = list.size();
        while (--n >= 0) {
            list.get(n).writeLength(stringBuilder);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getName()).append(" : ");
        this.writeDataTypeName(stringBuilder);
        if (this.isUnlimited()) {
            stringBuilder.append(" (unlimited)");
        }
        return stringBuilder.toString();
    }
}

