/*
 * Decompiled with CFR 0.152.
 */
package org.htrace.wrappers;

import org.htrace.Span;
import org.htrace.Trace;
import org.htrace.TraceScope;

public class TraceRunnable
implements Runnable {
    private final Span parent;
    private final Runnable runnable;
    private final String description;

    public TraceRunnable(Runnable runnable) {
        this(Trace.currentSpan(), runnable);
    }

    public TraceRunnable(Span parent, Runnable runnable) {
        this(parent, runnable, null);
    }

    public TraceRunnable(Span parent, Runnable runnable, String description) {
        this.parent = parent;
        this.runnable = runnable;
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.parent != null) {
            TraceScope chunk = Trace.startSpan(this.getDescription(), this.parent);
            try {
                this.runnable.run();
            }
            finally {
                chunk.close();
            }
        } else {
            this.runnable.run();
        }
    }

    private String getDescription() {
        return this.description == null ? Thread.currentThread().getName() : this.description;
    }
}

