/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.filters;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.compression.CompressionInformation;
import org.apache.sshd.common.filter.DefaultFilterChain;
import org.apache.sshd.common.filter.FilterChain;
import org.apache.sshd.common.filter.InputHandler;
import org.apache.sshd.common.filter.IoFilter;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.mac.MacInformation;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.filters.CompressionFilter;
import org.apache.sshd.common.session.filters.CryptFilter;
import org.apache.sshd.common.session.filters.IdentFilter;
import org.apache.sshd.common.session.filters.InjectIgnoreFilter;
import org.apache.sshd.common.session.filters.PacketLoggingFilter;
import org.apache.sshd.common.session.filters.SshIdentHandler;
import org.apache.sshd.common.session.filters.kex.KexFilter;
import org.apache.sshd.common.session.filters.kex.KexListener;
import org.apache.sshd.common.session.helpers.AbstractSession;

public class SshTransportFilter
extends IoFilter {
    private final FilterChain filters = new DefaultFilterChain();
    private final CryptFilter cryptFilter;
    private final CompressionFilter compressionFilter;
    private final KexFilter kexFilter;

    public SshTransportFilter(AbstractSession session, Random random, SshIdentHandler identities, SessionListener events, KexFilter.Proposer proposer, KexFilter.HostKeyChecker checker) {
        IdentFilter ident = new IdentFilter();
        ident.setPropertyResolver((PropertyResolver)session);
        ident.setIdentHandler(identities);
        this.filters.addLast(ident);
        this.cryptFilter = new CryptFilter();
        this.cryptFilter.setSession(session);
        this.filters.addLast(this.cryptFilter);
        this.compressionFilter = new CompressionFilter();
        this.compressionFilter.setSession(session);
        this.filters.addLast(this.compressionFilter);
        this.filters.addLast(new PacketLoggingFilter(session, this.cryptFilter));
        this.filters.addLast(new InjectIgnoreFilter((PropertyResolver)session));
        this.kexFilter = new KexFilter(session, random, this.cryptFilter, this.compressionFilter, events, proposer, checker);
        this.filters.addLast(this.kexFilter);
        ident.addIdentListener((peer, id) -> {
            if (peer == session.isServerSession()) {
                this.kexFilter.setClientIdent(id);
            } else {
                this.kexFilter.setServerIdent(id);
            }
        });
        this.filters.addFirst(new InConnector(this));
        this.filters.addLast(new OutConnector(this));
    }

    @Override
    public InputHandler in() {
        return this.filters.getFirst().in();
    }

    @Override
    public OutputHandler out() {
        return this.filters.getLast().out();
    }

    public KeyExchangeFuture startKex() throws Exception {
        return this.kexFilter.startKex();
    }

    public void shutdown() {
        this.kexFilter.shutdown();
    }

    public boolean isStrictKex() {
        return this.kexFilter.isStrictKex();
    }

    public boolean isInitialKexDone() {
        return this.kexFilter.isInitialKexDone();
    }

    public AtomicReference<KexState> getKexState() {
        return this.kexFilter.getKexState();
    }

    public Map<KexProposalOption, String> getNegotiated() {
        return this.kexFilter.getNegotiated();
    }

    public Map<KexProposalOption, String> getClientProposal() {
        return this.kexFilter.getClientProposal();
    }

    public Map<KexProposalOption, String> getServerProposal() {
        return this.kexFilter.getServerProposal();
    }

    public byte[] getSessionId() {
        return this.kexFilter.getSessionId();
    }

    public void addKexListener(KexListener listener) {
        this.kexFilter.addKexListener(listener);
    }

    public void removeKexListener(KexListener listener) {
        this.kexFilter.removeKexListener(listener);
    }

    public void addEncryptionListener(CryptFilter.EncryptionListener listener) {
        this.cryptFilter.addEncryptionListener(listener);
    }

    public void removeEncryptionListener(CryptFilter.EncryptionListener listener) {
        this.cryptFilter.removeEncryptionListener(listener);
    }

    public boolean isSecure() {
        return this.cryptFilter.isSecure();
    }

    public long getLastInputSequenceNumber() {
        return this.cryptFilter.getLastInputSequenceNumber();
    }

    public long getInputSequenceNumber() {
        return this.cryptFilter.getInputSequenceNumber();
    }

    public long getOutputSequenceNumber() {
        return this.cryptFilter.getOutputSequenceNumber();
    }

    public CipherInformation getCipherInformation(boolean incoming) {
        return incoming ? this.cryptFilter.getInputSettings().getCipher() : this.cryptFilter.getOutputSettings().getCipher();
    }

    public MacInformation getMacInformation(boolean incoming) {
        return incoming ? this.cryptFilter.getInputSettings().getMac() : this.cryptFilter.getOutputSettings().getMac();
    }

    public void enableInputCompression() {
        this.compressionFilter.enableInput();
    }

    public void enableOutputCompression() {
        this.compressionFilter.enableOutput();
    }

    public CompressionInformation getCompressionInformation(boolean incoming) {
        return incoming ? this.compressionFilter.getInputCompression() : this.compressionFilter.getOutputCompression();
    }

    private static class InConnector
    extends IoFilter {
        private final SshTransportFilter transport;

        InConnector(SshTransportFilter transport) {
            this.transport = transport;
        }

        @Override
        public InputHandler in() {
            return this.owner()::passOn;
        }

        @Override
        public OutputHandler out() {
            return this.transport.owner()::send;
        }
    }

    private static class OutConnector
    extends IoFilter {
        private final SshTransportFilter transport;

        OutConnector(SshTransportFilter transport) {
            this.transport = transport;
        }

        @Override
        public InputHandler in() {
            return this.transport.owner()::passOn;
        }

        @Override
        public OutputHandler out() {
            return this.owner()::send;
        }
    }
}

