/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.cache.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.iterable.S3Objects;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.minifi.c2.api.ConfigurationProviderException;
import org.apache.nifi.minifi.c2.api.cache.ConfigurationCacheFileInfo;
import org.apache.nifi.minifi.c2.api.cache.WriteableConfiguration;
import org.apache.nifi.minifi.c2.api.util.Pair;
import org.apache.nifi.minifi.c2.cache.s3.S3WritableConfiguration;

public class S3CacheFileInfoImpl
implements ConfigurationCacheFileInfo {
    private final AmazonS3 s3;
    private final String bucket;
    private final String prefix;
    private final String expectedFilename;

    public S3CacheFileInfoImpl(AmazonS3 s3, String bucket, String prefix, String expectedFilename) {
        this.s3 = s3;
        this.bucket = bucket;
        this.prefix = prefix;
        this.expectedFilename = expectedFilename;
    }

    public Integer getVersionIfMatch(String objectKey) {
        String filename = objectKey.substring(this.prefix.length());
        int expectedFilenameLength = this.expectedFilename.length();
        if (!filename.startsWith(this.expectedFilename) || filename.length() == expectedFilenameLength) {
            return null;
        }
        try {
            return Integer.parseInt(filename.substring(expectedFilenameLength));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public WriteableConfiguration getConfiguration(Integer version) throws ConfigurationProviderException {
        if (version == null) {
            try {
                return this.getCachedConfigurations().findFirst().orElseThrow(() -> new ConfigurationProviderException("No configurations found."));
            }
            catch (IOException e) {
                throw new ConfigurationProviderException("Unable to get cached configurations.", (Throwable)e);
            }
        }
        S3Object s3Object = StringUtils.isEmpty((CharSequence)this.prefix) || StringUtils.equals((CharSequence)this.prefix, (CharSequence)"/") ? this.s3.getObject(new GetObjectRequest(this.bucket, this.expectedFilename + version.toString())) : this.s3.getObject(new GetObjectRequest(this.bucket, this.prefix + this.expectedFilename + version.toString()));
        if (s3Object == null) {
            throw new ConfigurationProviderException("No configurations found for object key.");
        }
        return new S3WritableConfiguration(this.s3, s3Object, Integer.toString(version));
    }

    public Stream<WriteableConfiguration> getCachedConfigurations() throws IOException {
        S3Objects objectSummaries = S3Objects.withPrefix((AmazonS3)this.s3, (String)this.bucket, (String)this.prefix);
        Stream<S3ObjectSummary> objectStream = StreamSupport.stream(objectSummaries.spliterator(), false);
        return objectStream.map(p -> {
            Integer version = this.getVersionIfMatch(p.getKey());
            if (version == null) {
                return null;
            }
            return new Pair((Object)version, p);
        }).filter(Objects::nonNull).sorted(Comparator.comparing(pair -> (Integer)((Pair)pair).getFirst()).reversed()).map(pair -> new S3WritableConfiguration(this.s3, (S3ObjectSummary)pair.getSecond(), Integer.toString((Integer)pair.getFirst())));
    }
}

