/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension;

import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.extension.ExtensionBundleMetadata;

public class AbstractExtensionBundleMetadata
implements ExtensionBundleMetadata {
    private final String registryIdentifier;
    private final String group;
    private final String artifact;
    private final String version;
    private final long timestamp;

    public AbstractExtensionBundleMetadata(String registryIdentifier, String group, String artifact, String version, long timestamp) {
        this.registryIdentifier = (String)Validate.notBlank((CharSequence)registryIdentifier);
        this.group = (String)Validate.notBlank((CharSequence)group);
        this.artifact = (String)Validate.notBlank((CharSequence)artifact);
        this.version = (String)Validate.notBlank((CharSequence)version);
        this.timestamp = timestamp;
    }

    public String getRegistryIdentifier() {
        return this.registryIdentifier;
    }

    public String getGroup() {
        return this.group;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.group, this.artifact, this.version, this.registryIdentifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractExtensionBundleMetadata otherMetadata = (AbstractExtensionBundleMetadata)o;
        return Objects.equals(this.group, otherMetadata.group) && Objects.equals(this.artifact, otherMetadata.artifact) && Objects.equals(this.version, otherMetadata.version) && Objects.equals(this.registryIdentifier, otherMetadata.registryIdentifier);
    }
}

