/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToShortFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class CastSymbolToShortFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ke)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CastSymbolToShortFunction(args.getQuick(0));
    }

    public static class CastSymbolToShortFunction
    extends AbstractCastToShortFunction {
        private final Function arg;

        public CastSymbolToShortFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public short getShort(Record rec) {
            CharSequence sequence = this.arg.getSymbol(rec);
            try {
                if (sequence == null) {
                    return 0;
                }
                return (short)Numbers.parseInt(sequence);
            }
            catch (NumericException e) {
                return 0;
            }
        }
    }
}

