/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class FloorFloatFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "floor(F)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new FloorFunction(args.getQuick(0));
    }

    private static class FloorFunction
    extends FloatFunction
    implements UnaryFunction {
        private final Function function;

        public FloorFunction(Function function) {
            this.function = function;
        }

        @Override
        public Function getArg() {
            return this.function;
        }

        @Override
        public float getFloat(Record rec) {
            float value = this.function.getFloat(rec);
            return (float)Math.floor(value);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("floor(").val(this.function).val(')');
        }
    }
}

