/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.AuthorizationCodeCredential;
import com.azure.identity.implementation.util.ValidationUtil;
import java.net.URI;
import java.net.URISyntaxException;

public class AuthorizationCodeCredentialBuilder
extends AadCredentialBuilderBase<AuthorizationCodeCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationCodeCredentialBuilder.class);
    private static final String CLASS_NAME = AuthorizationCodeCredentialBuilder.class.getSimpleName();
    private String authCode;
    private String redirectUrl;
    private String clientSecret;

    public AuthorizationCodeCredentialBuilder authorizationCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public AuthorizationCodeCredentialBuilder redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public AuthorizationCodeCredentialBuilder clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public AuthorizationCodeCredential build() {
        ValidationUtil.validate(CLASS_NAME, LOGGER, "clientId", this.clientId, "authorizationCode", this.authCode, "redirectUrl", this.redirectUrl);
        try {
            return new AuthorizationCodeCredential(this.clientId, this.clientSecret, this.tenantId, this.authCode, new URI(this.redirectUrl), this.identityClientOptions);
        }
        catch (URISyntaxException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }
}

