/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.mvstore.db;

import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collection;
import v14.h2.engine.Database;
import v14.h2.expression.Expression;
import v14.h2.message.DbException;
import v14.h2.mvstore.MVStore;
import v14.h2.mvstore.db.MVPlainTempResult;
import v14.h2.mvstore.db.MVSortedTempResult;
import v14.h2.mvstore.db.MVTableEngine;
import v14.h2.result.ResultExternal;
import v14.h2.result.SortOrder;
import v14.h2.store.fs.FileUtils;
import v14.h2.util.TempFileDeleter;
import v14.h2.value.TypeInfo;
import v14.h2.value.Value;

public abstract class MVTempResult
implements ResultExternal {
    final MVStore store;
    final Expression[] expressions;
    final int visibleColumnCount;
    final int resultColumnCount;
    final boolean hasEnum;
    int rowCount;
    final MVTempResult parent;
    int childCount;
    boolean closed;
    private final TempFileDeleter tempFileDeleter;
    private final CloseImpl closeable;
    private final Reference<?> fileRef;

    public static ResultExternal of(Database database, Expression[] expressionArray, boolean bl, int[] nArray, int n, int n2, SortOrder sortOrder) {
        return bl || nArray != null || sortOrder != null ? new MVSortedTempResult(database, expressionArray, bl, nArray, n, n2, sortOrder) : new MVPlainTempResult(database, expressionArray, n, n2);
    }

    MVTempResult(MVTempResult mVTempResult) {
        this.parent = mVTempResult;
        this.store = mVTempResult.store;
        this.expressions = mVTempResult.expressions;
        this.visibleColumnCount = mVTempResult.visibleColumnCount;
        this.resultColumnCount = mVTempResult.resultColumnCount;
        this.hasEnum = mVTempResult.hasEnum;
        this.tempFileDeleter = null;
        this.closeable = null;
        this.fileRef = null;
    }

    MVTempResult(Database database, Expression[] expressionArray, int n, int n2) {
        try {
            String string = FileUtils.createTempFile("h2tmp", ".temp.db", true);
            MVStore.Builder builder = new MVStore.Builder().fileName(string).cacheSize(0).autoCommitDisabled();
            byte[] byArray = database.getFileEncryptionKey();
            if (byArray != null) {
                builder.encryptionKey(MVTableEngine.decodePassword(byArray));
            }
            this.store = builder.open();
            this.expressions = expressionArray;
            this.visibleColumnCount = n;
            this.resultColumnCount = n2;
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                Expression expression = expressionArray[i];
                if (expression.getType().getValueType() != 25) continue;
                bl = true;
                break;
            }
            this.hasEnum = bl;
            this.tempFileDeleter = database.getTempFileDeleter();
            this.closeable = new CloseImpl(this.store, string);
            this.fileRef = this.tempFileDeleter.addFile(this.closeable, this);
        }
        catch (IOException iOException) {
            throw DbException.convert(iOException);
        }
        this.parent = null;
    }

    @Override
    public int addRows(Collection<Value[]> collection) {
        for (Value[] valueArray : collection) {
            this.addRow(valueArray);
        }
        return this.rowCount;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parent != null) {
            this.parent.closeChild();
        } else if (this.childCount == 0) {
            this.delete();
        }
    }

    private synchronized void closeChild() {
        if (--this.childCount == 0 && this.closed) {
            this.delete();
        }
    }

    private void delete() {
        this.tempFileDeleter.deleteFile(this.fileRef, this.closeable);
    }

    final void fixEnum(Value[] valueArray) {
        int n = this.resultColumnCount;
        for (int i = 0; i < n; ++i) {
            TypeInfo typeInfo = this.expressions[i].getType();
            if (typeInfo.getValueType() != 25) continue;
            valueArray[i] = typeInfo.getExtTypeInfo().cast(valueArray[i]);
        }
    }

    private static final class CloseImpl
    implements AutoCloseable {
        private final MVStore store;
        private final String fileName;

        CloseImpl(MVStore mVStore, String string) {
            this.store = mVStore;
            this.fileName = string;
        }

        @Override
        public void close() throws Exception {
            this.store.closeImmediately();
            FileUtils.tryDelete(this.fileName);
        }
    }
}

