/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;

public class AbstractJerseyClient {
    private static final RequestConfig EMPTY_REQUEST_CONFIG = () -> Collections.emptyMap();
    private final RequestConfig requestConfig;

    public AbstractJerseyClient(RequestConfig requestConfig) {
        this.requestConfig = requestConfig == null ? EMPTY_REQUEST_CONFIG : requestConfig;
    }

    protected RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    protected Invocation.Builder getRequestBuilder(WebTarget webTarget) {
        Invocation.Builder requestBuilder = webTarget.request();
        Map<String, String> headers = this.requestConfig.getHeaders();
        headers.entrySet().stream().forEach(e -> requestBuilder.header((String)e.getKey(), e.getValue()));
        return requestBuilder;
    }

    protected <T> T executeAction(String errorMessage, NiFiAction<T> action) throws NiFiClientException, IOException {
        try {
            return action.execute();
        }
        catch (Exception e) {
            Throwable ioeCause = this.getIOExceptionCause(e);
            if (ioeCause == null) {
                StringBuilder errorMessageBuilder = new StringBuilder(errorMessage);
                if (e instanceof WebApplicationException) {
                    Response response = ((WebApplicationException)e).getResponse();
                    String responseBody = (String)response.readEntity(String.class);
                    errorMessageBuilder.append(": ").append(responseBody);
                }
                throw new NiFiClientException(errorMessageBuilder.toString(), e);
            }
            throw (IOException)ioeCause;
        }
    }

    protected Throwable getIOExceptionCause(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof IOException) {
            return e;
        }
        return this.getIOExceptionCause(e.getCause());
    }

    protected static interface NiFiAction<T> {
        public T execute();
    }
}

