/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;

public class PGCreateControllerService
extends AbstractNiFiCommand<StringResult> {
    public PGCreateControllerService() {
        super("pg-create-service", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates the controller service for the given process group from the local file.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String processorGroupId = this.getRequiredArg(properties, CommandOption.PG_ID);
        String inputFile = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        URI uri = Paths.get(inputFile, new String[0]).toAbsolutePath().toUri();
        String contents = IOUtils.toString((URI)uri, (Charset)StandardCharsets.UTF_8);
        ObjectMapper objectMapper = JacksonUtils.getObjectMapper();
        ControllerServiceEntity deserializedService = (ControllerServiceEntity)objectMapper.readValue(contents, ControllerServiceEntity.class);
        if (deserializedService == null) {
            throw new IOException("Unable to deserialize controller service version from " + inputFile);
        }
        deserializedService.setRevision(this.getInitialRevisionDTO());
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        ControllerServiceEntity createdEntity = pgClient.createControllerService(processorGroupId, deserializedService);
        return new StringResult(String.valueOf(createdEntity.getId()), this.getContext().isInteractive());
    }
}

