/*
 * Decompiled with CFR 0.152.
 */
package v21.h2.expression.aggregate;

import v21.h2.engine.SessionLocal;
import v21.h2.expression.aggregate.AggregateDataBinarySet;
import v21.h2.expression.aggregate.AggregateType;
import v21.h2.message.DbException;
import v21.h2.value.Value;
import v21.h2.value.ValueDouble;
import v21.h2.value.ValueNull;

final class AggregateDataCovar
extends AggregateDataBinarySet {
    private final AggregateType aggregateType;
    private long count;
    private double sumY;
    private double sumX;
    private double sumYX;

    AggregateDataCovar(AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    @Override
    void add(SessionLocal sessionLocal, Value value, Value value2) {
        double d = value.getDouble();
        double d2 = value2.getDouble();
        this.sumY += d;
        this.sumX += d2;
        this.sumYX += d * d2;
        ++this.count;
    }

    @Override
    Value getValue(SessionLocal sessionLocal) {
        double d;
        switch (this.aggregateType) {
            case COVAR_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                d = (this.sumYX - this.sumX * this.sumY / (double)this.count) / (double)this.count;
                break;
            }
            case COVAR_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                d = (this.sumYX - this.sumX * this.sumY / (double)this.count) / (double)(this.count - 1L);
                break;
            }
            case REGR_SXY: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                d = this.sumYX - this.sumX * this.sumY / (double)this.count;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return ValueDouble.get(d);
    }
}

