/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKeySignatureAlgorithm;
import java.io.IOException;
import java.util.Objects;

public final class KeyVerifyParameters
implements JsonSerializable<KeyVerifyParameters> {
    private JsonWebKeySignatureAlgorithm algorithm;
    private Base64Url digest;
    private Base64Url signature;

    public JsonWebKeySignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public KeyVerifyParameters setAlgorithm(JsonWebKeySignatureAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public byte[] getDigest() {
        if (this.digest == null) {
            return null;
        }
        return this.digest.decodedBytes();
    }

    public KeyVerifyParameters setDigest(byte[] digest) {
        this.digest = digest == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])digest));
        return this;
    }

    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        return this.signature.decodedBytes();
    }

    public KeyVerifyParameters setSignature(byte[] signature) {
        this.signature = signature == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])signature));
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alg", Objects.toString((Object)this.algorithm, null));
        jsonWriter.writeStringField("digest", Objects.toString(this.digest, null));
        jsonWriter.writeStringField("value", Objects.toString(this.signature, null));
        return jsonWriter.writeEndObject();
    }

    public static KeyVerifyParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVerifyParameters)jsonReader.readObject(reader -> {
            KeyVerifyParameters deserializedKeyVerifyParameters = new KeyVerifyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("alg".equals(fieldName)) {
                    deserializedKeyVerifyParameters.algorithm = JsonWebKeySignatureAlgorithm.fromString(reader.getString());
                    continue;
                }
                if ("digest".equals(fieldName)) {
                    deserializedKeyVerifyParameters.digest = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedKeyVerifyParameters.signature = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVerifyParameters;
        });
    }
}

