/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToShortFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastCharToShortFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ae)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CastCharToShortFunction(args.getQuick(0));
    }

    public static class CastCharToShortFunction
    extends AbstractCastToShortFunction {
        private final Function arg;

        public CastCharToShortFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public short getShort(Record rec) {
            byte v = (byte)(this.arg.getChar(rec) - 48);
            return v > -1 && v < 10 ? (short)v : (short)0;
        }
    }
}

