/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Chars;
import io.questdb.std.Hash;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.str.ByteCharSequence;
import io.questdb.std.str.DirectByteCharSequence;
import java.util.Arrays;

public class ByteCharSequenceIntHashMap
implements Mutable {
    public static final int NO_ENTRY_VALUE = -1;
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final int initialCapacity;
    private final double loadFactor;
    private final int noEntryValue;
    private int capacity;
    private int free;
    private int[] hashCodes;
    private ByteCharSequence[] keys;
    private int mask;
    private int[] values;

    public ByteCharSequenceIntHashMap() {
        this(8);
    }

    public ByteCharSequenceIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1);
    }

    public ByteCharSequenceIntHashMap(int initialCapacity, double loadFactor, int noEntryValue) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.capacity = initialCapacity < 16 ? 16 : Numbers.ceilPow2(initialCapacity);
        this.free = this.capacity;
        this.initialCapacity = this.capacity;
        this.loadFactor = loadFactor;
        int len = Numbers.ceilPow2((int)((double)this.capacity / loadFactor));
        this.keys = new ByteCharSequence[len];
        this.hashCodes = new int[len];
        this.mask = len - 1;
        this.noEntryValue = noEntryValue;
        this.values = new int[this.keys.length];
        this.clear();
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public final void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.hashCodes, 0);
        this.free = this.capacity;
        Arrays.fill(this.values, this.noEntryValue);
    }

    public boolean contains(DirectByteCharSequence key) {
        return this.keyIndex(key) < 0;
    }

    public boolean excludes(DirectByteCharSequence key) {
        return this.keyIndex(key) > -1;
    }

    public int get(DirectByteCharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public int get(ByteCharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public int keyIndex(DirectByteCharSequence key) {
        int hashCode = Hash.hashMem32(key);
        int index = hashCode & this.mask;
        if (this.keys[index] == null) {
            return index;
        }
        if (hashCode == this.hashCodes[index] && Chars.equals(key, this.keys[index])) {
            return -index - 1;
        }
        return this.probe(key, (long)hashCode, index);
    }

    public int keyIndex(ByteCharSequence key) {
        int hashCode = Hash.hashMem32(key);
        int index = hashCode & this.mask;
        if (this.keys[index] == null) {
            return index;
        }
        if (hashCode == this.hashCodes[index] && Chars.equals(key, this.keys[index])) {
            return -index - 1;
        }
        return this.probe(key, (long)hashCode, index);
    }

    public boolean put(ByteCharSequence key, int value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, ByteCharSequence key, int value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.putAt0(index, key, value);
        return true;
    }

    public int remove(DirectByteCharSequence key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            this.removeAt(index);
            return -index - 1;
        }
        return -1;
    }

    public void removeAt(int index) {
        if (index < 0) {
            int from = -index - 1;
            this.erase(from);
            ++this.free;
            from = from + 1 & this.mask;
            ByteCharSequence key = this.keys[from];
            while (key != null) {
                int to;
                int hashCode = Hash.hashMem32(key);
                int idealHit = hashCode & this.mask;
                if (idealHit != from && (to = this.keys[idealHit] != null ? this.probe(key, (long)hashCode, idealHit) : idealHit) > -1) {
                    this.move(from, to);
                }
                from = from + 1 & this.mask;
                key = this.keys[from];
            }
        }
    }

    public void reset() {
        if (this.capacity == this.initialCapacity) {
            this.clear();
        } else {
            this.free = this.capacity = this.initialCapacity;
            int len = Numbers.ceilPow2((int)((double)this.capacity / this.loadFactor));
            this.keys = new ByteCharSequence[len];
            this.hashCodes = new int[len];
            this.mask = len - 1;
            this.values = new int[this.keys.length];
            this.clear();
        }
    }

    public int size() {
        return this.capacity - this.free;
    }

    public int valueAt(int index) {
        int index1 = -index - 1;
        return index < 0 ? this.values[index1] : this.noEntryValue;
    }

    private void erase(int index) {
        this.keys[index] = null;
        this.hashCodes[index] = 0;
        this.values[index] = this.noEntryValue;
    }

    private int hash(CharSequence k) {
        return Chars.hashCode(k) & this.mask;
    }

    private void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.hashCodes[to] = this.hashCodes[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    private int probe(DirectByteCharSequence key, long hashCode, int index) {
        do {
            if (this.keys[index = index + 1 & this.mask] != null) continue;
            return index;
        } while (hashCode != (long)this.hashCodes[index] || !Chars.equals(key, this.keys[index]));
        return -index - 1;
    }

    private int probe(ByteCharSequence key, long hashCode, int index) {
        do {
            if (this.keys[index = index + 1 & this.mask] != null) continue;
            return index;
        } while (hashCode != (long)this.hashCodes[index] || !Chars.equals(key, this.keys[index]));
        return -index - 1;
    }

    private void putAt0(int index, ByteCharSequence key, int value) {
        this.keys[index] = key;
        this.hashCodes[index] = Hash.hashMem32(key);
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        int[] oldValues = this.values;
        ByteCharSequence[] oldKeys = this.keys;
        int[] oldHashCodes = this.hashCodes;
        int size = this.capacity - this.free;
        this.capacity *= 2;
        this.free = this.capacity - size;
        this.mask = Numbers.ceilPow2((int)((double)this.capacity / this.loadFactor)) - 1;
        this.keys = new ByteCharSequence[this.mask + 1];
        this.hashCodes = new int[this.mask + 1];
        this.values = new int[this.mask + 1];
        for (int i = oldKeys.length - 1; i > -1; --i) {
            ByteCharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.hashCodes[index] = oldHashCodes[i];
            this.values[index] = oldValues[i];
        }
    }
}

