/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.admin.nodemanager;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.properties.NiFiPropertiesLoader;
import org.apache.nifi.toolkit.admin.AbstractAdminTool;
import org.apache.nifi.toolkit.admin.client.ClientFactory;
import org.apache.nifi.toolkit.admin.client.NiFiClientFactory;
import org.apache.nifi.toolkit.admin.client.NiFiClientUtil;
import org.apache.nifi.toolkit.admin.util.AdminUtil;
import org.apache.nifi.util.NiFiBootstrapUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.entity.ClusterEntity;
import org.apache.nifi.web.api.entity.NodeEntity;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManagerTool
extends AbstractAdminTool {
    private static final String DEFAULT_DESCRIPTION = "This tool is used to manage nodes within a cluster. Supported functionality will remove node from cluster. ";
    private static final String HELP_ARG = "help";
    private static final String VERBOSE_ARG = "verbose";
    private static final String PROXY_DN = "proxyDn";
    private static final String BOOTSTRAP_CONF = "bootstrapConf";
    private static final String NIFI_INSTALL_DIR = "nifiInstallDir";
    private static final String CLUSTER_URLS = "clusterUrls";
    private static final String REMOVE = "remove";
    private static final String DISCONNECT = "disconnect";
    private static final String CONNECT = "connect";
    private static final String NODE_STATUS = "status";
    private static final String OPERATION = "operation";
    private static final String NODE_ENDPOINT = "/nifi-api/controller/cluster/nodes";
    private static final String NIFI_ENDPOINT = "/nifi";
    private static final String SUPPORTED_MINIMUM_VERSION = "1.0.0";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public NodeManagerTool() {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        Object object = callSiteArray[0].callCurrent((GroovyObject)this, (Object)DEFAULT_DESCRIPTION);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, NodeManagerTool.class, (GroovyObject)this, (String)"header");
        callSiteArray[1].callCurrent((GroovyObject)this);
    }

    public NodeManagerTool(String description) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        Object object = callSiteArray[2].callCurrent((GroovyObject)this, (Object)description);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, NodeManagerTool.class, (GroovyObject)this, (String)"header");
        callSiteArray[3].callCurrent((GroovyObject)this);
    }

    @Override
    protected Logger getLogger() {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        return (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(LoggerFactory.class, NodeManagerTool.class), Logger.class);
    }

    @Override
    protected Options getOptions() {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        Options options = (Options)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callConstructor(Options.class), Options.class);
        callSiteArray[6].call((Object)options, callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(Option.class, (Object)"h"), (Object)HELP_ARG), (Object)"Print help info")));
        callSiteArray[11].call((Object)options, callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call(Option.class, (Object)"v"), (Object)VERBOSE_ARG), (Object)"Set mode to verbose (default is false)")));
        callSiteArray[16].call((Object)options, callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(Option.class, (Object)"p"), (Object)PROXY_DN)), (Object)"User or Proxy DN that has permission to send a notification. User must have view and modify privileges to 'access the controller' in NiFi")));
        callSiteArray[22].call((Object)options, callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].call(Option.class, (Object)"b"), (Object)BOOTSTRAP_CONF)), (Object)"Existing Bootstrap Configuration file")));
        callSiteArray[28].call((Object)options, callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].call(Option.class, (Object)"d"), (Object)NIFI_INSTALL_DIR)), (Object)"NiFi Installation Directory")));
        callSiteArray[34].call((Object)options, callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].call(Option.class, (Object)"o"), (Object)OPERATION)), (Object)"Operations supported: status, connect (cluster), disconnect(cluster), remove (cluster)")));
        callSiteArray[40].call((Object)options, callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(Option.class, (Object)"u"), (Object)CLUSTER_URLS)), (Object)"List of active urls for the cluster")));
        return options;
    }

    public NodeDTO getCurrentNode(ClusterEntity clusterEntity, NiFiProperties niFiProperties) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        List nodeDTOs = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callGetProperty(callSiteArray[47].callGetProperty((Object)clusterEntity)), List.class);
        Reference nodeHost = new Reference((Object)ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call(StringUtils.class, callSiteArray[49].call((Object)niFiProperties, callSiteArray[50].callGetProperty(NiFiProperties.class)))) ? "localhost" : callSiteArray[51].call((Object)niFiProperties, callSiteArray[52].callGetProperty(NiFiProperties.class)))));
        public final class _getCurrentNode_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference nodeHost;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getCurrentNode_closure1(Object _outerInstance, Object _thisObject, Reference nodeHost) {
                Reference reference;
                CallSite[] callSiteArray = _getCurrentNode_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.nodeHost = reference = nodeHost;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getCurrentNode_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)this.nodeHost.get());
            }

            @Generated
            public String getNodeHost() {
                CallSite[] callSiteArray = _getCurrentNode_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.nodeHost.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getCurrentNode_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getCurrentNode_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "address";
                return new CallSiteArray(_getCurrentNode_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getCurrentNode_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (NodeDTO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call((Object)nodeDTOs, (Object)new _getCurrentNode_closure1(this, this, nodeHost)), NodeDTO.class);
    }

    public NodeEntity updateNode(String url, Client client, NodeDTO nodeDTO, STATUS nodeStatus, String proxyDN) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        WebTarget webTarget = (WebTarget)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].call((Object)client, (Object)url), WebTarget.class);
        STATUS sTATUS = nodeStatus;
        ScriptBytecodeAdapter.setProperty((Object)((Object)sTATUS), null, (Object)nodeDTO, (String)NODE_STATUS);
        String json = ShortTypeHandling.castToString((Object)callSiteArray[55].call(NiFiClientUtil.class, (Object)nodeDTO));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[57].call(callSiteArray[58].callGroovyObjectGetProperty((Object)this), callSiteArray[59].call((Object)"Sending node info for update: ", (Object)json));
        }
        Response response = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call((Object)url, (Object)"https"))) {
            Object object = callSiteArray[61].call(callSiteArray[62].call(callSiteArray[63].call((Object)webTarget), callSiteArray[64].callGetProperty(ProxiedEntitiesUtils.class), callSiteArray[65].call(ProxiedEntitiesUtils.class, (Object)proxyDN)), callSiteArray[66].call(Entity.class, (Object)json));
            response = (Response)ScriptBytecodeAdapter.castToType((Object)object, Response.class);
        } else {
            Object object = callSiteArray[67].call(callSiteArray[68].call((Object)webTarget), callSiteArray[69].call(Entity.class, (Object)json));
            response = (Response)ScriptBytecodeAdapter.castToType((Object)object, Response.class);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[70].callGetProperty((Object)response), (Object)200)) {
            throw (Throwable)callSiteArray[71].callConstructor(RuntimeException.class, callSiteArray[72].call(callSiteArray[73].call(callSiteArray[74].call((Object)"Failed with HTTP error code ", callSiteArray[75].callGetProperty((Object)response)), (Object)" with reason: "), callSiteArray[76].call((Object)response, String.class)));
        }
        return (NodeEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].call((Object)response, NodeEntity.class), NodeEntity.class);
    }

    public void deleteNode(String url, Client client, String proxyDN) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        WebTarget webTarget = (WebTarget)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].call((Object)client, (Object)url), WebTarget.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[79].callGroovyObjectGetProperty((Object)this))) {
            callSiteArray[80].call(callSiteArray[81].callGroovyObjectGetProperty((Object)this), (Object)"Attempting to delete node");
        }
        Response response = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[82].call((Object)url, (Object)"https"))) {
            Object object = callSiteArray[83].call(callSiteArray[84].call(callSiteArray[85].call((Object)webTarget), callSiteArray[86].callGetProperty(ProxiedEntitiesUtils.class), callSiteArray[87].call(ProxiedEntitiesUtils.class, (Object)proxyDN)));
            response = (Response)ScriptBytecodeAdapter.castToType((Object)object, Response.class);
        } else {
            Object object = callSiteArray[88].call(callSiteArray[89].call((Object)webTarget));
            response = (Response)ScriptBytecodeAdapter.castToType((Object)object, Response.class);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[90].callGetProperty((Object)response), (Object)200)) {
            throw (Throwable)callSiteArray[91].callConstructor(RuntimeException.class, callSiteArray[92].call(callSiteArray[93].call(callSiteArray[94].call((Object)"Failed with HTTP error code ", callSiteArray[95].callGetProperty((Object)response)), (Object)" with reason: "), callSiteArray[96].call((Object)response, String.class)));
        }
    }

    public void getStatus(Client client, NiFiProperties niFiProperties, List<String> activeUrls) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual(activeUrls, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[97].callGetProperty(activeUrls))) {
            List list;
            String nodeUrl = ShortTypeHandling.castToString((Object)callSiteArray[98].call(NiFiClientUtil.class, (Object)niFiProperties, null));
            activeUrls = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{nodeUrl});
        }
        String activeUrl = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[99].call(activeUrls), Iterator.class);
        while (iterator.hasNext()) {
            activeUrl = ShortTypeHandling.castToString(iterator.next());
            String url = ShortTypeHandling.castToString((Object)callSiteArray[100].call((Object)activeUrl, (Object)NIFI_ENDPOINT));
            WebTarget webTarget = (WebTarget)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].call((Object)client, (Object)url), WebTarget.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[102].callGroovyObjectGetProperty((Object)this))) {
                callSiteArray[103].call(callSiteArray[104].callGroovyObjectGetProperty((Object)this), (Object)"Checking if node is available");
            }
            try {
                Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].call(callSiteArray[106].call((Object)webTarget)), Response.class);
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[107].callGetProperty((Object)response), (Object)200)) {
                    callSiteArray[108].call(callSiteArray[109].callGetProperty(System.class), callSiteArray[110].call((Object)"NiFi Node is running and available at ", (Object)url));
                    continue;
                }
                callSiteArray[111].call(callSiteArray[112].callGetProperty(System.class), callSiteArray[113].call(callSiteArray[114].call(callSiteArray[115].call(callSiteArray[116].call(callSiteArray[117].call((Object)"Attempt to contact NiFi Node at ", (Object)url), (Object)" returned Response Code: "), callSiteArray[118].callGetProperty((Object)response)), (Object)" with reason: "), callSiteArray[119].call((Object)response, String.class)));
            }
            catch (Exception ex) {
                callSiteArray[120].call(callSiteArray[121].callGetProperty(System.class), callSiteArray[122].call(callSiteArray[123].call(callSiteArray[124].call((Object)"Attempt to contact NiFi Node ", (Object)url), (Object)" did not complete due to exception: "), callSiteArray[125].callGetProperty((Object)ex)));
            }
        }
    }

    public void disconnectNode(Client client, NiFiProperties niFiProperties, List<String> activeUrls, String proxyDN) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        ClusterEntity clusterEntity = (ClusterEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[126].call(NiFiClientUtil.class, (Object)client, (Object)niFiProperties, activeUrls, (Object)proxyDN), ClusterEntity.class);
        NodeDTO currentNode = (NodeDTO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[127].callCurrent((GroovyObject)this, (Object)clusterEntity, (Object)niFiProperties), NodeDTO.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)currentNode, null)) {
            String activeUrl = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[128].call(activeUrls), Iterator.class);
            while (iterator.hasNext()) {
                activeUrl = ShortTypeHandling.castToString(iterator.next());
                String url = ShortTypeHandling.castToString((Object)callSiteArray[129].call(callSiteArray[130].call(callSiteArray[131].call((Object)activeUrl, (Object)NODE_ENDPOINT), callSiteArray[132].callGetProperty(File.class)), callSiteArray[133].callGetProperty((Object)currentNode)));
                callSiteArray[134].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)url, (Object)client, (Object)currentNode, (Object)callSiteArray[135].callGetProperty(STATUS.class), (Object)proxyDN));
                try {
                    return;
                }
                catch (Exception ex) {
                    callSiteArray[136].call(callSiteArray[137].callGroovyObjectGetProperty((Object)this), callSiteArray[138].call(callSiteArray[139].call(callSiteArray[140].call((Object)"Could not connect to node on ", (Object)activeUrl), (Object)". Exception: "), callSiteArray[141].call((Object)ex)));
                }
            }
            throw (Throwable)callSiteArray[142].callConstructor(RuntimeException.class, (Object)"Could not successfully complete request");
        }
        throw (Throwable)callSiteArray[143].callConstructor(RuntimeException.class, (Object)"Current node could not be found in the cluster");
    }

    public void connectNode(Client client, NiFiProperties niFiProperties, List<String> activeUrls, String proxyDN) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        ClusterEntity clusterEntity = (ClusterEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[144].call(NiFiClientUtil.class, (Object)client, (Object)niFiProperties, activeUrls, (Object)proxyDN), ClusterEntity.class);
        NodeDTO currentNode = (NodeDTO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callCurrent((GroovyObject)this, (Object)clusterEntity, (Object)niFiProperties), NodeDTO.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)currentNode, null)) {
            String activeUrl = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[146].call(activeUrls), Iterator.class);
            while (iterator.hasNext()) {
                activeUrl = ShortTypeHandling.castToString(iterator.next());
                String url = ShortTypeHandling.castToString((Object)callSiteArray[147].call(callSiteArray[148].call(callSiteArray[149].call((Object)activeUrl, (Object)NODE_ENDPOINT), callSiteArray[150].callGetProperty(File.class)), callSiteArray[151].callGetProperty((Object)currentNode)));
                callSiteArray[152].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)url, (Object)client, (Object)currentNode, (Object)callSiteArray[153].callGetProperty(STATUS.class), (Object)proxyDN));
                try {
                    return;
                }
                catch (Exception ex) {
                    callSiteArray[154].call(callSiteArray[155].callGroovyObjectGetProperty((Object)this), callSiteArray[156].call(callSiteArray[157].call(callSiteArray[158].call((Object)"Could not connect to node on ", (Object)activeUrl), (Object)". Exception: "), callSiteArray[159].call((Object)ex)));
                }
            }
            throw (Throwable)callSiteArray[160].callConstructor(RuntimeException.class, (Object)"Could not successfully complete request");
        }
        throw (Throwable)callSiteArray[161].callConstructor(RuntimeException.class, (Object)"Current node could not be found in the cluster");
    }

    public void removeNode(Client client, NiFiProperties niFiProperties, List<String> activeUrls, String proxyDN) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        ClusterEntity clusterEntity = (ClusterEntity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[162].call(NiFiClientUtil.class, (Object)client, (Object)niFiProperties, activeUrls, (Object)proxyDN), ClusterEntity.class);
        NodeDTO currentNode = (NodeDTO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[163].callCurrent((GroovyObject)this, (Object)clusterEntity, (Object)niFiProperties), NodeDTO.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)currentNode, null)) {
            String activeUrl = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].call(activeUrls), Iterator.class);
            while (iterator.hasNext()) {
                block10: {
                    activeUrl = ShortTypeHandling.castToString(iterator.next());
                    String url = ShortTypeHandling.castToString((Object)callSiteArray[165].call(callSiteArray[166].call(callSiteArray[167].call((Object)activeUrl, (Object)NODE_ENDPOINT), callSiteArray[168].callGetProperty(File.class)), callSiteArray[169].callGetProperty((Object)currentNode)));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[170].callGroovyObjectGetProperty((Object)this))) {
                        callSiteArray[171].call(callSiteArray[172].callGroovyObjectGetProperty((Object)this), callSiteArray[173].call((Object)"Attempting to connect to cluster with url:", (Object)url));
                    }
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[174].callGetProperty((Object)currentNode), (Object)"CONNECTED")) {
                        Object object = callSiteArray[175].callGetProperty(callSiteArray[176].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)url, (Object)client, (Object)currentNode, (Object)callSiteArray[177].callGetProperty(STATUS.class), (Object)proxyDN)));
                        currentNode = (NodeDTO)ScriptBytecodeAdapter.castToType((Object)object, NodeDTO.class);
                    }
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[178].callGetProperty((Object)currentNode), (Object)"DISCONNECTED")) {
                        callSiteArray[179].callCurrent((GroovyObject)this, (Object)url, (Object)client, (Object)proxyDN);
                    }
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[180].callGroovyObjectGetProperty((Object)this))) break block10;
                    callSiteArray[181].call(callSiteArray[182].callGroovyObjectGetProperty((Object)this), (Object)"Node removed from cluster successfully.");
                }
                try {
                    return;
                }
                catch (Exception ex) {
                    callSiteArray[183].call(callSiteArray[184].callGroovyObjectGetProperty((Object)this), callSiteArray[185].call(callSiteArray[186].call(callSiteArray[187].call((Object)"Could not connect to node on ", (Object)activeUrl), (Object)". Exception: "), callSiteArray[188].call((Object)ex)));
                }
            }
            throw (Throwable)callSiteArray[189].callConstructor(RuntimeException.class, (Object)"Could not successfully complete request");
        }
        throw (Throwable)callSiteArray[190].callConstructor(RuntimeException.class, (Object)"Current node could not be found in the cluster");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(ClientFactory clientFactory, String ... args) throws ParseException, UnsupportedOperationException, IllegalArgumentException {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        CommandLine commandLine = (CommandLine)ScriptBytecodeAdapter.castToType((Object)callSiteArray[191].call(callSiteArray[192].callConstructor(DefaultParser.class), callSiteArray[193].callGroovyObjectGetProperty((Object)this), (Object)args), CommandLine.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[194].call((Object)commandLine, (Object)HELP_ARG))) {
            callSiteArray[195].callCurrent((GroovyObject)this, null);
            return;
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[196].call((Object)commandLine, (Object)BOOTSTRAP_CONF)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[197].call((Object)commandLine, (Object)NIFI_INSTALL_DIR)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[198].call((Object)commandLine, (Object)OPERATION))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[199].call((Object)commandLine, (Object)VERBOSE_ARG))) {
                boolean bl = true;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, NodeManagerTool.class, (GroovyObject)this, (String)"isVerbose");
            }
            String bootstrapConfFileName = ShortTypeHandling.castToString((Object)callSiteArray[200].call((Object)commandLine, (Object)BOOTSTRAP_CONF));
            String proxyDN = ShortTypeHandling.castToString((Object)callSiteArray[201].call((Object)commandLine, (Object)PROXY_DN));
            File bootstrapConf = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[202].callConstructor(File.class, (Object)bootstrapConfFileName), File.class);
            Properties bootstrapProperties = (Properties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].call(AdminUtil.class, callSiteArray[204].call(Paths.class, (Object)bootstrapConfFileName)), Properties.class);
            String nifiConfDir = ShortTypeHandling.castToString((Object)callSiteArray[205].call(AdminUtil.class, callSiteArray[206].call((Object)bootstrapProperties, (Object)"conf.dir"), callSiteArray[207].call(callSiteArray[208].call(callSiteArray[209].call(callSiteArray[210].call((Object)bootstrapConf))))));
            String nifiLibDir = ShortTypeHandling.castToString((Object)callSiteArray[211].call(AdminUtil.class, callSiteArray[212].call((Object)bootstrapProperties, (Object)"lib.dir"), callSiteArray[213].call(callSiteArray[214].call(callSiteArray[215].call(callSiteArray[216].call((Object)bootstrapConf))))));
            String nifiPropertiesFileName = ShortTypeHandling.castToString((Object)callSiteArray[217].call(callSiteArray[218].call((Object)nifiConfDir, callSiteArray[219].callGetProperty(File.class)), (Object)"nifi.properties"));
            String key = ShortTypeHandling.castToString((Object)callSiteArray[220].call(NiFiBootstrapUtils.class, (Object)bootstrapConfFileName));
            NiFiProperties niFiProperties = (NiFiProperties)ScriptBytecodeAdapter.castToType((Object)callSiteArray[221].call(callSiteArray[222].call(NiFiPropertiesLoader.class, (Object)key), (Object)nifiPropertiesFileName), NiFiProperties.class);
            String operation = ShortTypeHandling.castToString((Object)callSiteArray[223].call((Object)commandLine, (Object)OPERATION));
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[224].call(StringUtils.class, callSiteArray[225].call((Object)niFiProperties, callSiteArray[226].callGetProperty(NiFiProperties.class)))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[227].call(StringUtils.class, (Object)proxyDN)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[228].call((Object)operation, (Object)NODE_STATUS))) {
                    throw (Throwable)callSiteArray[229].callConstructor(UnsupportedOperationException.class, (Object)"Proxy DN is required for sending a notification to this node or cluster");
                }
            } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[230].call(StringUtils.class, callSiteArray[231].call((Object)niFiProperties, callSiteArray[232].callGetProperty(NiFiProperties.class)))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[233].call(StringUtils.class, (Object)proxyDN)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[234].call((Object)operation, (Object)NODE_STATUS))) {
                throw (Throwable)callSiteArray[235].callConstructor(UnsupportedOperationException.class, (Object)"Proxy DN is required for sending a notification to this node or cluster");
            }
            String nifiInstallDir = ShortTypeHandling.castToString((Object)callSiteArray[236].call((Object)commandLine, (Object)NIFI_INSTALL_DIR));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[237].call(AdminUtil.class, (Object)nifiConfDir, (Object)nifiLibDir, (Object)SUPPORTED_MINIMUM_VERSION))) throw (Throwable)callSiteArray[266].callConstructor(UnsupportedOperationException.class, (Object)"Node Manager Tool only supports instances of NiFi running versions 1.0.0 or higher.");
            Client client = (Client)ScriptBytecodeAdapter.castToType((Object)callSiteArray[238].call((Object)clientFactory, (Object)niFiProperties, (Object)nifiInstallDir), Client.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[239].callGroovyObjectGetProperty((Object)this))) {
                callSiteArray[240].call(callSiteArray[241].callGroovyObjectGetProperty((Object)this), (Object)"Starting {} request", (Object)operation);
            }
            List activeUrls = null;
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[242].call((Object)commandLine, (Object)CLUSTER_URLS))) {
                String urlList = ShortTypeHandling.castToString((Object)callSiteArray[243].call((Object)commandLine, (Object)CLUSTER_URLS));
                Object object = callSiteArray[244].call((Object)urlList, (Object)",");
                activeUrls = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[245].call((Object)operation, (Object)NODE_STATUS))) {
                callSiteArray[246].callCurrent((GroovyObject)this, (Object)client, (Object)niFiProperties, activeUrls);
                return;
            } else {
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[247].call(NiFiClientUtil.class, (Object)niFiProperties))) throw (Throwable)callSiteArray[263].callConstructor(UnsupportedOperationException.class, callSiteArray[264].call(callSiteArray[265].call((Object)"The provided operation (", (Object)operation), (Object)") is only supported with instances of NiFi running within a cluster."));
                if (ScriptBytecodeAdapter.compareEqual(activeUrls, null)) {
                    Object object = callSiteArray[248].call(NiFiClientUtil.class, (Object)client, (Object)niFiProperties, (Object)proxyDN);
                    activeUrls = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[249].callGroovyObjectGetProperty((Object)this))) {
                    callSiteArray[250].call(callSiteArray[251].callGroovyObjectGetProperty((Object)this), (Object)"Using active urls {} for communication.", (Object)activeUrls);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[252].call(callSiteArray[253].call((Object)operation), (Object)REMOVE))) {
                    callSiteArray[254].callCurrent((GroovyObject)this, (Object)client, (Object)niFiProperties, (Object)activeUrls, (Object)proxyDN);
                    return;
                } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[255].call(callSiteArray[256].call((Object)operation), (Object)DISCONNECT))) {
                    callSiteArray[257].callCurrent((GroovyObject)this, (Object)client, (Object)niFiProperties, (Object)activeUrls, (Object)proxyDN);
                    return;
                } else {
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[258].call(callSiteArray[259].call((Object)operation), (Object)CONNECT))) throw (Throwable)callSiteArray[261].callConstructor(ParseException.class, callSiteArray[262].call((Object)"Invalid operation provided: ", (Object)operation));
                    callSiteArray[260].callCurrent((GroovyObject)this, (Object)client, (Object)niFiProperties, (Object)activeUrls, (Object)proxyDN);
                }
            }
            return;
        } else {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[267].call((Object)commandLine, (Object)BOOTSTRAP_CONF))) {
                throw (Throwable)callSiteArray[268].callConstructor(ParseException.class, (Object)"Missing -b option");
            }
            if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[269].call((Object)commandLine, (Object)NIFI_INSTALL_DIR)))) throw (Throwable)callSiteArray[271].callConstructor(ParseException.class, (Object)"Missing -o option");
            throw (Throwable)callSiteArray[270].callConstructor(ParseException.class, (Object)"Missing -d option");
        }
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        NodeManagerTool tool = (NodeManagerTool)ScriptBytecodeAdapter.castToType((Object)callSiteArray[272].callConstructor(NodeManagerTool.class), NodeManagerTool.class);
        ClientFactory clientFactory = (ClientFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[273].callConstructor(NiFiClientFactory.class), ClientFactory.class);
        try {
            callSiteArray[274].call((Object)tool, (Object)clientFactory, (Object)args);
        }
        catch (Exception e) {
            callSiteArray[275].call((Object)tool, callSiteArray[276].call((Object)e));
            callSiteArray[277].call(System.class, (Object)1);
        }
        callSiteArray[278].call(System.class, (Object)0);
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NodeManagerTool.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, NodeManagerTool.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = NodeManagerTool.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(NodeManagerTool.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NodeManagerTool.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "buildHeader";
        stringArray[1] = "setup";
        stringArray[2] = "buildHeader";
        stringArray[3] = "setup";
        stringArray[4] = "getLogger";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "addOption";
        stringArray[7] = "build";
        stringArray[8] = "desc";
        stringArray[9] = "longOpt";
        stringArray[10] = "builder";
        stringArray[11] = "addOption";
        stringArray[12] = "build";
        stringArray[13] = "desc";
        stringArray[14] = "longOpt";
        stringArray[15] = "builder";
        stringArray[16] = "addOption";
        stringArray[17] = "build";
        stringArray[18] = "desc";
        stringArray[19] = "hasArg";
        stringArray[20] = "longOpt";
        stringArray[21] = "builder";
        stringArray[22] = "addOption";
        stringArray[23] = "build";
        stringArray[24] = "desc";
        stringArray[25] = "hasArg";
        stringArray[26] = "longOpt";
        stringArray[27] = "builder";
        stringArray[28] = "addOption";
        stringArray[29] = "build";
        stringArray[30] = "desc";
        stringArray[31] = "hasArg";
        stringArray[32] = "longOpt";
        stringArray[33] = "builder";
        stringArray[34] = "addOption";
        stringArray[35] = "build";
        stringArray[36] = "desc";
        stringArray[37] = "hasArg";
        stringArray[38] = "longOpt";
        stringArray[39] = "builder";
        stringArray[40] = "addOption";
        stringArray[41] = "build";
        stringArray[42] = "desc";
        stringArray[43] = "hasArg";
        stringArray[44] = "longOpt";
        stringArray[45] = "builder";
        stringArray[46] = "nodes";
        stringArray[47] = "cluster";
        stringArray[48] = "isEmpty";
        stringArray[49] = "getProperty";
        stringArray[50] = "CLUSTER_NODE_ADDRESS";
        stringArray[51] = "getProperty";
        stringArray[52] = "CLUSTER_NODE_ADDRESS";
        stringArray[53] = "find";
        stringArray[54] = "target";
        stringArray[55] = "convertToJson";
        stringArray[56] = "isVerbose";
        stringArray[57] = "info";
        stringArray[58] = "logger";
        stringArray[59] = "plus";
        stringArray[60] = "startsWith";
        stringArray[61] = "put";
        stringArray[62] = "header";
        stringArray[63] = "request";
        stringArray[64] = "PROXY_ENTITIES_CHAIN";
        stringArray[65] = "formatProxyDn";
        stringArray[66] = "json";
        stringArray[67] = "put";
        stringArray[68] = "request";
        stringArray[69] = "json";
        stringArray[70] = NODE_STATUS;
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "plus";
        stringArray[73] = "plus";
        stringArray[74] = "plus";
        stringArray[75] = NODE_STATUS;
        stringArray[76] = "readEntity";
        stringArray[77] = "readEntity";
        stringArray[78] = "target";
        stringArray[79] = "isVerbose";
        stringArray[80] = "info";
        stringArray[81] = "logger";
        stringArray[82] = "startsWith";
        stringArray[83] = "delete";
        stringArray[84] = "header";
        stringArray[85] = "request";
        stringArray[86] = "PROXY_ENTITIES_CHAIN";
        stringArray[87] = "formatProxyDn";
        stringArray[88] = "delete";
        stringArray[89] = "request";
        stringArray[90] = NODE_STATUS;
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "plus";
        stringArray[93] = "plus";
        stringArray[94] = "plus";
        stringArray[95] = NODE_STATUS;
        stringArray[96] = "readEntity";
        stringArray[97] = "empty";
        stringArray[98] = "getUrl";
        stringArray[99] = "iterator";
        stringArray[100] = "plus";
        stringArray[101] = "target";
        stringArray[102] = "isVerbose";
        stringArray[103] = "info";
        stringArray[104] = "logger";
        stringArray[105] = "get";
        stringArray[106] = "request";
        stringArray[107] = NODE_STATUS;
        stringArray[108] = "println";
        stringArray[109] = "out";
        stringArray[110] = "plus";
        stringArray[111] = "println";
        stringArray[112] = "out";
        stringArray[113] = "plus";
        stringArray[114] = "plus";
        stringArray[115] = "plus";
        stringArray[116] = "plus";
        stringArray[117] = "plus";
        stringArray[118] = NODE_STATUS;
        stringArray[119] = "readEntity";
        stringArray[120] = "println";
        stringArray[121] = "out";
        stringArray[122] = "plus";
        stringArray[123] = "plus";
        stringArray[124] = "plus";
        stringArray[125] = "localizedMessage";
        stringArray[126] = "getCluster";
        stringArray[127] = "getCurrentNode";
        stringArray[128] = "iterator";
        stringArray[129] = "plus";
        stringArray[130] = "plus";
        stringArray[131] = "plus";
        stringArray[132] = "separator";
        stringArray[133] = "nodeId";
        stringArray[134] = "updateNode";
        stringArray[135] = "DISCONNECTING";
        stringArray[136] = "warn";
        stringArray[137] = "logger";
        stringArray[138] = "plus";
        stringArray[139] = "plus";
        stringArray[140] = "plus";
        stringArray[141] = "toString";
        stringArray[142] = "<$constructor$>";
        stringArray[143] = "<$constructor$>";
        stringArray[144] = "getCluster";
        stringArray[145] = "getCurrentNode";
        stringArray[146] = "iterator";
        stringArray[147] = "plus";
        stringArray[148] = "plus";
        stringArray[149] = "plus";
        stringArray[150] = "separator";
        stringArray[151] = "nodeId";
        stringArray[152] = "updateNode";
        stringArray[153] = "CONNECTING";
        stringArray[154] = "warn";
        stringArray[155] = "logger";
        stringArray[156] = "plus";
        stringArray[157] = "plus";
        stringArray[158] = "plus";
        stringArray[159] = "toString";
        stringArray[160] = "<$constructor$>";
        stringArray[161] = "<$constructor$>";
        stringArray[162] = "getCluster";
        stringArray[163] = "getCurrentNode";
        stringArray[164] = "iterator";
        stringArray[165] = "plus";
        stringArray[166] = "plus";
        stringArray[167] = "plus";
        stringArray[168] = "separator";
        stringArray[169] = "nodeId";
        stringArray[170] = "isVerbose";
        stringArray[171] = "info";
        stringArray[172] = "logger";
        stringArray[173] = "plus";
        stringArray[174] = NODE_STATUS;
        stringArray[175] = "node";
        stringArray[176] = "updateNode";
        stringArray[177] = "DISCONNECTING";
        stringArray[178] = NODE_STATUS;
        stringArray[179] = "deleteNode";
        stringArray[180] = "isVerbose";
        stringArray[181] = "info";
        stringArray[182] = "logger";
        stringArray[183] = "warn";
        stringArray[184] = "logger";
        stringArray[185] = "plus";
        stringArray[186] = "plus";
        stringArray[187] = "plus";
        stringArray[188] = "toString";
        stringArray[189] = "<$constructor$>";
        stringArray[190] = "<$constructor$>";
        stringArray[191] = "parse";
        stringArray[192] = "<$constructor$>";
        stringArray[193] = "options";
        stringArray[194] = "hasOption";
        stringArray[195] = "printUsage";
        stringArray[196] = "hasOption";
        stringArray[197] = "hasOption";
        stringArray[198] = "hasOption";
        stringArray[199] = "hasOption";
        stringArray[200] = "getOptionValue";
        stringArray[201] = "getOptionValue";
        stringArray[202] = "<$constructor$>";
        stringArray[203] = "getBootstrapConf";
        stringArray[204] = "get";
        stringArray[205] = "getRelativeDirectory";
        stringArray[206] = "getProperty";
        stringArray[207] = "getCanonicalPath";
        stringArray[208] = "getParentFile";
        stringArray[209] = "getParentFile";
        stringArray[210] = "getCanonicalFile";
        stringArray[211] = "getRelativeDirectory";
        stringArray[212] = "getProperty";
        stringArray[213] = "getCanonicalPath";
        stringArray[214] = "getParentFile";
        stringArray[215] = "getParentFile";
        stringArray[216] = "getCanonicalFile";
        stringArray[217] = "plus";
        stringArray[218] = "plus";
        stringArray[219] = "separator";
        stringArray[220] = "extractKeyFromBootstrapFile";
        stringArray[221] = "load";
        stringArray[222] = "withKey";
        stringArray[223] = "getOptionValue";
        stringArray[224] = "isEmpty";
        stringArray[225] = "getProperty";
        stringArray[226] = "WEB_HTTPS_PORT";
        stringArray[227] = "isEmpty";
        stringArray[228] = "equalsIgnoreCase";
        stringArray[229] = "<$constructor$>";
        stringArray[230] = "isEmpty";
        stringArray[231] = "getProperty";
        stringArray[232] = "WEB_HTTPS_PORT";
        stringArray[233] = "isEmpty";
        stringArray[234] = "equalsIgnoreCase";
        stringArray[235] = "<$constructor$>";
        stringArray[236] = "getOptionValue";
        stringArray[237] = "supportedNiFiMinimumVersion";
        stringArray[238] = "getClient";
        stringArray[239] = "isVerbose";
        stringArray[240] = "info";
        stringArray[241] = "logger";
        stringArray[242] = "hasOption";
        stringArray[243] = "getOptionValue";
        stringArray[244] = "tokenize";
        stringArray[245] = "equalsIgnoreCase";
        stringArray[246] = "getStatus";
        stringArray[247] = "isCluster";
        stringArray[248] = "getActiveClusterUrls";
        stringArray[249] = "isVerbose";
        stringArray[250] = "info";
        stringArray[251] = "logger";
        stringArray[252] = "equals";
        stringArray[253] = "toLowerCase";
        stringArray[254] = "removeNode";
        stringArray[255] = "equals";
        stringArray[256] = "toLowerCase";
        stringArray[257] = "disconnectNode";
        stringArray[258] = "equals";
        stringArray[259] = "toLowerCase";
        stringArray[260] = "connectNode";
        stringArray[261] = "<$constructor$>";
        stringArray[262] = "plus";
        stringArray[263] = "<$constructor$>";
        stringArray[264] = "plus";
        stringArray[265] = "plus";
        stringArray[266] = "<$constructor$>";
        stringArray[267] = "hasOption";
        stringArray[268] = "<$constructor$>";
        stringArray[269] = "hasOption";
        stringArray[270] = "<$constructor$>";
        stringArray[271] = "<$constructor$>";
        stringArray[272] = "<$constructor$>";
        stringArray[273] = "<$constructor$>";
        stringArray[274] = "parse";
        stringArray[275] = "printUsage";
        stringArray[276] = "getLocalizedMessage";
        stringArray[277] = "exit";
        stringArray[278] = "exit";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[279];
        NodeManagerTool.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(NodeManagerTool.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = NodeManagerTool.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static final class STATUS
    extends Enum<STATUS>
    implements GroovyObject {
        public static final /* enum */ STATUS DISCONNECTING;
        public static final /* enum */ STATUS CONNECTING;
        public static final /* enum */ STATUS CONNECTED;
        public static final STATUS MIN_VALUE;
        public static final STATUS MAX_VALUE;
        private static final /* synthetic */ STATUS[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        private STATUS(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            CallSite[] callSiteArray = STATUS.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (ScriptBytecodeAdapter.compareEqual((Object)__namedArgs, null)) {
                throw (Throwable)callSiteArray[0].callConstructor(IllegalArgumentException.class, (Object)"One of the enum constants for enum org.apache.nifi.toolkit.admin.nodemanager.NodeManagerTool$STATUS was initialized with null. Please use a non-null value or define your own constructor.");
            }
            callSiteArray[1].callStatic(ImmutableASTTransformation.class, (Object)this, (Object)__namedArgs);
        }

        @Generated
        private STATUS() {
            CallSite[] callSiteArray = STATUS.$getCallSiteArray();
            this((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(LinkedHashMap.class), LinkedHashMap.class));
        }

        @Generated
        public static final STATUS[] values() {
            CallSite[] callSiteArray = STATUS.$getCallSiteArray();
            return (STATUS[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), STATUS[].class);
        }

        @Generated
        public STATUS next() {
            CallSite[] callSiteArray = STATUS.$getCallSiteArray();
            Object ordinal = callSiteArray[3].call(callSiteArray[4].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)callSiteArray[5].call((Object)$VALUES))) {
                Integer n = 0;
                ordinal = n;
            }
            return (STATUS)ShortTypeHandling.castToEnum((Object)callSiteArray[6].call((Object)$VALUES, ordinal), STATUS.class);
        }

        @Generated
        public STATUS previous() {
            CallSite[] callSiteArray = STATUS.$getCallSiteArray();
            Object ordinal = callSiteArray[7].call(callSiteArray[8].callCurrent((GroovyObject)this));
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Object object;
                ordinal = object = callSiteArray[9].call(callSiteArray[10].call((Object)$VALUES), (Object)1);
            }
            return (STATUS)ShortTypeHandling.castToEnum((Object)callSiteArray[11].call((Object)$VALUES, ordinal), STATUS.class);
        }

        @Generated
        public static STATUS valueOf(String name) {
            CallSite[] callSiteArray = STATUS.$getCallSiteArray();
            return (STATUS)ShortTypeHandling.castToEnum((Object)callSiteArray[12].callStatic(STATUS.class, STATUS.class, (Object)name), STATUS.class);
        }

        @Generated
        public static final /* synthetic */ STATUS $INIT(Object ... para) {
            STATUS sTATUS;
            CallSite[] callSiteArray = STATUS.$getCallSiteArray();
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, STATUS.class)) {
                case -1348271900: {
                    STATUS sTATUS2;
                    sTATUS = sTATUS2;
                    Object[] objectArray2 = objectArray;
                    sTATUS2 = new STATUS();
                    break;
                }
                case -242181752: {
                    STATUS sTATUS2;
                    sTATUS = sTATUS2;
                    Object[] objectArray2 = objectArray;
                    sTATUS2 = new STATUS((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return sTATUS;
        }

        static {
            STATUS sTATUS;
            STATUS sTATUS2;
            Object object = STATUS.$getCallSiteArray()[13].callStatic(STATUS.class, (Object)"DISCONNECTING", (Object)0);
            DISCONNECTING = (STATUS)ShortTypeHandling.castToEnum((Object)object, STATUS.class);
            Object object2 = STATUS.$getCallSiteArray()[14].callStatic(STATUS.class, (Object)"CONNECTING", (Object)1);
            CONNECTING = (STATUS)ShortTypeHandling.castToEnum((Object)object2, STATUS.class);
            Object object3 = STATUS.$getCallSiteArray()[15].callStatic(STATUS.class, (Object)"CONNECTED", (Object)2);
            CONNECTED = (STATUS)ShortTypeHandling.castToEnum((Object)object3, STATUS.class);
            MIN_VALUE = sTATUS2 = DISCONNECTING;
            MAX_VALUE = sTATUS = CONNECTED;
            STATUS[] sTATUSArray = new STATUS[]{DISCONNECTING, CONNECTING, CONNECTED};
            $VALUES = sTATUSArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != STATUS.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "checkPropNames";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "next";
            stringArray[4] = "ordinal";
            stringArray[5] = "size";
            stringArray[6] = "getAt";
            stringArray[7] = "previous";
            stringArray[8] = "ordinal";
            stringArray[9] = "minus";
            stringArray[10] = "size";
            stringArray[11] = "getAt";
            stringArray[12] = "valueOf";
            stringArray[13] = "$INIT";
            stringArray[14] = "$INIT";
            stringArray[15] = "$INIT";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[16];
            STATUS.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(STATUS.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = STATUS.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

