/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.authentication;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.kerberos.authentication.KerberosClient;

public class KerberosAuthenticationProvider
implements AuthenticationProvider {
    private KerberosClient kerberosClient;
    private UserDetailsService userDetailsService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UsernamePasswordAuthenticationToken auth = (UsernamePasswordAuthenticationToken)authentication;
        String validatedUsername = this.kerberosClient.login(auth.getName(), auth.getCredentials().toString());
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(validatedUsername);
        UsernamePasswordAuthenticationToken output = new UsernamePasswordAuthenticationToken((Object)userDetails, auth.getCredentials(), userDetails.getAuthorities());
        output.setDetails(authentication.getDetails());
        return output;
    }

    public boolean supports(Class<? extends Object> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setKerberosClient(KerberosClient kerberosClient) {
        this.kerberosClient = kerberosClient;
    }

    public void setUserDetailsService(UserDetailsService detailsService) {
        this.userDetailsService = detailsService;
    }
}

