/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Objects;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.diagnostics.DiagnosticsDump;
import org.apache.nifi.diagnostics.DiagnosticsFactory;
import org.apache.nifi.runtime.util.HttpExchangeUtils;

class HealthDiagnosticsHttpHandler
implements HttpHandler {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String TEXT_PLAIN = "text/plain";
    private static final int STREAM_RESPONSE_BODY = 0;
    private static final int NO_RESPONSE_BODY = -1;
    private static final String GET_METHOD = "GET";
    private static final String VERBOSE_QUERY_ENABLED = "verbose=true";
    private final NiFiServer server;

    HealthDiagnosticsHttpHandler(NiFiServer server) {
        this.server = Objects.requireNonNull(server);
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        HttpExchangeUtils.drainRequestBody(exchange);
        String requestMethod = exchange.getRequestMethod();
        try (OutputStream responseBody = exchange.getResponseBody();){
            if (GET_METHOD.contentEquals(requestMethod)) {
                exchange.getResponseHeaders().set(CONTENT_TYPE_HEADER, TEXT_PLAIN);
                exchange.sendResponseHeaders(200, 0L);
                URI requestUri = exchange.getRequestURI();
                boolean verboseRequested = this.getVerboseRequested(requestUri);
                DiagnosticsFactory diagnosticsFactory = this.server.getDiagnosticsFactory();
                DiagnosticsDump diagnosticsDump = diagnosticsFactory.create(verboseRequested);
                diagnosticsDump.writeTo(responseBody);
            } else {
                exchange.sendResponseHeaders(405, -1L);
            }
        }
    }

    private boolean getVerboseRequested(URI requestUri) {
        String query = requestUri.getQuery();
        boolean verboseRequested = query == null ? false : query.contains(VERBOSE_QUERY_ENABLED);
        return verboseRequested;
    }
}

