/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.provenance;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import java.util.Map;
import org.apache.nifi.web.api.dto.provenance.ProvenanceSearchValueDTO;
import org.apache.nifi.web.api.dto.util.DateTimeAdapter;

@XmlType(name="provenanceRequest")
public class ProvenanceRequestDTO {
    private Map<String, ProvenanceSearchValueDTO> searchTerms;
    private String clusterNodeId;
    private Date startDate;
    private Date endDate;
    private String minimumFileSize;
    private String maximumFileSize;
    private Integer maxResults;
    private Boolean summarize;
    private Boolean incrementalResults;

    @Schema(description="The search terms used to perform the search.")
    public Map<String, ProvenanceSearchValueDTO> getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(Map<String, ProvenanceSearchValueDTO> searchTerms) {
        this.searchTerms = searchTerms;
    }

    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @Schema(description="The earliest event time to include in the query.", type="string")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @Schema(description="The latest event time to include in the query.", type="string")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Schema(description="The minimum file size to include in the query.")
    public String getMinimumFileSize() {
        return this.minimumFileSize;
    }

    public void setMinimumFileSize(String minimumFileSize) {
        this.minimumFileSize = minimumFileSize;
    }

    @Schema(description="The maximum file size to include in the query.")
    public String getMaximumFileSize() {
        return this.maximumFileSize;
    }

    public void setMaximumFileSize(String maximumFileSize) {
        this.maximumFileSize = maximumFileSize;
    }

    @Schema(description="The maximum number of results to include.")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    @Schema(description="The id of the node in the cluster where this provenance originated.")
    public String getClusterNodeId() {
        return this.clusterNodeId;
    }

    public void setClusterNodeId(String clusterNodeId) {
        this.clusterNodeId = clusterNodeId;
    }

    @Schema(description="Whether or not incremental results are returned. If false, provenance events are only returned once the query completes. This property is true by default.")
    public Boolean getIncrementalResults() {
        return this.incrementalResults;
    }

    public void setIncrementalResults(Boolean incrementalResults) {
        this.incrementalResults = incrementalResults;
    }

    @Schema(description="Whether or not to summarize provenance events returned. This property is false by default.")
    public Boolean getSummarize() {
        return this.summarize;
    }

    public void setSummarize(Boolean summarize) {
        this.summarize = summarize;
    }
}

