/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl.request;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.util.ProxiedEntitiesUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;

public class ProxiedEntityRequestConfig
implements RequestConfig {
    private final String[] proxiedEntities;

    public ProxiedEntityRequestConfig(String ... proxiedEntities) {
        this.proxiedEntities = Objects.requireNonNull(proxiedEntities);
    }

    @Override
    public Map<String, String> getHeaders() {
        String proxiedEntitiesValue = this.getProxiedEntitesValue(this.proxiedEntities);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (proxiedEntitiesValue != null) {
            headers.put("X-ProxiedEntitiesChain", proxiedEntitiesValue);
        }
        return headers;
    }

    private String getProxiedEntitesValue(String[] proxiedEntities) {
        if (proxiedEntities == null) {
            return null;
        }
        List proxiedEntityChain = Arrays.stream(proxiedEntities).map(ProxiedEntitiesUtils::formatProxyDn).collect(Collectors.toList());
        return StringUtils.join(proxiedEntityChain, (String)"");
    }
}

