/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.command.nifi.pg.cs.ControllerServiceStateCounts;
import org.apache.nifi.toolkit.cli.impl.command.nifi.pg.cs.ControllerServiceUtil;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.entity.ActivateControllerServicesEntity;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;

public class PGDisableControllerServices
extends AbstractNiFiCommand<VoidResult> {
    public static final int MAX_DISABLING_ITERATIONS = 20;
    public static final long DELAY_MS = 2000L;

    public PGDisableControllerServices() {
        super("pg-disable-services", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Disables the controller services in the given process group. Any services that are in use by a running component will fail to be disabled and will need to be stopped first using pg-stop.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String pgId;
        FlowClient flowClient = client.getFlowClient();
        ControllerServiceStateCounts initialServiceStates = this.getControllerServiceStates(flowClient, pgId = this.getRequiredArg(properties, CommandOption.PG_ID));
        if (initialServiceStates.getEnabled() == 0 && initialServiceStates.getEnabling() == 0) {
            if (this.shouldPrint(properties)) {
                this.println();
                this.println("No services are currently enabled/enabling, nothing to do...");
                this.println();
            }
            return VoidResult.getInstance();
        }
        if (this.shouldPrint(properties)) {
            this.println();
            this.println("Starting states:");
            this.printControllerServiceStates(initialServiceStates);
            this.println();
            this.println("Attempting to disable services...");
        }
        ActivateControllerServicesEntity disableEntity = new ActivateControllerServicesEntity();
        disableEntity.setId(pgId);
        disableEntity.setState("DISABLED");
        flowClient.activateControllerServices(disableEntity);
        this.sleep(1000L);
        ControllerServiceStateCounts serviceStates = this.getControllerServiceStates(flowClient, pgId);
        for (int disablingWaitCount = 1; serviceStates.getDisabling() > 0 && disablingWaitCount < 20; ++disablingWaitCount) {
            if (this.shouldPrint(properties)) {
                this.println("Currently " + serviceStates.getDisabling() + " services are disabling, waiting to finish before proceeding (" + disablingWaitCount + " of 20)...");
            }
            this.sleep(2000L);
            serviceStates = this.getControllerServiceStates(flowClient, pgId);
        }
        if (serviceStates.getDisabling() > 0) {
            if (this.shouldPrint(properties)) {
                this.printServicesStillDisabling(flowClient, pgId);
            }
            throw new CommandException("One or more services may be stuck disabling, run command with -verbose to obtain more details");
        }
        if (this.shouldPrint(properties)) {
            this.println();
            this.println("Finished States:");
            this.printControllerServiceStates(serviceStates);
            this.println();
        }
        return VoidResult.getInstance();
    }

    private void printControllerServiceStates(ControllerServiceStateCounts serviceStates) {
        this.println(" - " + serviceStates.getEnabled() + " enabled");
        this.println(" - " + serviceStates.getEnabling() + " enabling");
        this.println(" - " + serviceStates.getDisabled() + " disabled");
        this.println(" - " + serviceStates.getDisabling() + " disabling");
    }

    private void printServicesStillDisabling(FlowClient flowClient, String pgId) throws NiFiClientException, IOException {
        ControllerServicesEntity servicesEntity = flowClient.getControllerServices(pgId);
        if (servicesEntity == null || servicesEntity.getControllerServices() == null) {
            return;
        }
        this.println();
        this.println("One or more services appear to be stuck disabling: ");
        for (ControllerServiceEntity serviceEntity : servicesEntity.getControllerServices()) {
            if (!"DISABLING".equals(serviceEntity.getComponent().getState())) continue;
            this.println();
            this.println("Service: " + serviceEntity.getId() + " - " + serviceEntity.getComponent().getName());
            if (serviceEntity.getBulletins() == null) continue;
            this.println();
            this.println("Reasons: ");
            for (BulletinEntity bulletinEntity : serviceEntity.getBulletins()) {
                this.println("- " + bulletinEntity.getBulletin().getMessage());
            }
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private boolean shouldPrint(Properties properties) {
        return this.isInteractive() || this.isVerbose(properties);
    }

    private ControllerServiceStateCounts getControllerServiceStates(FlowClient flowClient, String pgId) throws NiFiClientException, IOException {
        return ControllerServiceUtil.getControllerServiceStates(flowClient, pgId);
    }
}

