/****************************************************************************
 * arch/arm64/src/imx9/hardware/imx95/imx95_iomuxc.h
 *
 * SPDX-License-Identifier: Apache-2.0
 * SPDX-FileCopyrightText: 2024 NXP
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM64_IMX9_IMX95_IOMUXC_H
#define __ARCH_ARM64_IMX9_IMX95_IOMUXC_H

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define IOMUXC_MUX_CTL_DAP_TDI_OFFSET          (0x0000)
#define IOMUXC_MUX_CTL_DAP_TMS_SWDIO_OFFSET    (0x0004)
#define IOMUXC_MUX_CTL_DAP_TCLK_SWCLK_OFFSET   (0x0008)
#define IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET (0x000c)
#define IOMUXC_MUX_CTL_GPIO_IO00_OFFSET        (0x0010)
#define IOMUXC_MUX_CTL_GPIO_IO01_OFFSET        (0x0014)
#define IOMUXC_MUX_CTL_GPIO_IO02_OFFSET        (0x0018)
#define IOMUXC_MUX_CTL_GPIO_IO03_OFFSET        (0x001c)
#define IOMUXC_MUX_CTL_GPIO_IO04_OFFSET        (0x0020)
#define IOMUXC_MUX_CTL_GPIO_IO05_OFFSET        (0x0024)
#define IOMUXC_MUX_CTL_GPIO_IO06_OFFSET        (0x0028)
#define IOMUXC_MUX_CTL_GPIO_IO07_OFFSET        (0x002c)
#define IOMUXC_MUX_CTL_GPIO_IO08_OFFSET        (0x0030)
#define IOMUXC_MUX_CTL_GPIO_IO09_OFFSET        (0x0034)
#define IOMUXC_MUX_CTL_GPIO_IO10_OFFSET        (0x0038)
#define IOMUXC_MUX_CTL_GPIO_IO11_OFFSET        (0x003c)
#define IOMUXC_MUX_CTL_GPIO_IO12_OFFSET        (0x0040)
#define IOMUXC_MUX_CTL_GPIO_IO13_OFFSET        (0x0044)
#define IOMUXC_MUX_CTL_GPIO_IO14_OFFSET        (0x0048)
#define IOMUXC_MUX_CTL_GPIO_IO15_OFFSET        (0x004c)
#define IOMUXC_MUX_CTL_GPIO_IO16_OFFSET        (0x0050)
#define IOMUXC_MUX_CTL_GPIO_IO17_OFFSET        (0x0054)
#define IOMUXC_MUX_CTL_GPIO_IO18_OFFSET        (0x0058)
#define IOMUXC_MUX_CTL_GPIO_IO19_OFFSET        (0x005c)
#define IOMUXC_MUX_CTL_GPIO_IO20_OFFSET        (0x0060)
#define IOMUXC_MUX_CTL_GPIO_IO21_OFFSET        (0x0064)
#define IOMUXC_MUX_CTL_GPIO_IO22_OFFSET        (0x0068)
#define IOMUXC_MUX_CTL_GPIO_IO23_OFFSET        (0x006c)
#define IOMUXC_MUX_CTL_GPIO_IO24_OFFSET        (0x0070)
#define IOMUXC_MUX_CTL_GPIO_IO25_OFFSET        (0x0074)
#define IOMUXC_MUX_CTL_GPIO_IO26_OFFSET        (0x0078)
#define IOMUXC_MUX_CTL_GPIO_IO27_OFFSET        (0x007c)
#define IOMUXC_MUX_CTL_GPIO_IO28_OFFSET        (0x0080)
#define IOMUXC_MUX_CTL_GPIO_IO29_OFFSET        (0x0084)
#define IOMUXC_MUX_CTL_GPIO_IO30_OFFSET        (0x0088)
#define IOMUXC_MUX_CTL_GPIO_IO31_OFFSET        (0x008c)
#define IOMUXC_MUX_CTL_GPIO_IO32_OFFSET        (0x0090)
#define IOMUXC_MUX_CTL_GPIO_IO33_OFFSET        (0x0094)
#define IOMUXC_MUX_CTL_GPIO_IO34_OFFSET        (0x0098)
#define IOMUXC_MUX_CTL_GPIO_IO35_OFFSET        (0x009c)
#define IOMUXC_MUX_CTL_GPIO_IO36_OFFSET        (0x00a0)
#define IOMUXC_MUX_CTL_GPIO_IO37_OFFSET        (0x00a4)
#define IOMUXC_MUX_CTL_CCM_CLKO1_OFFSET        (0x00a8)
#define IOMUXC_MUX_CTL_CCM_CLKO2_OFFSET        (0x00ac)
#define IOMUXC_MUX_CTL_CCM_CLKO3_OFFSET        (0x00b0)
#define IOMUXC_MUX_CTL_CCM_CLKO4_OFFSET        (0x00b4)
#define IOMUXC_MUX_CTL_ENET1_MDC_OFFSET        (0x00b8)
#define IOMUXC_MUX_CTL_ENET1_MDIO_OFFSET       (0x00bc)
#define IOMUXC_MUX_CTL_ENET1_TD3_OFFSET        (0x00c0)
#define IOMUXC_MUX_CTL_ENET1_TD2_OFFSET        (0x00c4)
#define IOMUXC_MUX_CTL_ENET1_TD1_OFFSET        (0x00c8)
#define IOMUXC_MUX_CTL_ENET1_TD0_OFFSET        (0x00cc)
#define IOMUXC_MUX_CTL_ENET1_TX_CTL_OFFSET     (0x00d0)
#define IOMUXC_MUX_CTL_ENET1_TXC_OFFSET        (0x00d4)
#define IOMUXC_MUX_CTL_ENET1_RX_CTL_OFFSET     (0x00d8)
#define IOMUXC_MUX_CTL_ENET1_RXC_OFFSET        (0x00dc)
#define IOMUXC_MUX_CTL_ENET1_RD0_OFFSET        (0x00e0)
#define IOMUXC_MUX_CTL_ENET1_RD1_OFFSET        (0x00e4)
#define IOMUXC_MUX_CTL_ENET1_RD2_OFFSET        (0x00e8)
#define IOMUXC_MUX_CTL_ENET1_RD3_OFFSET        (0x00ec)
#define IOMUXC_MUX_CTL_ENET2_MDC_OFFSET        (0x00f0)
#define IOMUXC_MUX_CTL_ENET2_MDIO_OFFSET       (0x00f4)
#define IOMUXC_MUX_CTL_ENET2_TD3_OFFSET        (0x00f8)
#define IOMUXC_MUX_CTL_ENET2_TD2_OFFSET        (0x00fc)
#define IOMUXC_MUX_CTL_ENET2_TD1_OFFSET        (0x0100)
#define IOMUXC_MUX_CTL_ENET2_TD0_OFFSET        (0x0104)
#define IOMUXC_MUX_CTL_ENET2_TX_CTL_OFFSET     (0x0108)
#define IOMUXC_MUX_CTL_ENET2_TXC_OFFSET        (0x010c)
#define IOMUXC_MUX_CTL_ENET2_RX_CTL_OFFSET     (0x0110)
#define IOMUXC_MUX_CTL_ENET2_RXC_OFFSET        (0x0114)
#define IOMUXC_MUX_CTL_ENET2_RD0_OFFSET        (0x0118)
#define IOMUXC_MUX_CTL_ENET2_RD1_OFFSET        (0x011c)
#define IOMUXC_MUX_CTL_ENET2_RD2_OFFSET        (0x0120)
#define IOMUXC_MUX_CTL_ENET2_RD3_OFFSET        (0x0124)
#define IOMUXC_MUX_CTL_SD1_CLK_OFFSET          (0x0128)
#define IOMUXC_MUX_CTL_SD1_CMD_OFFSET          (0x012c)
#define IOMUXC_MUX_CTL_SD1_DATA0_OFFSET        (0x0130)
#define IOMUXC_MUX_CTL_SD1_DATA1_OFFSET        (0x0134)
#define IOMUXC_MUX_CTL_SD1_DATA2_OFFSET        (0x0138)
#define IOMUXC_MUX_CTL_SD1_DATA3_OFFSET        (0x013c)
#define IOMUXC_MUX_CTL_SD1_DATA4_OFFSET        (0x0140)
#define IOMUXC_MUX_CTL_SD1_DATA5_OFFSET        (0x0144)
#define IOMUXC_MUX_CTL_SD1_DATA6_OFFSET        (0x0148)
#define IOMUXC_MUX_CTL_SD1_DATA7_OFFSET        (0x014c)
#define IOMUXC_MUX_CTL_SD1_STROBE_OFFSET       (0x0150)
#define IOMUXC_MUX_CTL_SD2_VSELECT_OFFSET      (0x0154)
#define IOMUXC_MUX_CTL_SD3_CLK_OFFSET          (0x0158)
#define IOMUXC_MUX_CTL_SD3_CMD_OFFSET          (0x015c)
#define IOMUXC_MUX_CTL_SD3_DATA0_OFFSET        (0x0160)
#define IOMUXC_MUX_CTL_SD3_DATA1_OFFSET        (0x0164)
#define IOMUXC_MUX_CTL_SD3_DATA2_OFFSET        (0x0168)
#define IOMUXC_MUX_CTL_SD3_DATA3_OFFSET        (0x016c)
#define IOMUXC_MUX_CTL_XSPI1_DATA0_OFFSET      (0x0170)
#define IOMUXC_MUX_CTL_XSPI1_DATA1_OFFSET      (0x0174)
#define IOMUXC_MUX_CTL_XSPI1_DATA2_OFFSET      (0x0178)
#define IOMUXC_MUX_CTL_XSPI1_DATA3_OFFSET      (0x017c)
#define IOMUXC_MUX_CTL_XSPI1_DATA4_OFFSET      (0x0180)
#define IOMUXC_MUX_CTL_XSPI1_DATA5_OFFSET      (0x0184)
#define IOMUXC_MUX_CTL_XSPI1_DATA6_OFFSET      (0x0188)
#define IOMUXC_MUX_CTL_XSPI1_DATA7_OFFSET      (0x018c)
#define IOMUXC_MUX_CTL_XSPI1_DQS_OFFSET        (0x0190)
#define IOMUXC_MUX_CTL_XSPI1_SCLK_OFFSET       (0x0194)
#define IOMUXC_MUX_CTL_XSPI1_SS0_B_OFFSET      (0x0198)
#define IOMUXC_MUX_CTL_XSPI1_SS1_B_OFFSET      (0x019c)
#define IOMUXC_MUX_CTL_SD2_CD_B_OFFSET         (0x01a0)
#define IOMUXC_MUX_CTL_SD2_CLK_OFFSET          (0x01a4)
#define IOMUXC_MUX_CTL_SD2_CMD_OFFSET          (0x01a8)
#define IOMUXC_MUX_CTL_SD2_DATA0_OFFSET        (0x01ac)
#define IOMUXC_MUX_CTL_SD2_DATA1_OFFSET        (0x01b0)
#define IOMUXC_MUX_CTL_SD2_DATA2_OFFSET        (0x01b4)
#define IOMUXC_MUX_CTL_SD2_DATA3_OFFSET        (0x01b8)
#define IOMUXC_MUX_CTL_SD2_RESET_B_OFFSET      (0x01bc)
#define IOMUXC_MUX_CTL_I2C1_SCL_OFFSET         (0x01c0)
#define IOMUXC_MUX_CTL_I2C1_SDA_OFFSET         (0x01c4)
#define IOMUXC_MUX_CTL_I2C2_SCL_OFFSET         (0x01c8)
#define IOMUXC_MUX_CTL_I2C2_SDA_OFFSET         (0x01cc)
#define IOMUXC_MUX_CTL_UART1_RXD_OFFSET        (0x01d0)
#define IOMUXC_MUX_CTL_UART1_TXD_OFFSET        (0x01d4)
#define IOMUXC_MUX_CTL_UART2_RXD_OFFSET        (0x01d8)
#define IOMUXC_MUX_CTL_UART2_TXD_OFFSET        (0x01dc)
#define IOMUXC_MUX_CTL_PDM_CLK_OFFSET          (0x01e0)
#define IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET  (0x01e4)
#define IOMUXC_MUX_CTL_PDM_BIT_STREAM1_OFFSET  (0x01e8)
#define IOMUXC_MUX_CTL_SAI1_TXFS_OFFSET        (0x01ec)
#define IOMUXC_MUX_CTL_SAI1_TXC_OFFSET         (0x01f0)
#define IOMUXC_MUX_CTL_SAI1_TXD0_OFFSET        (0x01f4)
#define IOMUXC_MUX_CTL_SAI1_RXD0_OFFSET        (0x01f8)
#define IOMUXC_MUX_CTL_WDOG_ANY_OFFSET         (0x01fc)

#define IOMUXC_PAD_CTL_DAP_TDI_OFFSET          (0x0204)
#define IOMUXC_PAD_CTL_DAP_TMS_SWDIO_OFFSET    (0x0208)
#define IOMUXC_PAD_CTL_DAP_TCLK_SWCLK_OFFSET   (0x020c)
#define IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET (0x0210)
#define IOMUXC_PAD_CTL_GPIO_IO00_OFFSET        (0x0214)
#define IOMUXC_PAD_CTL_GPIO_IO01_OFFSET        (0x0218)
#define IOMUXC_PAD_CTL_GPIO_IO02_OFFSET        (0x021c)
#define IOMUXC_PAD_CTL_GPIO_IO03_OFFSET        (0x0220)
#define IOMUXC_PAD_CTL_GPIO_IO04_OFFSET        (0x0224)
#define IOMUXC_PAD_CTL_GPIO_IO05_OFFSET        (0x0228)
#define IOMUXC_PAD_CTL_GPIO_IO06_OFFSET        (0x022c)
#define IOMUXC_PAD_CTL_GPIO_IO07_OFFSET        (0x0230)
#define IOMUXC_PAD_CTL_GPIO_IO08_OFFSET        (0x0234)
#define IOMUXC_PAD_CTL_GPIO_IO09_OFFSET        (0x0238)
#define IOMUXC_PAD_CTL_GPIO_IO10_OFFSET        (0x023c)
#define IOMUXC_PAD_CTL_GPIO_IO11_OFFSET        (0x0240)
#define IOMUXC_PAD_CTL_GPIO_IO12_OFFSET        (0x0244)
#define IOMUXC_PAD_CTL_GPIO_IO13_OFFSET        (0x0248)
#define IOMUXC_PAD_CTL_GPIO_IO14_OFFSET        (0x024c)
#define IOMUXC_PAD_CTL_GPIO_IO15_OFFSET        (0x0250)
#define IOMUXC_PAD_CTL_GPIO_IO16_OFFSET        (0x0254)
#define IOMUXC_PAD_CTL_GPIO_IO17_OFFSET        (0x0258)
#define IOMUXC_PAD_CTL_GPIO_IO18_OFFSET        (0x025c)
#define IOMUXC_PAD_CTL_GPIO_IO19_OFFSET        (0x0260)
#define IOMUXC_PAD_CTL_GPIO_IO20_OFFSET        (0x0264)
#define IOMUXC_PAD_CTL_GPIO_IO21_OFFSET        (0x0268)
#define IOMUXC_PAD_CTL_GPIO_IO22_OFFSET        (0x026c)
#define IOMUXC_PAD_CTL_GPIO_IO23_OFFSET        (0x0270)
#define IOMUXC_PAD_CTL_GPIO_IO24_OFFSET        (0x0274)
#define IOMUXC_PAD_CTL_GPIO_IO25_OFFSET        (0x0278)
#define IOMUXC_PAD_CTL_GPIO_IO26_OFFSET        (0x027c)
#define IOMUXC_PAD_CTL_GPIO_IO27_OFFSET        (0x0280)
#define IOMUXC_PAD_CTL_GPIO_IO28_OFFSET        (0x0284)
#define IOMUXC_PAD_CTL_GPIO_IO29_OFFSET        (0x0288)
#define IOMUXC_PAD_CTL_GPIO_IO30_OFFSET        (0x028c)
#define IOMUXC_PAD_CTL_GPIO_IO31_OFFSET        (0x0290)
#define IOMUXC_PAD_CTL_GPIO_IO32_OFFSET        (0x0294)
#define IOMUXC_PAD_CTL_GPIO_IO33_OFFSET        (0x0298)
#define IOMUXC_PAD_CTL_GPIO_IO34_OFFSET        (0x029c)
#define IOMUXC_PAD_CTL_GPIO_IO35_OFFSET        (0x02a0)
#define IOMUXC_PAD_CTL_GPIO_IO36_OFFSET        (0x02a4)
#define IOMUXC_PAD_CTL_GPIO_IO37_OFFSET        (0x02a8)
#define IOMUXC_PAD_CTL_CCM_CLKO1_OFFSET        (0x02ac)
#define IOMUXC_PAD_CTL_CCM_CLKO2_OFFSET        (0x02b0)
#define IOMUXC_PAD_CTL_CCM_CLKO3_OFFSET        (0x02b4)
#define IOMUXC_PAD_CTL_CCM_CLKO4_OFFSET        (0x02b8)
#define IOMUXC_PAD_CTL_ENET1_MDC_OFFSET        (0x02bc)
#define IOMUXC_PAD_CTL_ENET1_MDIO_OFFSET       (0x02c0)
#define IOMUXC_PAD_CTL_ENET1_TD3_OFFSET        (0x02c4)
#define IOMUXC_PAD_CTL_ENET1_TD2_OFFSET        (0x02c8)
#define IOMUXC_PAD_CTL_ENET1_TD1_OFFSET        (0x02cc)
#define IOMUXC_PAD_CTL_ENET1_TD0_OFFSET        (0x02d0)
#define IOMUXC_PAD_CTL_ENET1_TX_CTL_OFFSET     (0x02d4)
#define IOMUXC_PAD_CTL_ENET1_TXC_OFFSET        (0x02d8)
#define IOMUXC_PAD_CTL_ENET1_RX_CTL_OFFSET     (0x02dc)
#define IOMUXC_PAD_CTL_ENET1_RXC_OFFSET        (0x02e0)
#define IOMUXC_PAD_CTL_ENET1_RD0_OFFSET        (0x02e4)
#define IOMUXC_PAD_CTL_ENET1_RD1_OFFSET        (0x02e8)
#define IOMUXC_PAD_CTL_ENET1_RD2_OFFSET        (0x02ec)
#define IOMUXC_PAD_CTL_ENET1_RD3_OFFSET        (0x02f0)
#define IOMUXC_PAD_CTL_ENET2_MDC_OFFSET        (0x02f4)
#define IOMUXC_PAD_CTL_ENET2_MDIO_OFFSET       (0x02f8)
#define IOMUXC_PAD_CTL_ENET2_TD3_OFFSET        (0x02fc)
#define IOMUXC_PAD_CTL_ENET2_TD2_OFFSET        (0x0300)
#define IOMUXC_PAD_CTL_ENET2_TD1_OFFSET        (0x0304)
#define IOMUXC_PAD_CTL_ENET2_TD0_OFFSET        (0x0308)
#define IOMUXC_PAD_CTL_ENET2_TX_CTL_OFFSET     (0x030c)
#define IOMUXC_PAD_CTL_ENET2_TXC_OFFSET        (0x0310)
#define IOMUXC_PAD_CTL_ENET2_RX_CTL_OFFSET     (0x0314)
#define IOMUXC_PAD_CTL_ENET2_RXC_OFFSET        (0x0318)
#define IOMUXC_PAD_CTL_ENET2_RD0_OFFSET        (0x031c)
#define IOMUXC_PAD_CTL_ENET2_RD1_OFFSET        (0x0320)
#define IOMUXC_PAD_CTL_ENET2_RD2_OFFSET        (0x0324)
#define IOMUXC_PAD_CTL_ENET2_RD3_OFFSET        (0x0328)
#define IOMUXC_PAD_CTL_SD1_CLK_OFFSET          (0x032c)
#define IOMUXC_PAD_CTL_SD1_CMD_OFFSET          (0x0330)
#define IOMUXC_PAD_CTL_SD1_DATA0_OFFSET        (0x0334)
#define IOMUXC_PAD_CTL_SD1_DATA1_OFFSET        (0x0338)
#define IOMUXC_PAD_CTL_SD1_DATA2_OFFSET        (0x033c)
#define IOMUXC_PAD_CTL_SD1_DATA3_OFFSET        (0x0340)
#define IOMUXC_PAD_CTL_SD1_DATA4_OFFSET        (0x0344)
#define IOMUXC_PAD_CTL_SD1_DATA5_OFFSET        (0x0348)
#define IOMUXC_PAD_CTL_SD1_DATA6_OFFSET        (0x034c)
#define IOMUXC_PAD_CTL_SD1_DATA7_OFFSET        (0x0350)
#define IOMUXC_PAD_CTL_SD1_STROBE_OFFSET       (0x0354)
#define IOMUXC_PAD_CTL_SD2_VSELECT_OFFSET      (0x0358)
#define IOMUXC_PAD_CTL_SD3_CLK_OFFSET          (0x035c)
#define IOMUXC_PAD_CTL_SD3_CMD_OFFSET          (0x0360)
#define IOMUXC_PAD_CTL_SD3_DATA0_OFFSET        (0x0364)
#define IOMUXC_PAD_CTL_SD3_DATA1_OFFSET        (0x0368)
#define IOMUXC_PAD_CTL_SD3_DATA2_OFFSET        (0x036c)
#define IOMUXC_PAD_CTL_SD3_DATA3_OFFSET        (0x0370)
#define IOMUXC_PAD_CTL_XSPI1_DATA0_OFFSET      (0x0374)
#define IOMUXC_PAD_CTL_XSPI1_DATA1_OFFSET      (0x0378)
#define IOMUXC_PAD_CTL_XSPI1_DATA2_OFFSET      (0x037c)
#define IOMUXC_PAD_CTL_XSPI1_DATA3_OFFSET      (0x0380)
#define IOMUXC_PAD_CTL_XSPI1_DATA4_OFFSET      (0x0384)
#define IOMUXC_PAD_CTL_XSPI1_DATA5_OFFSET      (0x0388)
#define IOMUXC_PAD_CTL_XSPI1_DATA6_OFFSET      (0x038c)
#define IOMUXC_PAD_CTL_XSPI1_DATA7_OFFSET      (0x0390)
#define IOMUXC_PAD_CTL_XSPI1_DQS_OFFSET        (0x0394)
#define IOMUXC_PAD_CTL_XSPI1_SCLK_OFFSET       (0x0398)
#define IOMUXC_PAD_CTL_XSPI1_SS0_B_OFFSET      (0x039c)
#define IOMUXC_PAD_CTL_XSPI1_SS1_B_OFFSET      (0x03a0)
#define IOMUXC_PAD_CTL_SD2_CD_B_OFFSET         (0x03a4)
#define IOMUXC_PAD_CTL_SD2_CLK_OFFSET          (0x03a8)
#define IOMUXC_PAD_CTL_SD2_CMD_OFFSET          (0x03ac)
#define IOMUXC_PAD_CTL_SD2_DATA0_OFFSET        (0x03b0)
#define IOMUXC_PAD_CTL_SD2_DATA1_OFFSET        (0x03b4)
#define IOMUXC_PAD_CTL_SD2_DATA2_OFFSET        (0x03b8)
#define IOMUXC_PAD_CTL_SD2_DATA3_OFFSET        (0x03bc)
#define IOMUXC_PAD_CTL_SD2_RESET_B_OFFSET      (0x03c0)
#define IOMUXC_PAD_CTL_I2C1_SCL_OFFSET         (0x03c4)
#define IOMUXC_PAD_CTL_I2C1_SDA_OFFSET         (0x03c8)
#define IOMUXC_PAD_CTL_I2C2_SCL_OFFSET         (0x03cc)
#define IOMUXC_PAD_CTL_I2C2_SDA_OFFSET         (0x03d0)
#define IOMUXC_PAD_CTL_UART1_RXD_OFFSET        (0x03d4)
#define IOMUXC_PAD_CTL_UART1_TXD_OFFSET        (0x03d8)
#define IOMUXC_PAD_CTL_UART2_RXD_OFFSET        (0x03dc)
#define IOMUXC_PAD_CTL_UART2_TXD_OFFSET        (0x03e0)
#define IOMUXC_PAD_CTL_PDM_CLK_OFFSET          (0x03e4)
#define IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET  (0x03e8)
#define IOMUXC_PAD_CTL_PDM_BIT_STREAM1_OFFSET  (0x03ec)
#define IOMUXC_PAD_CTL_SAI1_TXFS_OFFSET        (0x03f0)
#define IOMUXC_PAD_CTL_SAI1_TXC_OFFSET         (0x03f4)
#define IOMUXC_PAD_CTL_SAI1_TXD0_OFFSET        (0x03f8)
#define IOMUXC_PAD_CTL_SAI1_RXD0_OFFSET        (0x03fc)
#define IOMUXC_PAD_CTL_WDOG_ANY_OFFSET         (0x0400)
#define IOMUXC_PAD_CTL_FCCU_ERR0_OFFSET        (0x0404)

#define IOMUXC_CAN1_IPP_IND_CANRX_SELECT_INPUT_OFFSET              (0x0408)
#define IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_0_OFFSET (0x040c)
#define IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_1_OFFSET (0x0410)
#define IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_2_OFFSET (0x0414)
#define IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_3_OFFSET (0x0418)
#define IOMUXC_SAI1_IPP_IND_SAI_MCLK_SELECT_INPUT_OFFSET           (0x041c)
#define IOMUXC_EXT1_CLK_SELECT_INPUT_OFFSET                        (0x0420)
#define IOMUXC_NETC_CMPLX_EMDC_IN_SELECT_INPUT_OFFSET              (0x0424)
#define IOMUXC_NETC_CMPLX_EMDIO_IN_SELECT_INPUT_OFFSET             (0x0428)
#define IOMUXC_NETC_CMPLX_ETH0_RMII_RX_ER_SELECT_INPUT_OFFSET      (0x042c)
#define IOMUXC_NETC_CMPLX_ETH1_RMII_RX_ER_SELECT_INPUT_OFFSET      (0x0430)
#define IOMUXC_NETC_CMPLX_TMR_1588_TRIG1_SELECT_INPUT_OFFSET       (0x0434)
#define IOMUXC_NETC_CMPLX_TMR_1588_TRIG2_SELECT_INPUT_OFFSET       (0x0438)
#define IOMUXC_SAI2_IPP_IND_SAI_RXDATA_SELECT_INPUT_6_OFFSET       (0x043c)
#define IOMUXC_SAI2_IPP_IND_SAI_RXDATA_SELECT_INPUT_7_OFFSET       (0x0440)
#define IOMUXC_CAN2_IPP_IND_CANRX_SELECT_INPUT_OFFSET              (0x0444)
#define IOMUXC_CAN3_IPP_IND_CANRX_SELECT_INPUT_OFFSET              (0x0448)
#define IOMUXC_CAN4_IPP_IND_CANRX_SELECT_INPUT_OFFSET              (0x044c)
#define IOMUXC_CAN5_IPP_IND_CANRX_SELECT_INPUT_OFFSET              (0x0450)
#define IOMUXC_EARC_PHY_SPDIF_IN_SELECT_INPUT_OFFSET               (0x0454)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_26_OFFSET       (0x0458)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_27_OFFSET       (0x045c)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_30_OFFSET       (0x0460)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_31_OFFSET       (0x0464)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_0_OFFSET        (0x0468)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_1_OFFSET        (0x046c)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_2_OFFSET        (0x0470)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_3_OFFSET        (0x0474)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_4_OFFSET        (0x0478)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_5_OFFSET        (0x047c)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_6_OFFSET        (0x0480)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_7_OFFSET        (0x0484)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_8_OFFSET        (0x0488)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_9_OFFSET        (0x048c)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_10_OFFSET       (0x0490)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_11_OFFSET       (0x0494)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_12_OFFSET       (0x0498)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_13_OFFSET       (0x049c)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_14_OFFSET       (0x04a0)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_15_OFFSET       (0x04a4)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_16_OFFSET       (0x04a8)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_17_OFFSET       (0x04ac)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_18_OFFSET       (0x04b0)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_19_OFFSET       (0x04b4)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_20_OFFSET       (0x04b8)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_21_OFFSET       (0x04bc)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_22_OFFSET       (0x04c0)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_23_OFFSET       (0x04c4)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_24_OFFSET       (0x04c8)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_25_OFFSET       (0x04cc)
#define IOMUXC_FLEXSPI1_I_IPP_IND_DQS_FA_SELECT_INPUT_OFFSET       (0x04d0)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_0_OFFSET      (0x04d4)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_1_OFFSET      (0x04d8)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_2_OFFSET      (0x04dc)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_3_OFFSET      (0x04e0)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_4_OFFSET      (0x04e4)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_5_OFFSET      (0x04e8)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_6_OFFSET      (0x04ec)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_7_OFFSET      (0x04f0)
#define IOMUXC_FLEXSPI1_I_IPP_IND_SCK_FA_SELECT_INPUT_OFFSET       (0x04f4)
#define IOMUXC_I3C2_PIN_SCL_IN_SELECT_INPUT_OFFSET                 (0x04f8)
#define IOMUXC_I3C2_PIN_SDA_IN_SELECT_INPUT_OFFSET                 (0x04fc)
#define IOMUXC_LPI2C3_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET        (0x0500)
#define IOMUXC_LPI2C3_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET        (0x0504)
#define IOMUXC_LPI2C4_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET        (0x0508)
#define IOMUXC_LPI2C4_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET        (0x050c)
#define IOMUXC_LPI2C5_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET        (0x0510)
#define IOMUXC_LPI2C5_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET        (0x0514)
#define IOMUXC_LPI2C6_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET        (0x0518)
#define IOMUXC_LPI2C6_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET        (0x051c)
#define IOMUXC_LPI2C7_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET        (0x0520)
#define IOMUXC_LPI2C7_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET        (0x0524)
#define IOMUXC_LPI2C8_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET        (0x0528)
#define IOMUXC_LPI2C8_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET        (0x052c)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_0_OFFSET      (0x0530)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_1_OFFSET      (0x0534)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_2_OFFSET      (0x0538)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_SCK_SELECT_INPUT_OFFSET        (0x053c)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_SDI_SELECT_INPUT_OFFSET        (0x0540)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_SDO_SELECT_INPUT_OFFSET        (0x0544)
#define IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_0_OFFSET        (0x0548)
#define IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_1_OFFSET        (0x054c)
#define IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_2_OFFSET        (0x0550)
#define IOMUXC_LPUART3_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET    (0x0554)
#define IOMUXC_LPUART3_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET      (0x0558)
#define IOMUXC_LPUART3_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET      (0x055c)
#define IOMUXC_LPUART4_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET    (0x0560)
#define IOMUXC_LPUART4_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET      (0x0564)
#define IOMUXC_LPUART4_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET      (0x0568)
#define IOMUXC_LPUART5_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET    (0x056c)
#define IOMUXC_LPUART5_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET      (0x0570)
#define IOMUXC_LPUART5_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET      (0x0574)
#define IOMUXC_LPUART6_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET    (0x0578)
#define IOMUXC_LPUART6_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET      (0x057c)
#define IOMUXC_LPUART6_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET      (0x0580)
#define IOMUXC_LPUART7_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET      (0x0584)
#define IOMUXC_LPUART7_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET      (0x0588)
#define IOMUXC_SAI3_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET         (0x058c)
#define IOMUXC_SAI3_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET         (0x0590)
#define IOMUXC_SAI4_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET         (0x0594)
#define IOMUXC_SAI4_IPP_IND_SAI_RXDATA_SELECT_INPUT_0_OFFSET       (0x0598)
#define IOMUXC_SAI4_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET         (0x059c)
#define IOMUXC_SAI4_IPP_IND_SAI_TXBCLK_SELECT_INPUT_OFFSET         (0x05a0)
#define IOMUXC_SAI4_IPP_IND_SAI_TXSYNC_SELECT_INPUT_OFFSET         (0x05a4)
#define IOMUXC_SAI5_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET         (0x05a8)
#define IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_0_OFFSET       (0x05ac)
#define IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_1_OFFSET       (0x05b0)
#define IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_2_OFFSET       (0x05b4)
#define IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_3_OFFSET       (0x05b8)
#define IOMUXC_SAI5_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET         (0x05bc)
#define IOMUXC_SAI5_IPP_IND_SAI_TXBCLK_SELECT_INPUT_OFFSET         (0x05c0)
#define IOMUXC_SAI5_IPP_IND_SAI_TXSYNC_SELECT_INPUT_OFFSET         (0x05c4)
#define IOMUXC_USDHC3_IPP_CARD_CLK_IN_SELECT_INPUT_OFFSET          (0x05c8)
#define IOMUXC_USDHC3_IPP_CMD_IN_SELECT_INPUT_OFFSET               (0x05cc)
#define IOMUXC_USDHC3_IPP_DAT0_IN_SELECT_INPUT_OFFSET              (0x05d0)
#define IOMUXC_USDHC3_IPP_DAT1_IN_SELECT_INPUT_OFFSET              (0x05d4)
#define IOMUXC_USDHC3_IPP_DAT2_IN_SELECT_INPUT_OFFSET              (0x05d8)
#define IOMUXC_USDHC3_IPP_DAT3_IN_SELECT_INPUT_OFFSET              (0x05dc)
#define IOMUXC_XSPI_IPP_IND_CS_SELECT_INPUT_OFFSET                 (0x05e0)
#define IOMUXC_XSPI_IPP_IND_DQS_SELECT_INPUT_OFFSET                (0x05e4)
#define IOMUXC_XSPI_IPP_IND_SCK_SELECT_INPUT_OFFSET                (0x05e8)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_0_OFFSET           (0x05ec)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_1_OFFSET           (0x05f0)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_2_OFFSET           (0x05f4)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_3_OFFSET           (0x05f8)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_4_OFFSET           (0x05fc)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_5_OFFSET           (0x0600)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_6_OFFSET           (0x0604)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_7_OFFSET           (0x0608)
#define IOMUXC_JTAG_MUX_TCK_SELECT_INPUT_OFFSET                    (0x060c)
#define IOMUXC_JTAG_MUX_TDI_SELECT_INPUT_OFFSET                    (0x0610)
#define IOMUXC_JTAG_MUX_TMS_SELECT_INPUT_OFFSET                    (0x0614)

#define IOMUXC_MUX_CTL_DAP_TDI          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_DAP_TDI_OFFSET)
#define IOMUXC_MUX_CTL_DAP_TMS_SWDIO    (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_DAP_TMS_SWDIO_OFFSET)
#define IOMUXC_MUX_CTL_DAP_TCLK_SWCLK   (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_DAP_TCLK_SWCLK_OFFSET)
#define IOMUXC_MUX_CTL_DAP_TDO_TRACESWO (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO00        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO00_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO01        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO01_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO02        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO02_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO03        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO03_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO04        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO05        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO06        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO07        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO07_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO08        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO08_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO09        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO09_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO10        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO10_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO11        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO11_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO12        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO13        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO14        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO14_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO15        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO15_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO16        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO17        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO17_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO18        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO18_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO19        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO20        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO21        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO22        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO23        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO24        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO24_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO25        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO26        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO27        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO28        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO28_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO29        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO29_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO30        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO30_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO31        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO31_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO32        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO32_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO33        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO33_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO34        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO34_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO35        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO35_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO36        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO36_OFFSET)
#define IOMUXC_MUX_CTL_GPIO_IO37        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_GPIO_IO37_OFFSET)
#define IOMUXC_MUX_CTL_CCM_CLKO1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_CCM_CLKO1_OFFSET)
#define IOMUXC_MUX_CTL_CCM_CLKO2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_CCM_CLKO2_OFFSET)
#define IOMUXC_MUX_CTL_CCM_CLKO3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_CCM_CLKO3_OFFSET)
#define IOMUXC_MUX_CTL_CCM_CLKO4        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_CCM_CLKO4_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_MDC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_MDC_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_MDIO       (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_MDIO_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TD3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TD3_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TD2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TD2_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TD1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TD0_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TX_CTL_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_TXC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_TXC_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RX_CTL_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RXC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RXC_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RD0_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RD1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RD1_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RD2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RD2_OFFSET)
#define IOMUXC_MUX_CTL_ENET1_RD3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET1_RD3_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_MDC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_MDC_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_MDIO       (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_MDIO_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TD3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TD3_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TD2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TD2_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TD1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TX_CTL_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_TXC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_TXC_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RX_CTL_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RXC        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RXC_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RD1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RD2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_MUX_CTL_ENET2_RD3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_ENET2_RD3_OFFSET)
#define IOMUXC_MUX_CTL_SD1_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_CLK_OFFSET)
#define IOMUXC_MUX_CTL_SD1_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_CMD_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA0_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA1_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA2_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA3_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA4        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA4_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA5        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA5_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA6        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA6_OFFSET)
#define IOMUXC_MUX_CTL_SD1_DATA7        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_DATA7_OFFSET)
#define IOMUXC_MUX_CTL_SD1_STROBE       (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD1_STROBE_OFFSET)
#define IOMUXC_MUX_CTL_SD2_VSELECT      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_VSELECT_OFFSET)
#define IOMUXC_MUX_CTL_SD3_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_CLK_OFFSET)
#define IOMUXC_MUX_CTL_SD3_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_CMD_OFFSET)
#define IOMUXC_MUX_CTL_SD3_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_MUX_CTL_SD3_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_MUX_CTL_SD3_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_MUX_CTL_SD3_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_DATA0      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_DATA0_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_DATA1      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_DATA1_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_DATA2      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_DATA2_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_DATA3      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_DATA3_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_DATA4      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_DATA4_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_DATA5      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_DATA5_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_DATA6      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_DATA6_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_DATA7      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_DATA7_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_DQS        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_DQS_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_SCLK       (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_SCLK_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_SS0_B      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_SS0_B_OFFSET)
#define IOMUXC_MUX_CTL_XSPI1_SS1_B      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_XSPI1_SS1_B_OFFSET)
#define IOMUXC_MUX_CTL_SD2_CD_B         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_CD_B_OFFSET)
#define IOMUXC_MUX_CTL_SD2_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_CLK_OFFSET)
#define IOMUXC_MUX_CTL_SD2_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_CMD_OFFSET)
#define IOMUXC_MUX_CTL_SD2_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_DATA0_OFFSET)
#define IOMUXC_MUX_CTL_SD2_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_DATA1_OFFSET)
#define IOMUXC_MUX_CTL_SD2_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_DATA2_OFFSET)
#define IOMUXC_MUX_CTL_SD2_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_DATA3_OFFSET)
#define IOMUXC_MUX_CTL_SD2_RESET_B      (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SD2_RESET_B_OFFSET)
#define IOMUXC_MUX_CTL_I2C1_SCL         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_I2C1_SCL_OFFSET)
#define IOMUXC_MUX_CTL_I2C1_SDA         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_I2C1_SDA_OFFSET)
#define IOMUXC_MUX_CTL_I2C2_SCL         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_MUX_CTL_I2C2_SDA         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_I2C2_SDA_OFFSET)
#define IOMUXC_MUX_CTL_UART1_RXD        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_UART1_RXD_OFFSET)
#define IOMUXC_MUX_CTL_UART1_TXD        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_UART1_TXD_OFFSET)
#define IOMUXC_MUX_CTL_UART2_RXD        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_UART2_RXD_OFFSET)
#define IOMUXC_MUX_CTL_UART2_TXD        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_UART2_TXD_OFFSET)
#define IOMUXC_MUX_CTL_PDM_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_PDM_CLK_OFFSET)
#define IOMUXC_MUX_CTL_PDM_BIT_STREAM0  (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_MUX_CTL_PDM_BIT_STREAM1  (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_PDM_BIT_STREAM1_OFFSET)
#define IOMUXC_MUX_CTL_SAI1_TXFS        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SAI1_TXFS_OFFSET)
#define IOMUXC_MUX_CTL_SAI1_TXC         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SAI1_TXC_OFFSET)
#define IOMUXC_MUX_CTL_SAI1_TXD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SAI1_TXD0_OFFSET)
#define IOMUXC_MUX_CTL_SAI1_RXD0        (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_SAI1_RXD0_OFFSET)
#define IOMUXC_MUX_CTL_WDOG_ANY         (IMX9_IOMUXC1_BASE + IOMUXC_MUX_CTL_WDOG_ANY_OFFSET)

#define IOMUXC_PAD_CTL_DAP_TDI          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_DAP_TDI_OFFSET)
#define IOMUXC_PAD_CTL_DAP_TMS_SWDIO    (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_DAP_TMS_SWDIO_OFFSET)
#define IOMUXC_PAD_CTL_DAP_TCLK_SWCLK   (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_DAP_TCLK_SWCLK_OFFSET)
#define IOMUXC_PAD_CTL_DAP_TDO_TRACESWO (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO00        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO00_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO01        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO01_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO02        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO02_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO03        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO03_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO04        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO05        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO06        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO07        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO07_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO08        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO08_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO09        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO09_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO10        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO10_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO11        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO11_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO12        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO13        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO14        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO14_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO15        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO15_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO16        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO17        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO17_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO18        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO18_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO19        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO20        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO21        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO22        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO23        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO24        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO24_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO25        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO26        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO27        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO28        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO28_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO29        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO29_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO30        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO30_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO31        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO31_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO32        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO32_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO33        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO33_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO34        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO34_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO35        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO35_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO36        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO36_OFFSET)
#define IOMUXC_PAD_CTL_GPIO_IO37        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_GPIO_IO37_OFFSET)
#define IOMUXC_PAD_CTL_CCM_CLKO1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_CCM_CLKO1_OFFSET)
#define IOMUXC_PAD_CTL_CCM_CLKO2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_CCM_CLKO2_OFFSET)
#define IOMUXC_PAD_CTL_CCM_CLKO3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_CCM_CLKO3_OFFSET)
#define IOMUXC_PAD_CTL_CCM_CLKO4        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_CCM_CLKO4_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_MDC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_MDC_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_MDIO       (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_MDIO_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TD3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TD3_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TD2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TD2_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TD1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TD0_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TX_CTL_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_TXC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_TXC_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RX_CTL_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RXC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RXC_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RD0_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RD1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RD1_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RD2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RD2_OFFSET)
#define IOMUXC_PAD_CTL_ENET1_RD3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET1_RD3_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_MDC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_MDC_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_MDIO       (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_MDIO_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TD3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TD3_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TD2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TD2_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TD1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TX_CTL_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_TXC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_TXC_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RX_CTL     (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RX_CTL_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RXC        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RXC_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RD1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RD2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_PAD_CTL_ENET2_RD3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_ENET2_RD3_OFFSET)
#define IOMUXC_PAD_CTL_SD1_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_CLK_OFFSET)
#define IOMUXC_PAD_CTL_SD1_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_CMD_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA0_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA1_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA2_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA3_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA4        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA4_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA5        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA5_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA6        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA6_OFFSET)
#define IOMUXC_PAD_CTL_SD1_DATA7        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_DATA7_OFFSET)
#define IOMUXC_PAD_CTL_SD1_STROBE       (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD1_STROBE_OFFSET)
#define IOMUXC_PAD_CTL_SD2_VSELECT      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_VSELECT_OFFSET)
#define IOMUXC_PAD_CTL_SD3_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_CLK_OFFSET)
#define IOMUXC_PAD_CTL_SD3_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_CMD_OFFSET)
#define IOMUXC_PAD_CTL_SD3_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_PAD_CTL_SD3_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_PAD_CTL_SD3_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_PAD_CTL_SD3_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_DATA0      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_DATA0_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_DATA1      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_DATA1_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_DATA2      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_DATA2_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_DATA3      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_DATA3_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_DATA4      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_DATA4_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_DATA5      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_DATA5_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_DATA6      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_DATA6_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_DATA7      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_DATA7_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_DQS        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_DQS_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_SCLK       (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_SCLK_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_SS0_B      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_SS0_B_OFFSET)
#define IOMUXC_PAD_CTL_XSPI1_SS1_B      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_XSPI1_SS1_B_OFFSET)
#define IOMUXC_PAD_CTL_SD2_CD_B         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_CD_B_OFFSET)
#define IOMUXC_PAD_CTL_SD2_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_CLK_OFFSET)
#define IOMUXC_PAD_CTL_SD2_CMD          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_CMD_OFFSET)
#define IOMUXC_PAD_CTL_SD2_DATA0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_DATA0_OFFSET)
#define IOMUXC_PAD_CTL_SD2_DATA1        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_DATA1_OFFSET)
#define IOMUXC_PAD_CTL_SD2_DATA2        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_DATA2_OFFSET)
#define IOMUXC_PAD_CTL_SD2_DATA3        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_DATA3_OFFSET)
#define IOMUXC_PAD_CTL_SD2_RESET_B      (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SD2_RESET_B_OFFSET)
#define IOMUXC_PAD_CTL_I2C1_SCL         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_I2C1_SCL_OFFSET)
#define IOMUXC_PAD_CTL_I2C1_SDA         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_I2C1_SDA_OFFSET)
#define IOMUXC_PAD_CTL_I2C2_SCL         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_PAD_CTL_I2C2_SDA         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_I2C2_SDA_OFFSET)
#define IOMUXC_PAD_CTL_UART1_RXD        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_UART1_RXD_OFFSET)
#define IOMUXC_PAD_CTL_UART1_TXD        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_UART1_TXD_OFFSET)
#define IOMUXC_PAD_CTL_UART2_RXD        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_UART2_RXD_OFFSET)
#define IOMUXC_PAD_CTL_UART2_TXD        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_UART2_TXD_OFFSET)
#define IOMUXC_PAD_CTL_PDM_CLK          (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_PDM_CLK_OFFSET)
#define IOMUXC_PAD_CTL_PDM_BIT_STREAM0  (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_PAD_CTL_PDM_BIT_STREAM1  (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_PDM_BIT_STREAM1_OFFSET)
#define IOMUXC_PAD_CTL_SAI1_TXFS        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SAI1_TXFS_OFFSET)
#define IOMUXC_PAD_CTL_SAI1_TXC         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SAI1_TXC_OFFSET)
#define IOMUXC_PAD_CTL_SAI1_TXD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SAI1_TXD0_OFFSET)
#define IOMUXC_PAD_CTL_SAI1_RXD0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_SAI1_RXD0_OFFSET)
#define IOMUXC_PAD_CTL_WDOG_ANY         (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_WDOG_ANY_OFFSET)
#define IOMUXC_PAD_CTL_FCCU_ERR0        (IMX9_IOMUXC1_BASE + IOMUXC_PAD_CTL_FCCU_ERR0_OFFSET)

#define IOMUXC_CAN1_IPP_IND_CANRX_SELECT_INPUT              (IMX9_IOMUXC1_BASE + IOMUXC_CAN1_IPP_IND_CANRX_SELECT_INPUT_OFFSET)
#define IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_0 (IMX9_IOMUXC1_BASE + IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_0_OFFSET)
#define IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_1 (IMX9_IOMUXC1_BASE + IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_1_OFFSET)
#define IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_2 (IMX9_IOMUXC1_BASE + IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_2_OFFSET)
#define IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_3 (IMX9_IOMUXC1_BASE + IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_3_OFFSET)
#define IOMUXC_SAI1_IPP_IND_SAI_MCLK_SELECT_INPUT           (IMX9_IOMUXC1_BASE + IOMUXC_SAI1_IPP_IND_SAI_MCLK_SELECT_INPUT_OFFSET)
#define IOMUXC_EXT1_CLK_SELECT_INPUT                        (IMX9_IOMUXC1_BASE + IOMUXC_EXT1_CLK_SELECT_INPUT_OFFSET)
#define IOMUXC_NETC_CMPLX_EMDC_IN_SELECT_INPUT              (IMX9_IOMUXC1_BASE + IOMUXC_NETC_CMPLX_EMDC_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_NETC_CMPLX_EMDIO_IN_SELECT_INPUT             (IMX9_IOMUXC1_BASE + IOMUXC_NETC_CMPLX_EMDIO_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_NETC_CMPLX_ETH0_RMII_RX_ER_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_NETC_CMPLX_ETH0_RMII_RX_ER_SELECT_INPUT_OFFSET)
#define IOMUXC_NETC_CMPLX_ETH1_RMII_RX_ER_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_NETC_CMPLX_ETH1_RMII_RX_ER_SELECT_INPUT_OFFSET)
#define IOMUXC_NETC_CMPLX_TMR_1588_TRIG1_SELECT_INPUT       (IMX9_IOMUXC1_BASE + IOMUXC_NETC_CMPLX_TMR_1588_TRIG1_SELECT_INPUT_OFFSET)
#define IOMUXC_NETC_CMPLX_TMR_1588_TRIG2_SELECT_INPUT       (IMX9_IOMUXC1_BASE + IOMUXC_NETC_CMPLX_TMR_1588_TRIG2_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI2_IPP_IND_SAI_RXDATA_SELECT_INPUT_6       (IMX9_IOMUXC1_BASE + IOMUXC_SAI2_IPP_IND_SAI_RXDATA_SELECT_INPUT_6_OFFSET)
#define IOMUXC_SAI2_IPP_IND_SAI_RXDATA_SELECT_INPUT_7       (IMX9_IOMUXC1_BASE + IOMUXC_SAI2_IPP_IND_SAI_RXDATA_SELECT_INPUT_7_OFFSET)
#define IOMUXC_CAN2_IPP_IND_CANRX_SELECT_INPUT              (IMX9_IOMUXC1_BASE + IOMUXC_CAN2_IPP_IND_CANRX_SELECT_INPUT_OFFSET)
#define IOMUXC_CAN3_IPP_IND_CANRX_SELECT_INPUT              (IMX9_IOMUXC1_BASE + IOMUXC_CAN3_IPP_IND_CANRX_SELECT_INPUT_OFFSET)
#define IOMUXC_CAN4_IPP_IND_CANRX_SELECT_INPUT              (IMX9_IOMUXC1_BASE + IOMUXC_CAN4_IPP_IND_CANRX_SELECT_INPUT_OFFSET)
#define IOMUXC_CAN5_IPP_IND_CANRX_SELECT_INPUT              (IMX9_IOMUXC1_BASE + IOMUXC_CAN5_IPP_IND_CANRX_SELECT_INPUT_OFFSET)
#define IOMUXC_EARC_PHY_SPDIF_IN_SELECT_INPUT               (IMX9_IOMUXC1_BASE + IOMUXC_EARC_PHY_SPDIF_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_26       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_26_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_27       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_27_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_30       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_30_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_31       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_31_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_0        (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_0_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_1        (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_1_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_2        (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_2_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_3        (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_3_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_4        (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_4_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_5        (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_5_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_6        (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_6_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_7        (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_7_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_8        (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_8_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_9        (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_9_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_10       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_10_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_11       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_11_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_12       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_12_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_13       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_13_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_14       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_14_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_15       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_15_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_16       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_16_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_17       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_17_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_18       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_18_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_19       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_19_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_20       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_20_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_21       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_21_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_22       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_22_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_23       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_23_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_24       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_24_OFFSET)
#define IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_25       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_25_OFFSET)
#define IOMUXC_FLEXSPI1_I_IPP_IND_DQS_FA_SELECT_INPUT       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXSPI1_I_IPP_IND_DQS_FA_SELECT_INPUT_OFFSET)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_0      (IMX9_IOMUXC1_BASE + IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_0_OFFSET)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_1      (IMX9_IOMUXC1_BASE + IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_1_OFFSET)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_2      (IMX9_IOMUXC1_BASE + IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_2_OFFSET)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_3      (IMX9_IOMUXC1_BASE + IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_3_OFFSET)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_4      (IMX9_IOMUXC1_BASE + IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_4_OFFSET)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_5      (IMX9_IOMUXC1_BASE + IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_5_OFFSET)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_6      (IMX9_IOMUXC1_BASE + IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_6_OFFSET)
#define IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_7      (IMX9_IOMUXC1_BASE + IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_7_OFFSET)
#define IOMUXC_FLEXSPI1_I_IPP_IND_SCK_FA_SELECT_INPUT       (IMX9_IOMUXC1_BASE + IOMUXC_FLEXSPI1_I_IPP_IND_SCK_FA_SELECT_INPUT_OFFSET)
#define IOMUXC_I3C2_PIN_SCL_IN_SELECT_INPUT                 (IMX9_IOMUXC1_BASE + IOMUXC_I3C2_PIN_SCL_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_I3C2_PIN_SDA_IN_SELECT_INPUT                 (IMX9_IOMUXC1_BASE + IOMUXC_I3C2_PIN_SDA_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C3_IPP_IND_LPI2C_SCL_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C3_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C3_IPP_IND_LPI2C_SDA_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C3_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C4_IPP_IND_LPI2C_SCL_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C4_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C4_IPP_IND_LPI2C_SDA_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C4_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C5_IPP_IND_LPI2C_SCL_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C5_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C5_IPP_IND_LPI2C_SDA_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C5_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C6_IPP_IND_LPI2C_SCL_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C6_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C6_IPP_IND_LPI2C_SDA_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C6_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C7_IPP_IND_LPI2C_SCL_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C7_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C7_IPP_IND_LPI2C_SDA_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C7_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C8_IPP_IND_LPI2C_SCL_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C8_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET)
#define IOMUXC_LPI2C8_IPP_IND_LPI2C_SDA_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPI2C8_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_0      (IMX9_IOMUXC1_BASE + IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_0_OFFSET)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_1      (IMX9_IOMUXC1_BASE + IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_1_OFFSET)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_2      (IMX9_IOMUXC1_BASE + IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_2_OFFSET)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_SCK_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPSPI4_IPP_IND_LPSPI_SCK_SELECT_INPUT_OFFSET)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_SDI_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPSPI4_IPP_IND_LPSPI_SDI_SELECT_INPUT_OFFSET)
#define IOMUXC_LPSPI4_IPP_IND_LPSPI_SDO_SELECT_INPUT        (IMX9_IOMUXC1_BASE + IOMUXC_LPSPI4_IPP_IND_LPSPI_SDO_SELECT_INPUT_OFFSET)
#define IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_0        (IMX9_IOMUXC1_BASE + IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_0_OFFSET)
#define IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_1        (IMX9_IOMUXC1_BASE + IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_1_OFFSET)
#define IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_2        (IMX9_IOMUXC1_BASE + IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_2_OFFSET)
#define IOMUXC_LPUART3_IPP_IND_LPUART_CTS_N_SELECT_INPUT    (IMX9_IOMUXC1_BASE + IOMUXC_LPUART3_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART3_IPP_IND_LPUART_RXD_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_LPUART3_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART3_IPP_IND_LPUART_TXD_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_LPUART3_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART4_IPP_IND_LPUART_CTS_N_SELECT_INPUT    (IMX9_IOMUXC1_BASE + IOMUXC_LPUART4_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART4_IPP_IND_LPUART_RXD_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_LPUART4_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART4_IPP_IND_LPUART_TXD_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_LPUART4_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART5_IPP_IND_LPUART_CTS_N_SELECT_INPUT    (IMX9_IOMUXC1_BASE + IOMUXC_LPUART5_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART5_IPP_IND_LPUART_RXD_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_LPUART5_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART5_IPP_IND_LPUART_TXD_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_LPUART5_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART6_IPP_IND_LPUART_CTS_N_SELECT_INPUT    (IMX9_IOMUXC1_BASE + IOMUXC_LPUART6_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART6_IPP_IND_LPUART_RXD_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_LPUART6_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART6_IPP_IND_LPUART_TXD_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_LPUART6_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART7_IPP_IND_LPUART_RXD_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_LPUART7_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET)
#define IOMUXC_LPUART7_IPP_IND_LPUART_TXD_SELECT_INPUT      (IMX9_IOMUXC1_BASE + IOMUXC_LPUART7_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI3_IPP_IND_SAI_RXBCLK_SELECT_INPUT         (IMX9_IOMUXC1_BASE + IOMUXC_SAI3_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI3_IPP_IND_SAI_RXSYNC_SELECT_INPUT         (IMX9_IOMUXC1_BASE + IOMUXC_SAI3_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI4_IPP_IND_SAI_RXBCLK_SELECT_INPUT         (IMX9_IOMUXC1_BASE + IOMUXC_SAI4_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI4_IPP_IND_SAI_RXDATA_SELECT_INPUT_0       (IMX9_IOMUXC1_BASE + IOMUXC_SAI4_IPP_IND_SAI_RXDATA_SELECT_INPUT_0_OFFSET)
#define IOMUXC_SAI4_IPP_IND_SAI_RXSYNC_SELECT_INPUT         (IMX9_IOMUXC1_BASE + IOMUXC_SAI4_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI4_IPP_IND_SAI_TXBCLK_SELECT_INPUT         (IMX9_IOMUXC1_BASE + IOMUXC_SAI4_IPP_IND_SAI_TXBCLK_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI4_IPP_IND_SAI_TXSYNC_SELECT_INPUT         (IMX9_IOMUXC1_BASE + IOMUXC_SAI4_IPP_IND_SAI_TXSYNC_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI5_IPP_IND_SAI_RXBCLK_SELECT_INPUT         (IMX9_IOMUXC1_BASE + IOMUXC_SAI5_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_0       (IMX9_IOMUXC1_BASE + IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_0_OFFSET)
#define IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_1       (IMX9_IOMUXC1_BASE + IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_1_OFFSET)
#define IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_2       (IMX9_IOMUXC1_BASE + IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_2_OFFSET)
#define IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_3       (IMX9_IOMUXC1_BASE + IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_3_OFFSET)
#define IOMUXC_SAI5_IPP_IND_SAI_RXSYNC_SELECT_INPUT         (IMX9_IOMUXC1_BASE + IOMUXC_SAI5_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI5_IPP_IND_SAI_TXBCLK_SELECT_INPUT         (IMX9_IOMUXC1_BASE + IOMUXC_SAI5_IPP_IND_SAI_TXBCLK_SELECT_INPUT_OFFSET)
#define IOMUXC_SAI5_IPP_IND_SAI_TXSYNC_SELECT_INPUT         (IMX9_IOMUXC1_BASE + IOMUXC_SAI5_IPP_IND_SAI_TXSYNC_SELECT_INPUT_OFFSET)
#define IOMUXC_USDHC3_IPP_CARD_CLK_IN_SELECT_INPUT          (IMX9_IOMUXC1_BASE + IOMUXC_USDHC3_IPP_CARD_CLK_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_USDHC3_IPP_CMD_IN_SELECT_INPUT               (IMX9_IOMUXC1_BASE + IOMUXC_USDHC3_IPP_CMD_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_USDHC3_IPP_DAT0_IN_SELECT_INPUT              (IMX9_IOMUXC1_BASE + IOMUXC_USDHC3_IPP_DAT0_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_USDHC3_IPP_DAT1_IN_SELECT_INPUT              (IMX9_IOMUXC1_BASE + IOMUXC_USDHC3_IPP_DAT1_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_USDHC3_IPP_DAT2_IN_SELECT_INPUT              (IMX9_IOMUXC1_BASE + IOMUXC_USDHC3_IPP_DAT2_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_USDHC3_IPP_DAT3_IN_SELECT_INPUT              (IMX9_IOMUXC1_BASE + IOMUXC_USDHC3_IPP_DAT3_IN_SELECT_INPUT_OFFSET)
#define IOMUXC_XSPI_IPP_IND_CS_SELECT_INPUT                 (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_IPP_IND_CS_SELECT_INPUT_OFFSET)
#define IOMUXC_XSPI_IPP_IND_DQS_SELECT_INPUT                (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_IPP_IND_DQS_SELECT_INPUT_OFFSET)
#define IOMUXC_XSPI_IPP_IND_SCK_SELECT_INPUT                (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_IPP_IND_SCK_SELECT_INPUT_OFFSET)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_0           (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_0_OFFSET)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_1           (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_1_OFFSET)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_2           (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_2_OFFSET)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_3           (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_3_OFFSET)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_4           (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_4_OFFSET)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_5           (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_5_OFFSET)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_6           (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_6_OFFSET)
#define IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_7           (IMX9_IOMUXC1_BASE + IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_7_OFFSET)
#define IOMUXC_JTAG_MUX_TCK_SELECT_INPUT                    (IMX9_IOMUXC1_BASE + IOMUXC_JTAG_MUX_TCK_SELECT_INPUT_OFFSET)
#define IOMUXC_JTAG_MUX_TDI_SELECT_INPUT                    (IMX9_IOMUXC1_BASE + IOMUXC_JTAG_MUX_TDI_SELECT_INPUT_OFFSET)
#define IOMUXC_JTAG_MUX_TMS_SELECT_INPUT                    (IMX9_IOMUXC1_BASE + IOMUXC_JTAG_MUX_TMS_SELECT_INPUT_OFFSET)

#endif /* __ARCH_ARM64_IMX9_IMX95_IOMUXC_H*/
