/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GetOpSteps implements IMapOpStep
{
    READ{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            Object record = recordStore.getRecordOrNull(state.getKey(), false);
            if (record != null) {
                Object oldValue = record.getValue();
                state.setOldValue(oldValue);
                state.setRecordExistsInMemory(true);
            }
        }

        @Override
        public Step nextStep(State state) {
            return state.getOldValue() == null ? LOAD : RESPONSE;
        }
    }
    ,
    LOAD{

        @Override
        public boolean isLoadStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            BiTuple<Object, Long> loadedValueWithExpiry = ((DefaultRecordStore)recordStore).loadValueWithExpiry(state.getKey(), state.getNow());
            state.setLoadedOldValueWithExpiry(loadedValueWithExpiry);
            if (loadedValueWithExpiry != null) {
                state.setOldValue(loadedValueWithExpiry.element1);
            }
        }

        @Override
        public Step nextStep(State state) {
            return state.getLoadedOldValueWithExpiry() == null ? RESPONSE : ON_LOAD;
        }
    }
    ,
    ON_LOAD{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            Record record = ((DefaultRecordStore)recordStore).onLoadRecord(state.getKey(), state.getLoadedOldValueWithExpiry(), false, state.getCallerAddress(), state.getNow());
            record = recordStore.evictIfExpired(state.getKey(), state.getNow(), false) ? null : record;
            state.setOldValue(record == null ? null : record.getValue());
        }

        @Override
        public Step nextStep(State state) {
            return RESPONSE;
        }
    }
    ,
    RESPONSE{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            MapContainer mapContainer = recordStore.getMapContainer();
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            Object oldValue = state.getOldValue();
            oldValue = mapServiceContext.interceptGet(mapContainer.getInterceptorRegistry(), oldValue);
            state.setOldValue(oldValue);
            Object record = recordStore.getRecord(state.getKey());
            if (record != null) {
                recordStore.accessRecord(state.getKey(), (Record)record, state.getNow());
            }
        }

        @Override
        public Step nextStep(State state) {
            return UtilSteps.FINAL_STEP;
        }
    };

}

