/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.splitbrainprotection.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.services.MembershipAwareService;
import com.hazelcast.internal.services.MembershipServiceEvent;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.services.ServiceNamespaceAware;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.executor.ExecutorType;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.EventPublishingService;
import com.hazelcast.spi.impl.eventservice.EventService;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.NamedOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.splitbrainprotection.HeartbeatAware;
import com.hazelcast.splitbrainprotection.PingAware;
import com.hazelcast.splitbrainprotection.SplitBrainProtection;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionEvent;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionFunction;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionListener;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionOn;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.splitbrainprotection.impl.ProbabilisticSplitBrainProtectionFunction;
import com.hazelcast.splitbrainprotection.impl.RecentlyActiveSplitBrainProtectionFunction;
import com.hazelcast.splitbrainprotection.impl.SplitBrainProtectionImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SplitBrainProtectionServiceImpl
implements EventPublishingService<SplitBrainProtectionEvent, SplitBrainProtectionListener>,
MembershipAwareService,
SplitBrainProtectionService,
HeartbeatAware,
PingAware {
    public static final String SERVICE_NAME = "hz:impl:splitBrainProtectionService";
    private static final String SPLIT_BRAIN_PROTECTION_EXECUTOR = "hz:splitBrainProtection";
    private final NodeEngineImpl nodeEngine;
    private final EventService eventService;
    private final ClassLoader classLoader;
    private volatile Map<String, SplitBrainProtectionImpl> splitBrainProtections;
    private volatile boolean heartbeatAware;
    private volatile boolean pingAware;

    public SplitBrainProtectionServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.eventService = nodeEngine.getEventService();
        this.classLoader = NamespaceUtil.getClassLoaderForNamespace(nodeEngine, null);
    }

    public void start() {
        this.splitBrainProtections = Collections.unmodifiableMap(this.initializeSplitBrainProtections());
        this.scanSplitBrainProtections();
        this.initializeListeners();
        if (this.isInactive()) {
            return;
        }
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.register(SPLIT_BRAIN_PROTECTION_EXECUTOR, 1, Integer.MAX_VALUE, ExecutorType.CACHED);
        long heartbeatInterval = this.nodeEngine.getProperties().getSeconds(ClusterProperty.HEARTBEAT_INTERVAL_SECONDS);
        executionService.scheduleWithRepetition(SPLIT_BRAIN_PROTECTION_EXECUTOR, new UpdateSplitBrainProtections(), heartbeatInterval, heartbeatInterval, TimeUnit.SECONDS);
    }

    private Map<String, SplitBrainProtectionImpl> initializeSplitBrainProtections() {
        HashMap<String, SplitBrainProtectionImpl> splitBrainProtections = new HashMap<String, SplitBrainProtectionImpl>();
        for (SplitBrainProtectionConfig splitBrainProtectionConfig : this.nodeEngine.getConfig().getSplitBrainProtectionConfigs().values()) {
            this.validateSplitBrainProtectionConfig(splitBrainProtectionConfig);
            if (!splitBrainProtectionConfig.isEnabled()) continue;
            SplitBrainProtectionImpl splitBrainProtection = new SplitBrainProtectionImpl(splitBrainProtectionConfig, this.nodeEngine);
            splitBrainProtections.put(splitBrainProtectionConfig.getName(), splitBrainProtection);
        }
        return splitBrainProtections;
    }

    private void validateSplitBrainProtectionConfig(SplitBrainProtectionConfig splitBrainProtectionConfig) {
        if (splitBrainProtectionConfig.getFunctionImplementation() == null) {
            return;
        }
        SplitBrainProtectionFunction splitBrainProtectionFunction = splitBrainProtectionConfig.getFunctionImplementation();
        if (splitBrainProtectionFunction instanceof ProbabilisticSplitBrainProtectionFunction) {
            ProbabilisticSplitBrainProtectionFunction function = (ProbabilisticSplitBrainProtectionFunction)splitBrainProtectionFunction;
            this.validateSplitBrainProtectionParameters(splitBrainProtectionConfig.getName(), function.getAcceptableHeartbeatPauseMillis(), "acceptable heartbeat pause");
        } else if (splitBrainProtectionFunction instanceof RecentlyActiveSplitBrainProtectionFunction) {
            RecentlyActiveSplitBrainProtectionFunction function = (RecentlyActiveSplitBrainProtectionFunction)splitBrainProtectionFunction;
            this.validateSplitBrainProtectionParameters(splitBrainProtectionConfig.getName(), function.getHeartbeatToleranceMillis(), "heartbeat tolerance");
        }
    }

    private void validateSplitBrainProtectionParameters(String splitBrainProtectionName, long value, String parameterName) {
        HazelcastProperties nodeProperties = this.nodeEngine.getProperties();
        long maxNoHeartbeatMillis = nodeProperties.getMillis(ClusterProperty.MAX_NO_HEARTBEAT_SECONDS);
        long heartbeatIntervalMillis = nodeProperties.getMillis(ClusterProperty.HEARTBEAT_INTERVAL_SECONDS);
        if (value > maxNoHeartbeatMillis) {
            throw new InvalidConfigurationException("This member is configured with maximum no-heartbeat duration " + maxNoHeartbeatMillis + " millis. For the split brain protection '" + splitBrainProtectionName + "' to be effective, set " + parameterName + " to a lower value. Currently configured value is " + value + ", reconfigure to a value lower than " + maxNoHeartbeatMillis + ".");
        }
        if (value < heartbeatIntervalMillis) {
            throw new InvalidConfigurationException("Split brain protection '" + splitBrainProtectionName + "' is misconfigured: the value of acceptable heartbeat pause (" + value + ") must be greater than the configured heartbeat interval (" + heartbeatIntervalMillis + "), otherwise split brain protection will be always absent.");
        }
    }

    private void initializeListeners() {
        for (Map.Entry<String, SplitBrainProtectionConfig> configEntry : this.nodeEngine.getConfig().getSplitBrainProtectionConfigs().entrySet()) {
            SplitBrainProtectionConfig config = configEntry.getValue();
            String instanceName = configEntry.getKey();
            for (SplitBrainProtectionListenerConfig listenerConfig : config.getListenerConfigs()) {
                this.initializeListenerInternal(instanceName, listenerConfig);
            }
        }
    }

    private void initializeListenerInternal(String instanceName, SplitBrainProtectionListenerConfig listenerConfig) {
        SplitBrainProtectionListener listener = null;
        if (listenerConfig.getImplementation() != null) {
            listener = listenerConfig.getImplementation();
        } else if (listenerConfig.getClassName() != null) {
            try {
                listener = (SplitBrainProtectionListener)ClassLoaderUtil.newInstance(this.classLoader, listenerConfig.getClassName());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (listener != null) {
            if (listener instanceof HazelcastInstanceAware) {
                HazelcastInstanceAware aware = (HazelcastInstanceAware)((Object)listener);
                aware.setHazelcastInstance(this.nodeEngine.getHazelcastInstance());
            }
            this.addSplitBrainProtectionListener(instanceName, listener);
        }
    }

    private void scanSplitBrainProtections() {
        for (SplitBrainProtectionImpl splitBrainProtection : this.splitBrainProtections.values()) {
            if (splitBrainProtection.isHeartbeatAware()) {
                this.heartbeatAware = true;
            }
            if (!splitBrainProtection.isPingAware()) continue;
            this.pingAware = true;
        }
    }

    private boolean isInactive() {
        return this.splitBrainProtections.isEmpty();
    }

    public void addSplitBrainProtectionListener(String name, SplitBrainProtectionListener listener) {
        this.eventService.registerLocalListener(SERVICE_NAME, name, listener);
    }

    public void ensureNoSplitBrain(Operation op) {
        if (this.isInactive()) {
            return;
        }
        SplitBrainProtectionImpl splitBrainProtection = this.findSplitBrainProtection(op);
        if (splitBrainProtection == null) {
            return;
        }
        splitBrainProtection.ensureNoSplitBrain(op);
    }

    @Override
    public void ensureNoSplitBrain(@Nullable String splitBrainProtectionName, @Nonnull SplitBrainProtectionOn requiredSplitBrainProtectionPermissionType) {
        Preconditions.checkNotNull(requiredSplitBrainProtectionPermissionType, "requiredSplitBrainProtectionPermissionType cannot be null!");
        if (this.isInactive() || splitBrainProtectionName == null) {
            return;
        }
        SplitBrainProtectionImpl definedSplitBrainProtection = this.splitBrainProtections.get(splitBrainProtectionName);
        if (definedSplitBrainProtection == null) {
            return;
        }
        SplitBrainProtectionOn definedSplitBrainProtectionOn = definedSplitBrainProtection.getConfig().getProtectOn();
        switch (requiredSplitBrainProtectionPermissionType) {
            case WRITE: {
                if (!definedSplitBrainProtectionOn.equals((Object)SplitBrainProtectionOn.WRITE) && !definedSplitBrainProtectionOn.equals((Object)SplitBrainProtectionOn.READ_WRITE)) break;
                definedSplitBrainProtection.ensureNoSplitBrain();
                break;
            }
            case READ: {
                if (!definedSplitBrainProtectionOn.equals((Object)SplitBrainProtectionOn.READ) && !definedSplitBrainProtectionOn.equals((Object)SplitBrainProtectionOn.READ_WRITE)) break;
                definedSplitBrainProtection.ensureNoSplitBrain();
                break;
            }
            case READ_WRITE: {
                if (!definedSplitBrainProtectionOn.equals((Object)SplitBrainProtectionOn.READ_WRITE)) break;
                definedSplitBrainProtection.ensureNoSplitBrain();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled split brain protection type: " + requiredSplitBrainProtectionPermissionType);
            }
        }
    }

    private SplitBrainProtectionImpl findSplitBrainProtection(Operation op) {
        if (!this.isNamedOperation(op)) {
            return null;
        }
        SplitBrainProtectionAwareService service = this.getSplitBrainProtectionAwareService(op);
        if (service == null) {
            return null;
        }
        String name = ((NamedOperation)((Object)op)).getName();
        String splitBrainProtectionName = service.getSplitBrainProtectionName(name);
        if (splitBrainProtectionName == null) {
            return null;
        }
        return this.splitBrainProtections.get(splitBrainProtectionName);
    }

    private SplitBrainProtectionAwareService getSplitBrainProtectionAwareService(Operation op) {
        Object service;
        if (op instanceof ServiceNamespaceAware) {
            ServiceNamespaceAware aware = (ServiceNamespaceAware)((Object)op);
            ServiceNamespace serviceNamespace = aware.getServiceNamespace();
            service = this.nodeEngine.getService(serviceNamespace.getServiceName());
        } else {
            service = op.getService();
        }
        if (service instanceof SplitBrainProtectionAwareService) {
            SplitBrainProtectionAwareService awareService = (SplitBrainProtectionAwareService)service;
            return awareService;
        }
        return null;
    }

    private boolean isNamedOperation(Operation op) {
        return op instanceof NamedOperation;
    }

    @Override
    public void dispatchEvent(SplitBrainProtectionEvent event, SplitBrainProtectionListener listener) {
        NamespaceUtil.runWithClassLoader(this.classLoader, () -> listener.onChange(event));
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
        if (this.isInactive() || event.getMember().localMember()) {
            return;
        }
        this.nodeEngine.getExecutionService().execute(SPLIT_BRAIN_PROTECTION_EXECUTOR, new UpdateSplitBrainProtections(event));
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        if (this.isInactive()) {
            return;
        }
        this.nodeEngine.getExecutionService().execute(SPLIT_BRAIN_PROTECTION_EXECUTOR, new UpdateSplitBrainProtections(event));
    }

    @Override
    @Nonnull
    public SplitBrainProtection getSplitBrainProtection(@Nonnull String splitBrainProtectionName) {
        Preconditions.checkNotNull(splitBrainProtectionName, "splitBrainProtectionName cannot be null!");
        SplitBrainProtection splitBrainProtection = this.splitBrainProtections.get(splitBrainProtectionName);
        if (splitBrainProtection == null) {
            throw new IllegalArgumentException("No split brain protection configuration named [ " + splitBrainProtectionName + " ] is found!");
        }
        return splitBrainProtection;
    }

    @Override
    public void onHeartbeat(Member member, long timestamp) {
        if (this.isInactive() || !this.heartbeatAware) {
            return;
        }
        this.nodeEngine.getExecutionService().execute(SPLIT_BRAIN_PROTECTION_EXECUTOR, new OnHeartbeat(member, timestamp));
    }

    @Override
    public void onPingLost(Member member) {
        if (this.isInactive() || !this.pingAware) {
            return;
        }
        this.nodeEngine.getExecutionService().execute(SPLIT_BRAIN_PROTECTION_EXECUTOR, new OnPing(member, false));
    }

    @Override
    public void onPingRestored(Member member) {
        if (this.isInactive() || !this.pingAware) {
            return;
        }
        this.nodeEngine.getExecutionService().execute(SPLIT_BRAIN_PROTECTION_EXECUTOR, new OnPing(member, true));
    }

    private class UpdateSplitBrainProtections
    implements Runnable {
        private final MembershipEvent event;

        UpdateSplitBrainProtections() {
            this.event = null;
        }

        UpdateSplitBrainProtections(MembershipEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            ClusterService clusterService = SplitBrainProtectionServiceImpl.this.nodeEngine.getClusterService();
            Collection<Member> members = clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
            for (SplitBrainProtectionImpl splitBrainProtection : SplitBrainProtectionServiceImpl.this.splitBrainProtections.values()) {
                if (this.event != null) {
                    switch (this.event.getEventType()) {
                        case 1: {
                            splitBrainProtection.onMemberAdded(this.event);
                            break;
                        }
                        case 2: {
                            splitBrainProtection.onMemberRemoved(this.event);
                            break;
                        }
                    }
                }
                splitBrainProtection.update(members);
            }
        }
    }

    private class OnHeartbeat
    implements Runnable {
        private final Member member;
        private final long timestamp;

        OnHeartbeat(Member member, long timestamp) {
            this.member = member;
            this.timestamp = timestamp;
        }

        @Override
        public void run() {
            ClusterService clusterService = SplitBrainProtectionServiceImpl.this.nodeEngine.getClusterService();
            Collection<Member> members = clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
            for (SplitBrainProtectionImpl splitBrainProtection : SplitBrainProtectionServiceImpl.this.splitBrainProtections.values()) {
                splitBrainProtection.onHeartbeat(this.member, this.timestamp);
                splitBrainProtection.update(members);
            }
        }
    }

    private class OnPing
    implements Runnable {
        private final Member member;
        private final boolean successful;

        OnPing(Member member, boolean successful) {
            this.member = member;
            this.successful = successful;
        }

        @Override
        public void run() {
            ClusterService clusterService = SplitBrainProtectionServiceImpl.this.nodeEngine.getClusterService();
            Collection<Member> members = clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
            for (SplitBrainProtectionImpl splitBrainProtection : SplitBrainProtectionServiceImpl.this.splitBrainProtections.values()) {
                splitBrainProtection.onPing(this.member, this.successful);
                splitBrainProtection.update(members);
            }
        }
    }
}

