/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.cdx;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.netpreserve.jwarc.cdx.CdxFormat;
import org.netpreserve.jwarc.cdx.CdxRecord;

public class CdxReader
implements Iterable<CdxRecord>,
Closeable {
    private final BufferedReader reader;
    private CdxFormat format;

    public CdxReader(InputStream stream) {
        this(new BufferedReader(new InputStreamReader(stream, StandardCharsets.US_ASCII)));
    }

    CdxReader(BufferedReader reader) {
        this.reader = reader;
    }

    public Optional<CdxRecord> next() throws IOException {
        String line = this.reader.readLine();
        while (line != null) {
            if (!line.isEmpty() && !line.startsWith("#")) {
                if (line.startsWith(" CDX ") || line.startsWith("CDX ")) {
                    this.format = new CdxFormat(line);
                } else {
                    return Optional.of(new CdxRecord(line, this.format));
                }
            }
            line = this.reader.readLine();
        }
        return Optional.empty();
    }

    @Override
    public Iterator<CdxRecord> iterator() {
        return new Iterator<CdxRecord>(){
            private CdxRecord next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = CdxReader.this.next().orElse(null);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return this.next != null;
            }

            @Override
            public CdxRecord next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                CdxRecord record = this.next;
                this.next = null;
                return record;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

