/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.job;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.job.AbstractSourceDocumentSpecs;
import org.jodconverter.core.job.AbstractTargetDocumentSpecs;
import org.jodconverter.core.job.ConversionJobWithOptionalTargetFormatUnspecified;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.util.AssertUtils;

public abstract class AbstractConversionJob
implements ConversionJobWithOptionalTargetFormatUnspecified {
    protected final AbstractSourceDocumentSpecs source;
    protected final AbstractTargetDocumentSpecs target;

    protected AbstractConversionJob(@NonNull AbstractSourceDocumentSpecs source, @NonNull AbstractTargetDocumentSpecs target) {
        AssertUtils.notNull(source, "source must not be null");
        AssertUtils.notNull(target, "target must not be null");
        this.source = source;
        this.target = target;
    }

    @Override
    public @NonNull AbstractConversionJob as(@NonNull DocumentFormat format) {
        this.target.setDocumentFormat(format);
        return this;
    }

    @Override
    public final void execute() throws OfficeException {
        AssertUtils.notNull(this.target.getFormat(), "The target format is missing or not supported");
        this.doExecute();
    }

    protected abstract void doExecute() throws OfficeException;
}

