/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.client.operation;

import org.kurento.client.KurentoObject;
import org.kurento.client.internal.client.ListenerSubscriptionImpl;
import org.kurento.client.internal.client.RemoteObjectEventListener;
import org.kurento.client.internal.client.operation.Operation;
import org.kurento.client.internal.transport.jsonrpc.RomClientJsonRpcClient;

public class SubscriptionOperation
extends Operation {
    private KurentoObject kurentoObject;
    private String eventType;
    private RemoteObjectEventListener listener;
    private ListenerSubscriptionImpl listenerSubscription;

    public SubscriptionOperation(KurentoObject object, String eventType, RemoteObjectEventListener listener) {
        this.kurentoObject = object;
        this.eventType = eventType;
        this.listener = listener;
        this.listenerSubscription = new ListenerSubscriptionImpl(eventType, listener);
    }

    public ListenerSubscriptionImpl getListenerSubscription() {
        return this.listenerSubscription;
    }

    @Override
    public RomClientJsonRpcClient.RequestAndResponseType createRequest(RomClientJsonRpcClient romClientJsonRpcClient) {
        return romClientJsonRpcClient.createSubscribeRequest(this.getObjectRef(this.kurentoObject), this.eventType);
    }

    @Override
    public void processResponse(Object response) {
        this.listenerSubscription.setSubscription((String)response);
        this.getRemoteObject(this.kurentoObject).addEventListener(this.eventType, this.listener);
    }

    @Override
    public String getDescription() {
        return "Event subscription of type " + this.eventType + " in object '" + this.getObjectRef(this.kurentoObject) + "'";
    }
}

