/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jqplot.lib.chart;

import java.util.Collection;
import org.wicketstuff.jqplot.lib.ChartConfiguration;
import org.wicketstuff.jqplot.lib.JqPlotResources;
import org.wicketstuff.jqplot.lib.chart.AbstractChart;
import org.wicketstuff.jqplot.lib.data.LineSeriesData;
import org.wicketstuff.jqplot.lib.data.item.LineSeriesItem;
import org.wicketstuff.jqplot.lib.elements.Title;
import org.wicketstuff.jqplot.lib.metadata.JqPlotPlugin;

@JqPlotPlugin(values={JqPlotResources.CanvasTextRenderer, JqPlotResources.CategoryAxisRenderer, JqPlotResources.CanvasAxisLabelRenderer, JqPlotResources.CanvasAxisTickRenderer, JqPlotResources.CanvasOverlay, JqPlotResources.DateAxisRenderer})
public class LineSeriesChart<I extends Number, V extends Number>
extends AbstractChart<LineSeriesData<I, V>, String> {
    private static final long serialVersionUID = -563079287340319412L;
    private final ChartConfiguration<String> chartConfig;
    private LineSeriesData<I, V> data = new LineSeriesData();

    public LineSeriesChart(String title) {
        this(title, null, null);
    }

    public LineSeriesChart(String title, String labelX, String labelY) {
        this.chartConfig = new ChartConfiguration();
        this.chartConfig.setTitle(new Title(title)).setLabelX(labelX).setLabelY(labelY);
    }

    @Override
    public LineSeriesData<I, V> getChartData() {
        return this.data;
    }

    public void addValue(Collection<LineSeriesItem<I, V>> value) {
        this.data.addValue(value);
    }

    public void addValues(Collection<LineSeriesItem<I, V>> ... values) {
        this.data.addValues(values);
    }

    @Override
    public ChartConfiguration<String> getChartConfiguration() {
        return this.chartConfig;
    }
}

