/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util;

import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.util.string.StringValue;

public class CallbackFunctionHelper {
    private CallbackFunctionHelper() {
    }

    private static StringBuilder getNamedFunctionStr(String name, AbstractDefaultAjaxBehavior b, CallbackParameter ... extraParameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("function ").append(name).append("(");
        boolean first = true;
        for (CallbackParameter curExtraParameter : extraParameters) {
            if (curExtraParameter.getFunctionParameterName() == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(curExtraParameter.getFunctionParameterName());
        }
        sb.append(") {\n");
        sb.append(b.getCallbackFunctionBody(extraParameters));
        sb.append("}\n");
        return sb;
    }

    public static StringValue getParam(Component cmp, String name) {
        return cmp.getRequest().getRequestParameters().getParameterValue(name);
    }

    public static JavaScriptHeaderItem getNamedFunction(String name, AbstractDefaultAjaxBehavior b, CallbackParameter ... extraParameters) {
        String uid = UUID.randomUUID().toString();
        return JavaScriptHeaderItem.forScript((CharSequence)CallbackFunctionHelper.getNamedFunctionStr(name, b, extraParameters), (String)String.format("%s-%s", name, uid));
    }
}

