/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.tabs;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class Collapsible
extends Panel {
    private static final long serialVersionUID = 1L;
    private final List<ITab> tabs;
    private final IModel<Integer> activeTab;

    public Collapsible(String markupId, List<ITab> tabs) {
        this(markupId, tabs, (IModel<Integer>)Model.of((Serializable)Integer.valueOf(0)));
    }

    public Collapsible(String markupId, List<ITab> tabs, IModel<Integer> activeTab) {
        super(markupId, activeTab);
        this.tabs = tabs;
        this.activeTab = activeTab;
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.newTabList("tabs", this.tabs)});
        BootstrapResourcesBehavior.addTo((Component)this);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        Attributes.addClass(tag, "accordion");
    }

    protected Component newTabList(String markupId, List<ITab> tabs) {
        return new Loop(markupId, tabs.size()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(LoopItem loopItem) {
                CharSequence parentMarkupId = Strings2.getMarkupId((Component)Collapsible.this);
                ITab tab = Collapsible.this.tabs.get(loopItem.getIndex());
                State state = ((Integer)Collapsible.this.activeTab.getObject()).equals(loopItem.getIndex()) ? State.Active : State.Inactive;
                Component container = Collapsible.this.newContainer("body", tab, state);
                String containerMarkupId = container.getMarkupId(true);
                Component title = Collapsible.this.newTitle("title", tab, state);
                title.add(new Behavior[]{new AttributeModifier("data-bs-parent", (Serializable)((Object)("#" + String.valueOf(parentMarkupId))))});
                title.add(new Behavior[]{new AttributeModifier("data-bs-target", (Serializable)((Object)("#" + containerMarkupId)))});
                title.add(new Behavior[]{new AttributeModifier("aria-controls", (Serializable)((Object)containerMarkupId))});
                container.add(new Behavior[]{new AttributeModifier("data-bs-parent", (Serializable)((Object)("#" + String.valueOf(parentMarkupId))))});
                container.add(new Behavior[]{new AttributeModifier("aria-labelledby", (Serializable)((Object)("#" + title.getMarkupId(true))))});
                loopItem.add(new Component[]{title});
                loopItem.add(new Component[]{container});
            }
        };
    }

    protected CssClassNameAppender getActiveCssClassNameAppender() {
        return new CssClassNameAppender("show");
    }

    protected Component newContainer(String markupId, ITab tab, State state) {
        WebMarkupContainer container = new WebMarkupContainer(markupId);
        container.setOutputMarkupId(true);
        container.add(new Component[]{tab.getPanel("content")});
        if (State.Active.equals((Object)state)) {
            container.add(new Behavior[]{new AttributeModifier("aria-expand", (Serializable)((Object)"true"))});
            container.add(new Behavior[]{this.getActiveCssClassNameAppender()});
        } else {
            container.add(new Behavior[]{new AttributeModifier("aria-expand", (Serializable)((Object)"false"))});
        }
        return container;
    }

    protected Component newTitle(String markupId, ITab tab, State state) {
        return new Label(markupId, tab.getTitle());
    }

    public static enum State {
        Active,
        Inactive;

    }
}

