/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.annotation.Beta;
import java.util.Objects;
import javax.annotation.Nonnull;

@Beta
public final class ClientTpcConfig {
    private boolean enabled;
    private int connectionCount;

    public ClientTpcConfig() {
        this.setEnabled(Boolean.parseBoolean(System.getProperty("hazelcast.client.tpc.enabled", "false")));
        this.setConnectionCount(Integer.getInteger("hazelcast.client.tpc.connectionCount", 1));
    }

    public ClientTpcConfig(@Nonnull ClientTpcConfig tpcConfig) {
        this.enabled = tpcConfig.enabled;
        this.connectionCount = tpcConfig.connectionCount;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ClientTpcConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ClientTpcConfig setConnectionCount(int connectionCount) {
        this.connectionCount = Preconditions.checkNotNegative(connectionCount, "connectionCount");
        return this;
    }

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientTpcConfig that = (ClientTpcConfig)o;
        if (that.enabled != this.enabled) {
            return false;
        }
        return that.connectionCount == this.connectionCount;
    }

    public int hashCode() {
        return Objects.hash(this.enabled) + 31 * this.connectionCount;
    }

    public String toString() {
        return "ClientTpcConfig{enabled=" + this.enabled + ", connectionCount=" + this.connectionCount + "}";
    }
}

