/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.net;

import com.hazelcast.internal.tpcengine.logging.TpcLogger;
import com.hazelcast.internal.tpcengine.logging.TpcLoggerLocator;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractAsyncSocket
implements Closeable {
    protected final ConcurrentMap<?, ?> context = new ConcurrentHashMap();
    protected final TpcLogger logger = TpcLoggerLocator.getLogger(this.getClass());
    protected final AtomicReference<State> state = new AtomicReference<State>(State.OPEN);
    private volatile String closeReason;
    private volatile Throwable closeCause;
    private CloseListener closeListener;
    private Executor closeExecutor;
    private boolean closeListenerChecked;

    public final ConcurrentMap<?, ?> context() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCloseListener(CloseListener listener, Executor executor) {
        boolean closeListenerChecked0;
        Preconditions.checkNotNull(executor, "executor");
        Preconditions.checkNotNull(listener, "listener");
        AbstractAsyncSocket abstractAsyncSocket = this;
        synchronized (abstractAsyncSocket) {
            if (this.closeListener != null) {
                throw new IllegalStateException("Can't reset the closeListener");
            }
            this.closeExecutor = executor;
            this.closeListener = listener;
            closeListenerChecked0 = this.closeListenerChecked;
        }
        if (closeListenerChecked0) {
            this.notifyCloseListener(listener, executor);
        }
    }

    public final boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    @Override
    public final void close() {
        this.close(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(String reason, Throwable cause) {
        Executor closeExecutor0;
        CloseListener closeListener0;
        if (!this.state.compareAndSet(State.OPEN, State.CLOSING)) {
            return;
        }
        this.closeReason = reason;
        this.closeCause = cause;
        if (cause == null) {
            if (this.logger.isInfoEnabled()) {
                if (reason == null) {
                    this.logger.info("Closing  " + this);
                } else {
                    this.logger.info("Closing " + this + " due to " + reason);
                }
            }
        } else if (this.logger.isWarningEnabled()) {
            if (reason == null) {
                this.logger.warning("Closing  " + this, cause);
            } else {
                this.logger.warning("Closing " + this + " due to " + reason, cause);
            }
        }
        try {
            this.close0();
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        finally {
            this.state.set(State.CLOSED);
        }
        AbstractAsyncSocket abstractAsyncSocket = this;
        synchronized (abstractAsyncSocket) {
            this.closeListenerChecked = true;
            closeListener0 = this.closeListener;
            closeExecutor0 = this.closeExecutor;
        }
        if (closeListener0 != null) {
            this.notifyCloseListener(closeListener0, closeExecutor0);
        }
    }

    private void notifyCloseListener(CloseListener closeListener, Executor closeExecutor) {
        closeExecutor.execute(() -> {
            try {
                closeListener.onClose(this);
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        });
    }

    protected abstract void close0() throws IOException;

    public String getCloseReason() {
        return this.closeReason;
    }

    public Throwable getCloseCause() {
        return this.closeCause;
    }

    protected static enum State {
        OPEN,
        CLOSING,
        CLOSED;

    }

    public static interface CloseListener {
        public void onClose(AbstractAsyncSocket var1);
    }
}

