/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.passwordExpired_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.passwordExpired.PasswordExpiredResponse;
import org.apache.directory.api.ldap.extras.controls.passwordExpired.PasswordExpiredResponseImpl;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.util.Strings;

public class PasswordExpiredResponseFactory
extends AbstractControlFactory<PasswordExpiredResponse> {
    public PasswordExpiredResponseFactory(LdapApiService codec) {
        super(codec, "2.16.840.1.113730.3.4.4");
    }

    @Override
    public PasswordExpiredResponse newControl() {
        return new PasswordExpiredResponseImpl();
    }

    @Override
    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        try {
            if (!Strings.utf8ToString(controlBytes).equals("0")) {
                throw new DecoderException(I18n.err(I18n.ERR_08110_BAD_PASSWORD_EXPIRED_VALUE, Strings.dumpBytes(controlBytes)));
            }
        }
        catch (RuntimeException re) {
            throw new DecoderException(re.getMessage());
        }
    }

    @Override
    public void encodeValue(Asn1Buffer buffer, Control control) {
        buffer.put((byte)48);
    }
}

